<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for przesylkaPaletowaType StructType
 * @subpackage Structs
 */
class PrzesylkaPaletowaType extends PrzesylkaRejestrowanaType
{
    /**
     * The paleta
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var PaletaType
     */
    public $paleta;
    /**
     * The miejsceOdbioru
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var AdresType
     */
    public $miejsceOdbioru;
    /**
     * The miejsceDoreczenia
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var AdresType
     */
    public $miejsceDoreczenia;
    /**
     * The platnik
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var PlatnikType
     */
    public $platnik;
    /**
     * The pobranie
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var PobranieType
     */
    public $pobranie;
    /**
     * The subPaleta
     * Meta informations extracted from the WSDL
     * - maxOccurs: 32
     * - minOccurs: 0
     * @var SubPrzesylkaPaletowaType[]
     */
    public $subPaleta;
    /**
     * The daneSent
     * Meta informations extracted from the WSDL
     * - maxOccurs: 10
     * - minOccurs: 0
     * @var DaneSentType[]
     */
    public $daneSent;
    /**
     * The awizacja
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var AwizacjaType
     */
    public $awizacja;
    /**
     * The zawartosc
     * @var string
     */
    public $zawartosc;
    /**
     * The masa
     * Meta informations extracted from the WSDL
     * - documentation: masa przesyłki podana w gramach
     * - base: xsd:int
     * - maxInclusive: 9999999
     * - minInclusive: 1
     * @var int
     */
    public $masa;
    /**
     * The dataZaladunku
     * @var string
     */
    public $dataZaladunku;
    /**
     * The dataDostawy
     * @var string
     */
    public $dataDostawy;
    /**
     * The wartosc
     * Meta informations extracted from the WSDL
     * - documentation: zadeklarowana wartość przesyłki w groszach
     * - base: xsd:int
     * - maxInclusive: 9999999
     * - minInclusive: 0
     * @var int
     */
    public $wartosc;
    /**
     * The iloscZwracanychPaletEUR
     * @var int
     */
    public $iloscZwracanychPaletEUR;
    /**
     * The zalaczonaFV
     * @var string
     */
    public $zalaczonaFV;
    /**
     * The zalaczonyWZ
     * @var string
     */
    public $zalaczonyWZ;
    /**
     * The zalaczoneInne
     * @var string
     */
    public $zalaczoneInne;
    /**
     * The zwracanaFV
     * @var string
     */
    public $zwracanaFV;
    /**
     * The zwracanyWZ
     * @var string
     */
    public $zwracanyWZ;
    /**
     * The zwracaneInne
     * @var string
     */
    public $zwracaneInne;
    /**
     * The powiadomienieNadawcy
     * @var string
     */
    public $powiadomienieNadawcy;
    /**
     * The powiadomienieOdbiorcy
     * @var string
     */
    public $powiadomienieOdbiorcy;
    /**
     * The dostawaWSobote
     * @var bool
     */
    public $dostawaWSobote;
    /**
     * The przygotowanieDokumentowPrzewozowych
     * @var bool
     */
    public $przygotowanieDokumentowPrzewozowych;
    /**
     * The dostawaSamochodemDedykowanym
     * @var bool
     */
    public $dostawaSamochodemDedykowanym;
    /**
     * The zmianaDanychAdresowych
     * @var bool
     */
    public $zmianaDanychAdresowych;
    /**
     * The ustalenieTerminuDostawy
     * @var bool
     */
    public $ustalenieTerminuDostawy;
    /**
     * The samochodZWinda
     * @var bool
     */
    public $samochodZWinda;
    /**
     * The zabranieOpakowania
     * @var bool
     */
    public $zabranieOpakowania;
    /**
     * The wniesienie
     * @var bool
     */
    public $wniesienie;
    /**
     * The awizoSMS
     * @var bool
     */
    public $awizoSMS;
    /**
     * Constructor method for przesylkaPaletowaType
     * @uses PrzesylkaPaletowaType::setPaleta()
     * @uses PrzesylkaPaletowaType::setMiejsceOdbioru()
     * @uses PrzesylkaPaletowaType::setMiejsceDoreczenia()
     * @uses PrzesylkaPaletowaType::setPlatnik()
     * @uses PrzesylkaPaletowaType::setPobranie()
     * @uses PrzesylkaPaletowaType::setSubPaleta()
     * @uses PrzesylkaPaletowaType::setDaneSent()
     * @uses PrzesylkaPaletowaType::setAwizacja()
     * @uses PrzesylkaPaletowaType::setZawartosc()
     * @uses PrzesylkaPaletowaType::setMasa()
     * @uses PrzesylkaPaletowaType::setDataZaladunku()
     * @uses PrzesylkaPaletowaType::setDataDostawy()
     * @uses PrzesylkaPaletowaType::setWartosc()
     * @uses PrzesylkaPaletowaType::setIloscZwracanychPaletEUR()
     * @uses PrzesylkaPaletowaType::setZalaczonaFV()
     * @uses PrzesylkaPaletowaType::setZalaczonyWZ()
     * @uses PrzesylkaPaletowaType::setZalaczoneInne()
     * @uses PrzesylkaPaletowaType::setZwracanaFV()
     * @uses PrzesylkaPaletowaType::setZwracanyWZ()
     * @uses PrzesylkaPaletowaType::setZwracaneInne()
     * @uses PrzesylkaPaletowaType::setPowiadomienieNadawcy()
     * @uses PrzesylkaPaletowaType::setPowiadomienieOdbiorcy()
     * @uses PrzesylkaPaletowaType::setDostawaWSobote()
     * @uses PrzesylkaPaletowaType::setPrzygotowanieDokumentowPrzewozowych()
     * @uses PrzesylkaPaletowaType::setDostawaSamochodemDedykowanym()
     * @uses PrzesylkaPaletowaType::setZmianaDanychAdresowych()
     * @uses PrzesylkaPaletowaType::setUstalenieTerminuDostawy()
     * @uses PrzesylkaPaletowaType::setSamochodZWinda()
     * @uses PrzesylkaPaletowaType::setZabranieOpakowania()
     * @uses PrzesylkaPaletowaType::setWniesienie()
     * @uses PrzesylkaPaletowaType::setAwizoSMS()
     * @param PaletaType $paleta
     * @param AdresType $miejsceOdbioru
     * @param AdresType $miejsceDoreczenia
     * @param PlatnikType $platnik
     * @param PobranieType $pobranie
     * @param SubPrzesylkaPaletowaType[] $subPaleta
     * @param DaneSentType[] $daneSent
     * @param AwizacjaType $awizacja
     * @param string $zawartosc
     * @param int $masa
     * @param string $dataZaladunku
     * @param string $dataDostawy
     * @param int $wartosc
     * @param int $iloscZwracanychPaletEUR
     * @param string $zalaczonaFV
     * @param string $zalaczonyWZ
     * @param string $zalaczoneInne
     * @param string $zwracanaFV
     * @param string $zwracanyWZ
     * @param string $zwracaneInne
     * @param string $powiadomienieNadawcy
     * @param string $powiadomienieOdbiorcy
     * @param bool $dostawaWSobote
     * @param bool $przygotowanieDokumentowPrzewozowych
     * @param bool $dostawaSamochodemDedykowanym
     * @param bool $zmianaDanychAdresowych
     * @param bool $ustalenieTerminuDostawy
     * @param bool $samochodZWinda
     * @param bool $zabranieOpakowania
     * @param bool $wniesienie
     * @param bool $awizoSMS
     */
    public function __construct(PaletaType $paleta = null, AdresType $miejsceOdbioru = null, AdresType $miejsceDoreczenia = null, PlatnikType $platnik = null, PobranieType $pobranie = null, array $subPaleta = array(), array $daneSent = array(), AwizacjaType $awizacja = null, $zawartosc = null, $masa = null, $dataZaladunku = null, $dataDostawy = null, $wartosc = null, $iloscZwracanychPaletEUR = null, $zalaczonaFV = null, $zalaczonyWZ = null, $zalaczoneInne = null, $zwracanaFV = null, $zwracanyWZ = null, $zwracaneInne = null, $powiadomienieNadawcy = null, $powiadomienieOdbiorcy = null, $dostawaWSobote = null, $przygotowanieDokumentowPrzewozowych = null, $dostawaSamochodemDedykowanym = null, $zmianaDanychAdresowych = null, $ustalenieTerminuDostawy = null, $samochodZWinda = null, $zabranieOpakowania = null, $wniesienie = null, $awizoSMS = null)
    {
        $this
            ->setPaleta($paleta)
            ->setMiejsceOdbioru($miejsceOdbioru)
            ->setMiejsceDoreczenia($miejsceDoreczenia)
            ->setPlatnik($platnik)
            ->setPobranie($pobranie)
            ->setSubPaleta($subPaleta)
            ->setDaneSent($daneSent)
            ->setAwizacja($awizacja)
            ->setZawartosc($zawartosc)
            ->setMasa($masa)
            ->setDataZaladunku($dataZaladunku)
            ->setDataDostawy($dataDostawy)
            ->setWartosc($wartosc)
            ->setIloscZwracanychPaletEUR($iloscZwracanychPaletEUR)
            ->setZalaczonaFV($zalaczonaFV)
            ->setZalaczonyWZ($zalaczonyWZ)
            ->setZalaczoneInne($zalaczoneInne)
            ->setZwracanaFV($zwracanaFV)
            ->setZwracanyWZ($zwracanyWZ)
            ->setZwracaneInne($zwracaneInne)
            ->setPowiadomienieNadawcy($powiadomienieNadawcy)
            ->setPowiadomienieOdbiorcy($powiadomienieOdbiorcy)
            ->setDostawaWSobote($dostawaWSobote)
            ->setPrzygotowanieDokumentowPrzewozowych($przygotowanieDokumentowPrzewozowych)
            ->setDostawaSamochodemDedykowanym($dostawaSamochodemDedykowanym)
            ->setZmianaDanychAdresowych($zmianaDanychAdresowych)
            ->setUstalenieTerminuDostawy($ustalenieTerminuDostawy)
            ->setSamochodZWinda($samochodZWinda)
            ->setZabranieOpakowania($zabranieOpakowania)
            ->setWniesienie($wniesienie)
            ->setAwizoSMS($awizoSMS);
    }
    /**
     * Get paleta value
     * @return PaletaType
     */
    public function getPaleta()
    {
        return $this->paleta;
    }
    /**
     * Set paleta value
     * @param PaletaType $paleta
     * @return PrzesylkaPaletowaType
     */
    public function setPaleta(PaletaType $paleta = null)
    {
        $this->paleta = $paleta;
        return $this;
    }
    /**
     * Get miejsceOdbioru value
     * @return AdresType|null
     */
    public function getMiejsceOdbioru()
    {
        return $this->miejsceOdbioru;
    }
    /**
     * Set miejsceOdbioru value
     * @param AdresType $miejsceOdbioru
     * @return PrzesylkaPaletowaType
     */
    public function setMiejsceOdbioru(AdresType $miejsceOdbioru = null)
    {
        $this->miejsceOdbioru = $miejsceOdbioru;
        return $this;
    }
    /**
     * Get miejsceDoreczenia value
     * @return AdresType|null
     */
    public function getMiejsceDoreczenia()
    {
        return $this->miejsceDoreczenia;
    }
    /**
     * Set miejsceDoreczenia value
     * @param AdresType $miejsceDoreczenia
     * @return PrzesylkaPaletowaType
     */
    public function setMiejsceDoreczenia(AdresType $miejsceDoreczenia = null)
    {
        $this->miejsceDoreczenia = $miejsceDoreczenia;
        return $this;
    }
    /**
     * Get platnik value
     * @return PlatnikType|null
     */
    public function getPlatnik()
    {
        return $this->platnik;
    }
    /**
     * Set platnik value
     * @param PlatnikType $platnik
     * @return PrzesylkaPaletowaType
     */
    public function setPlatnik(PlatnikType $platnik = null)
    {
        $this->platnik = $platnik;
        return $this;
    }
    /**
     * Get pobranie value
     * @return PobranieType|null
     */
    public function getPobranie()
    {
        return $this->pobranie;
    }
    /**
     * Set pobranie value
     * @param PobranieType $pobranie
     * @return PrzesylkaPaletowaType
     */
    public function setPobranie(PobranieType $pobranie = null)
    {
        $this->pobranie = $pobranie;
        return $this;
    }
    /**
     * Get subPaleta value
     * @return SubPrzesylkaPaletowaType[]|null
     */
    public function getSubPaleta()
    {
        return $this->subPaleta;
    }
    /**
     * Set subPaleta value
     * @param SubPrzesylkaPaletowaType[] $subPaleta
     * @return PrzesylkaPaletowaType
     */
    public function setSubPaleta(array $subPaleta = array())
    {
        $this->subPaleta = $subPaleta;
        return $this;
    }
    /**
     * Add item to subPaleta value
     * @throws \InvalidArgumentException
     * @param SubPrzesylkaPaletowaType $item
     * @return PrzesylkaPaletowaType
     */
    public function addToSubPaleta(SubPrzesylkaPaletowaType $item)
    {
        $this->subPaleta[] = $item;
        return $this;
    }
    /**
     * Get daneSent value
     * @return DaneSentType[]|null
     */
    public function getDaneSent()
    {
        return $this->daneSent;
    }
    /**
     * Set daneSent value
     * @param DaneSentType[] $daneSent
     * @return PrzesylkaPaletowaType
     */
    public function setDaneSent(array $daneSent = array())
    {
        $this->daneSent = $daneSent;
        return $this;
    }
    /**
     * Add item to daneSent value
     * @throws \InvalidArgumentException
     * @param DaneSentType $item
     * @return PrzesylkaPaletowaType
     */
    public function addToDaneSent(DaneSentType $item)
    {
        $this->daneSent[] = $item;
        return $this;
    }
    /**
     * Get awizacja value
     * @return AwizacjaType|null
     */
    public function getAwizacja()
    {
        return $this->awizacja;
    }
    /**
     * Set awizacja value
     * @param AwizacjaType $awizacja
     * @return PrzesylkaPaletowaType
     */
    public function setAwizacja(AwizacjaType $awizacja = null)
    {
        $this->awizacja = $awizacja;
        return $this;
    }
    /**
     * Get zawartosc value
     * @return string|null
     */
    public function getZawartosc()
    {
        return $this->zawartosc;
    }
    /**
     * Set zawartosc value
     * @param string $zawartosc
     * @return PrzesylkaPaletowaType
     */
    public function setZawartosc($zawartosc = null)
    {
        $this->zawartosc = $zawartosc;
        return $this;
    }
    /**
     * Get masa value
     * @return int|null
     */
    public function getMasa()
    {
        return $this->masa;
    }
    /**
     * Set masa value
     * @param int $masa
     * @return PrzesylkaPaletowaType
     */
    public function setMasa($masa = null)
    {
        $this->masa = $masa;
        return $this;
    }
    /**
     * Get dataZaladunku value
     * @return string|null
     */
    public function getDataZaladunku()
    {
        return $this->dataZaladunku;
    }
    /**
     * Set dataZaladunku value
     * @param string $dataZaladunku
     * @return PrzesylkaPaletowaType
     */
    public function setDataZaladunku($dataZaladunku = null)
    {
        $this->dataZaladunku = $dataZaladunku;
        return $this;
    }
    /**
     * Get dataDostawy value
     * @return string|null
     */
    public function getDataDostawy()
    {
        return $this->dataDostawy;
    }
    /**
     * Set dataDostawy value
     * @param string $dataDostawy
     * @return PrzesylkaPaletowaType
     */
    public function setDataDostawy($dataDostawy = null)
    {
        $this->dataDostawy = $dataDostawy;
        return $this;
    }
    /**
     * Get wartosc value
     * @return int|null
     */
    public function getWartosc()
    {
        return $this->wartosc;
    }
    /**
     * Set wartosc value
     * @param int $wartosc
     * @return PrzesylkaPaletowaType
     */
    public function setWartosc($wartosc = null)
    {
        $this->wartosc = $wartosc;
        return $this;
    }
    /**
     * Get iloscZwracanychPaletEUR value
     * @return int|null
     */
    public function getIloscZwracanychPaletEUR()
    {
        return $this->iloscZwracanychPaletEUR;
    }
    /**
     * Set iloscZwracanychPaletEUR value
     * @param int $iloscZwracanychPaletEUR
     * @return PrzesylkaPaletowaType
     */
    public function setIloscZwracanychPaletEUR($iloscZwracanychPaletEUR = null)
    {
        $this->iloscZwracanychPaletEUR = $iloscZwracanychPaletEUR;
        return $this;
    }
    /**
     * Get zalaczonaFV value
     * @return string|null
     */
    public function getZalaczonaFV()
    {
        return $this->zalaczonaFV;
    }
    /**
     * Set zalaczonaFV value
     * @param string $zalaczonaFV
     * @return PrzesylkaPaletowaType
     */
    public function setZalaczonaFV($zalaczonaFV = null)
    {
        $this->zalaczonaFV = $zalaczonaFV;
        return $this;
    }
    /**
     * Get zalaczonyWZ value
     * @return string|null
     */
    public function getZalaczonyWZ()
    {
        return $this->zalaczonyWZ;
    }
    /**
     * Set zalaczonyWZ value
     * @param string $zalaczonyWZ
     * @return PrzesylkaPaletowaType
     */
    public function setZalaczonyWZ($zalaczonyWZ = null)
    {
        $this->zalaczonyWZ = $zalaczonyWZ;
        return $this;
    }
    /**
     * Get zalaczoneInne value
     * @return string|null
     */
    public function getZalaczoneInne()
    {
        return $this->zalaczoneInne;
    }
    /**
     * Set zalaczoneInne value
     * @param string $zalaczoneInne
     * @return PrzesylkaPaletowaType
     */
    public function setZalaczoneInne($zalaczoneInne = null)
    {
        $this->zalaczoneInne = $zalaczoneInne;
        return $this;
    }
    /**
     * Get zwracanaFV value
     * @return string|null
     */
    public function getZwracanaFV()
    {
        return $this->zwracanaFV;
    }
    /**
     * Set zwracanaFV value
     * @param string $zwracanaFV
     * @return PrzesylkaPaletowaType
     */
    public function setZwracanaFV($zwracanaFV = null)
    {
        $this->zwracanaFV = $zwracanaFV;
        return $this;
    }
    /**
     * Get zwracanyWZ value
     * @return string|null
     */
    public function getZwracanyWZ()
    {
        return $this->zwracanyWZ;
    }
    /**
     * Set zwracanyWZ value
     * @param string $zwracanyWZ
     * @return PrzesylkaPaletowaType
     */
    public function setZwracanyWZ($zwracanyWZ = null)
    {
        $this->zwracanyWZ = $zwracanyWZ;
        return $this;
    }
    /**
     * Get zwracaneInne value
     * @return string|null
     */
    public function getZwracaneInne()
    {
        return $this->zwracaneInne;
    }
    /**
     * Set zwracaneInne value
     * @param string $zwracaneInne
     * @return PrzesylkaPaletowaType
     */
    public function setZwracaneInne($zwracaneInne = null)
    {
        $this->zwracaneInne = $zwracaneInne;
        return $this;
    }
    /**
     * Get powiadomienieNadawcy value
     * @return string|null
     */
    public function getPowiadomienieNadawcy()
    {
        return $this->powiadomienieNadawcy;
    }
    /**
     * Set powiadomienieNadawcy value
     * @param string $powiadomienieNadawcy
     * @return PrzesylkaPaletowaType
     */
    public function setPowiadomienieNadawcy($powiadomienieNadawcy = null)
    {
        $this->powiadomienieNadawcy = $powiadomienieNadawcy;
        return $this;
    }
    /**
     * Get powiadomienieOdbiorcy value
     * @return string|null
     */
    public function getPowiadomienieOdbiorcy()
    {
        return $this->powiadomienieOdbiorcy;
    }
    /**
     * Set powiadomienieOdbiorcy value
     * @param string $powiadomienieOdbiorcy
     * @return PrzesylkaPaletowaType
     */
    public function setPowiadomienieOdbiorcy($powiadomienieOdbiorcy = null)
    {
        $this->powiadomienieOdbiorcy = $powiadomienieOdbiorcy;
        return $this;
    }
    /**
     * Get dostawaWSobote value
     * @return bool|null
     */
    public function getDostawaWSobote()
    {
        return $this->dostawaWSobote;
    }
    /**
     * Set dostawaWSobote value
     * @param bool $dostawaWSobote
     * @return PrzesylkaPaletowaType
     */
    public function setDostawaWSobote($dostawaWSobote = null)
    {
        $this->dostawaWSobote = $dostawaWSobote;
        return $this;
    }
    /**
     * Get przygotowanieDokumentowPrzewozowych value
     * @return bool|null
     */
    public function getPrzygotowanieDokumentowPrzewozowych()
    {
        return $this->przygotowanieDokumentowPrzewozowych;
    }
    /**
     * Set przygotowanieDokumentowPrzewozowych value
     * @param bool $przygotowanieDokumentowPrzewozowych
     * @return PrzesylkaPaletowaType
     */
    public function setPrzygotowanieDokumentowPrzewozowych($przygotowanieDokumentowPrzewozowych = null)
    {
        $this->przygotowanieDokumentowPrzewozowych = $przygotowanieDokumentowPrzewozowych;
        return $this;
    }
    /**
     * Get dostawaSamochodemDedykowanym value
     * @return bool|null
     */
    public function getDostawaSamochodemDedykowanym()
    {
        return $this->dostawaSamochodemDedykowanym;
    }
    /**
     * Set dostawaSamochodemDedykowanym value
     * @param bool $dostawaSamochodemDedykowanym
     * @return PrzesylkaPaletowaType
     */
    public function setDostawaSamochodemDedykowanym($dostawaSamochodemDedykowanym = null)
    {
        $this->dostawaSamochodemDedykowanym = $dostawaSamochodemDedykowanym;
        return $this;
    }
    /**
     * Get zmianaDanychAdresowych value
     * @return bool|null
     */
    public function getZmianaDanychAdresowych()
    {
        return $this->zmianaDanychAdresowych;
    }
    /**
     * Set zmianaDanychAdresowych value
     * @param bool $zmianaDanychAdresowych
     * @return PrzesylkaPaletowaType
     */
    public function setZmianaDanychAdresowych($zmianaDanychAdresowych = null)
    {
        $this->zmianaDanychAdresowych = $zmianaDanychAdresowych;
        return $this;
    }
    /**
     * Get ustalenieTerminuDostawy value
     * @return bool|null
     */
    public function getUstalenieTerminuDostawy()
    {
        return $this->ustalenieTerminuDostawy;
    }
    /**
     * Set ustalenieTerminuDostawy value
     * @param bool $ustalenieTerminuDostawy
     * @return PrzesylkaPaletowaType
     */
    public function setUstalenieTerminuDostawy($ustalenieTerminuDostawy = null)
    {
        $this->ustalenieTerminuDostawy = $ustalenieTerminuDostawy;
        return $this;
    }
    /**
     * Get samochodZWinda value
     * @return bool|null
     */
    public function getSamochodZWinda()
    {
        return $this->samochodZWinda;
    }
    /**
     * Set samochodZWinda value
     * @param bool $samochodZWinda
     * @return PrzesylkaPaletowaType
     */
    public function setSamochodZWinda($samochodZWinda = null)
    {
        $this->samochodZWinda = $samochodZWinda;
        return $this;
    }
    /**
     * Get zabranieOpakowania value
     * @return bool|null
     */
    public function getZabranieOpakowania()
    {
        return $this->zabranieOpakowania;
    }
    /**
     * Set zabranieOpakowania value
     * @param bool $zabranieOpakowania
     * @return PrzesylkaPaletowaType
     */
    public function setZabranieOpakowania($zabranieOpakowania = null)
    {
        $this->zabranieOpakowania = $zabranieOpakowania;
        return $this;
    }
    /**
     * Get wniesienie value
     * @return bool|null
     */
    public function getWniesienie()
    {
        return $this->wniesienie;
    }
    /**
     * Set wniesienie value
     * @param bool $wniesienie
     * @return PrzesylkaPaletowaType
     */
    public function setWniesienie($wniesienie = null)
    {
        $this->wniesienie = $wniesienie;
        return $this;
    }
    /**
     * Get awizoSMS value
     * @return bool|null
     */
    public function getAwizoSMS()
    {
        return $this->awizoSMS;
    }
    /**
     * Set awizoSMS value
     * @param bool $awizoSMS
     * @return PrzesylkaPaletowaType
     */
    public function setAwizoSMS($awizoSMS = null)
    {
        $this->awizoSMS = $awizoSMS;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return PrzesylkaPaletowaType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
