<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for przesylkaZagranicznaType StructType
 * @subpackage Structs
 */
class PrzesylkaZagranicznaType extends PrzesylkaNieRejestrowanaType
{
    /**
     * The adres
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var AdresType
     */
    public $adres;
    /**
     * The nadawca
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var AdresType
     */
    public $nadawca;
    /**
     * The deklaracjaCelna2
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var DeklaracjaCelna2Type
     */
    public $deklaracjaCelna2;
    /**
     * The posteRestante
     * Meta informations extracted from the WSDL
     * - default: false
     * - use: optional
     * @var bool
     */
    public $posteRestante;
    /**
     * The kategoria
     * @var string
     */
    public $kategoria;
    /**
     * The masa
     * Meta informations extracted from the WSDL
     * - documentation: masa przesyłki podana w gramach
     * - base: xsd:int
     * - maxInclusive: 9999999
     * - minInclusive: 1
     * @var int
     */
    public $masa;
    /**
     * The ekspres
     * Meta informations extracted from the WSDL
     * - default: false
     * @var bool
     */
    public $ekspres;
    /**
     * The kraj
     * @var string
     */
    public $kraj;
    /**
     * Constructor method for przesylkaZagranicznaType
     * @uses PrzesylkaZagranicznaType::setAdres()
     * @uses PrzesylkaZagranicznaType::setNadawca()
     * @uses PrzesylkaZagranicznaType::setDeklaracjaCelna2()
     * @uses PrzesylkaZagranicznaType::setPosteRestante()
     * @uses PrzesylkaZagranicznaType::setKategoria()
     * @uses PrzesylkaZagranicznaType::setMasa()
     * @uses PrzesylkaZagranicznaType::setEkspres()
     * @uses PrzesylkaZagranicznaType::setKraj()
     * @param AdresType $adres
     * @param AdresType $nadawca
     * @param DeklaracjaCelna2Type $deklaracjaCelna2
     * @param bool $posteRestante
     * @param string $kategoria
     * @param int $masa
     * @param bool $ekspres
     * @param string $kraj
     */
    public function __construct(AdresType $adres = null, AdresType $nadawca = null, DeklaracjaCelna2Type $deklaracjaCelna2 = null, $posteRestante = false, $kategoria = null, $masa = null, $ekspres = false, $kraj = null)
    {
        $this
            ->setAdres($adres)
            ->setNadawca($nadawca)
            ->setDeklaracjaCelna2($deklaracjaCelna2)
            ->setPosteRestante($posteRestante)
            ->setKategoria($kategoria)
            ->setMasa($masa)
            ->setEkspres($ekspres)
            ->setKraj($kraj);
    }
    /**
     * Get adres value
     * @return AdresType|null
     */
    public function getAdres()
    {
        return $this->adres;
    }
    /**
     * Set adres value
     * @param AdresType $adres
     * @return PrzesylkaZagranicznaType
     */
    public function setAdres(AdresType $adres = null)
    {
        $this->adres = $adres;
        return $this;
    }
    /**
     * Get nadawca value
     * @return AdresType|null
     */
    public function getNadawca()
    {
        return $this->nadawca;
    }
    /**
     * Set nadawca value
     * @param AdresType $nadawca
     * @return PrzesylkaZagranicznaType
     */
    public function setNadawca(AdresType $nadawca = null)
    {
        $this->nadawca = $nadawca;
        return $this;
    }
    /**
     * Get deklaracjaCelna2 value
     * @return DeklaracjaCelna2Type|null
     */
    public function getDeklaracjaCelna2()
    {
        return $this->deklaracjaCelna2;
    }
    /**
     * Set deklaracjaCelna2 value
     * @param DeklaracjaCelna2Type $deklaracjaCelna2
     * @return PrzesylkaZagranicznaType
     */
    public function setDeklaracjaCelna2(DeklaracjaCelna2Type $deklaracjaCelna2 = null)
    {
        $this->deklaracjaCelna2 = $deklaracjaCelna2;
        return $this;
    }
    /**
     * Get posteRestante value
     * @return bool|null
     */
    public function getPosteRestante()
    {
        return $this->posteRestante;
    }
    /**
     * Set posteRestante value
     * @param bool $posteRestante
     * @return PrzesylkaZagranicznaType
     */
    public function setPosteRestante($posteRestante = false)
    {
        $this->posteRestante = $posteRestante;
        return $this;
    }
    /**
     * Get kategoria value
     * @return string|null
     */
    public function getKategoria()
    {
        return $this->kategoria;
    }
    /**
     * Set kategoria value
     * @param string $kategoria
     * @return PrzesylkaZagranicznaType
     */
    public function setKategoria($kategoria = null)
    {
        $this->kategoria = $kategoria;
        return $this;
    }
    /**
     * Get masa value
     * @return int|null
     */
    public function getMasa()
    {
        return $this->masa;
    }
    /**
     * Set masa value
     * @param int $masa
     * @return PrzesylkaZagranicznaType
     */
    public function setMasa($masa = null)
    {
        $this->masa = $masa;
        return $this;
    }
    /**
     * Get ekspres value
     * @return bool|null
     */
    public function getEkspres()
    {
        return $this->ekspres;
    }
    /**
     * Set ekspres value
     * @param bool $ekspres
     * @return PrzesylkaZagranicznaType
     */
    public function setEkspres($ekspres = false)
    {
        $this->ekspres = $ekspres;
        return $this;
    }
    /**
     * Get kraj value
     * @return string|null
     */
    public function getKraj()
    {
        return $this->kraj;
    }
    /**
     * Set kraj value
     * @param string $kraj
     * @return PrzesylkaZagranicznaType
     */
    public function setKraj($kraj = null)
    {
        $this->kraj = $kraj;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return PrzesylkaZagranicznaType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
