<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for pakietType StructType
 * @subpackage Structs
 */
class PakietType extends AbstractStructBase
{
    /**
     * The kierunek
     * Meta informations extracted from the WSDL
     * - documentation: Uwaga w tym miejscu wystarczy jak obiekt kierunke będzie miał ustawioną tylko własność id (nie jest potrzebne przesyłanie pełnego obiektu kierunekType pobranego z metody getKierunki)
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var KierunekType
     */
    public $kierunek;
    /**
     * The opakowanie
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var OpakowanieType[]
     */
    public $opakowanie;
    /**
     * The czynnoscUpustowa
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $czynnoscUpustowa;
    /**
     * The pakietGuid
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 32
     * - whiteSpace: collapse
     * @var string
     */
    public $pakietGuid;
    /**
     * The miejsceOdbioru
     * Meta informations extracted from the WSDL
     * - default: URZAD_NADANIA
     * - use: optional
     * @var string
     */
    public $miejsceOdbioru;
    /**
     * The sposobNadania
     * @var string
     */
    public $sposobNadania;
    /**
     * Constructor method for pakietType
     * @uses PakietType::setKierunek()
     * @uses PakietType::setOpakowanie()
     * @uses PakietType::setCzynnoscUpustowa()
     * @uses PakietType::setPakietGuid()
     * @uses PakietType::setMiejsceOdbioru()
     * @uses PakietType::setSposobNadania()
     * @param KierunekType $kierunek
     * @param OpakowanieType[] $opakowanie
     * @param string[] $czynnoscUpustowa
     * @param string $pakietGuid
     * @param string $miejsceOdbioru
     * @param string $sposobNadania
     */
    public function __construct(KierunekType $kierunek = null, array $opakowanie = array(), array $czynnoscUpustowa = array(), $pakietGuid = null, $miejsceOdbioru = 'URZAD_NADANIA', $sposobNadania = null)
    {
        $this
            ->setKierunek($kierunek)
            ->setOpakowanie($opakowanie)
            ->setCzynnoscUpustowa($czynnoscUpustowa)
            ->setPakietGuid($pakietGuid)
            ->setMiejsceOdbioru($miejsceOdbioru)
            ->setSposobNadania($sposobNadania);
    }
    /**
     * Get kierunek value
     * @return KierunekType|null
     */
    public function getKierunek()
    {
        return $this->kierunek;
    }
    /**
     * Set kierunek value
     * @param KierunekType $kierunek
     * @return PakietType
     */
    public function setKierunek(KierunekType $kierunek = null)
    {
        $this->kierunek = $kierunek;
        return $this;
    }
    /**
     * Get opakowanie value
     * @return OpakowanieType[]|null
     */
    public function getOpakowanie()
    {
        return $this->opakowanie;
    }
    /**
     * Set opakowanie value
     * @param OpakowanieType[] $opakowanie
     * @return PakietType
     */
    public function setOpakowanie(array $opakowanie = array())
    {
        $this->opakowanie = $opakowanie;
        return $this;
    }
    /**
     * Add item to opakowanie value
     * @throws \InvalidArgumentException
     * @param OpakowanieType $item
     * @return PakietType
     */
    public function addToOpakowanie(OpakowanieType $item)
    {
        $this->opakowanie[] = $item;
        return $this;
    }
    /**
     * Get czynnoscUpustowa value
     * @return string[]|null
     */
    public function getCzynnoscUpustowa()
    {
        return $this->czynnoscUpustowa;
    }
    /**
     * Set czynnoscUpustowa value
     * @param string[] $czynnoscUpustowa
     * @return PakietType
     */
    public function setCzynnoscUpustowa(array $czynnoscUpustowa = array())
    {
        $this->czynnoscUpustowa = $czynnoscUpustowa;
        return $this;
    }
    /**
     * Add item to czynnoscUpustowa value
     * @uses CzynnoscUpustowaType::valueIsValid()
     * @uses CzynnoscUpustowaType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return PakietType
     */
    public function addToCzynnoscUpustowa($item)
    {
        $this->czynnoscUpustowa[] = $item;
        return $this;
    }
    /**
     * Get pakietGuid value
     * @return string|null
     */
    public function getPakietGuid()
    {
        return $this->pakietGuid;
    }
    /**
     * Set pakietGuid value
     * @param string $pakietGuid
     * @return PakietType
     */
    public function setPakietGuid($pakietGuid = null)
    {
        $this->pakietGuid = $pakietGuid;
        return $this;
    }
    /**
     * Get miejsceOdbioru value
     * @return string|null
     */
    public function getMiejsceOdbioru()
    {
        return $this->miejsceOdbioru;
    }
    /**
     * Set miejsceOdbioru value
     * @param string $miejsceOdbioru
     * @return PakietType
     */
    public function setMiejsceOdbioru($miejsceOdbioru = 'URZAD_NADANIA')
    {
        $this->miejsceOdbioru = $miejsceOdbioru;
        return $this;
    }
    /**
     * Get sposobNadania value
     * @return string|null
     */
    public function getSposobNadania()
    {
        return $this->sposobNadania;
    }
    /**
     * Set sposobNadania value
     * @param string $sposobNadania
     * @return PakietType
     */
    public function setSposobNadania($sposobNadania = null)
    {
        $this->sposobNadania = $sposobNadania;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return PakietType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
