<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getEZDOResponse StructType
 * @subpackage Structs
 */
class GetEZDOResponse extends AbstractStructBase
{
    /**
     * The adres
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var AdresType
     */
    public $adres;
    /**
     * The przesylka
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var EZDOPrzesylkaType[]
     */
    public $przesylka;
    /**
     * The error
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var ErrorType[]
     */
    public $error;
    /**
     * The numerKD
     * @var string
     */
    public $numerKD;
    /**
     * The numerEZDO
     * @var string
     */
    public $numerEZDO;
    /**
     * Constructor method for getEZDOResponse
     * @uses GetEZDOResponse::setAdres()
     * @uses GetEZDOResponse::setPrzesylka()
     * @uses GetEZDOResponse::setError()
     * @uses GetEZDOResponse::setNumerKD()
     * @uses GetEZDOResponse::setNumerEZDO()
     * @param AdresType $adres
     * @param EZDOPrzesylkaType[] $przesylka
     * @param ErrorType[] $error
     * @param string $numerKD
     * @param string $numerEZDO
     */
    public function __construct(AdresType $adres = null, array $przesylka = array(), array $error = array(), $numerKD = null, $numerEZDO = null)
    {
        $this
            ->setAdres($adres)
            ->setPrzesylka($przesylka)
            ->setError($error)
            ->setNumerKD($numerKD)
            ->setNumerEZDO($numerEZDO);
    }
    /**
     * Get adres value
     * @return AdresType
     */
    public function getAdres()
    {
        return $this->adres;
    }
    /**
     * Set adres value
     * @param AdresType $adres
     * @return GetEZDOResponse
     */
    public function setAdres(AdresType $adres = null)
    {
        $this->adres = $adres;
        return $this;
    }
    /**
     * Get przesylka value
     * @return EZDOPrzesylkaType[]
     */
    public function getPrzesylka()
    {
        return $this->przesylka;
    }
    /**
     * Set przesylka value
     * @param EZDOPrzesylkaType[] $przesylka
     * @return GetEZDOResponse
     */
    public function setPrzesylka(array $przesylka = array())
    {
        $this->przesylka = $przesylka;
        return $this;
    }
    /**
     * Add item to przesylka value
     * @throws \InvalidArgumentException
     * @param EZDOPrzesylkaType $item
     * @return GetEZDOResponse
     */
    public function addToPrzesylka(EZDOPrzesylkaType $item)
    {
        $this->przesylka[] = $item;
        return $this;
    }
    /**
     * Get error value
     * @return ErrorType[]|null
     */
    public function getError()
    {
        return $this->error;
    }
    /**
     * Set error value
     * @param ErrorType[] $error
     * @return GetEZDOResponse
     */
    public function setError(array $error = array())
    {
        $this->error = $error;
        return $this;
    }
    /**
     * Add item to error value
     * @throws \InvalidArgumentException
     * @param ErrorType $item
     * @return GetEZDOResponse
     */
    public function addToError(ErrorType $item)
    {
        $this->error[] = $item;
        return $this;
    }
    /**
     * Get numerKD value
     * @return string|null
     */
    public function getNumerKD()
    {
        return $this->numerKD;
    }
    /**
     * Set numerKD value
     * @param string $numerKD
     * @return GetEZDOResponse
     */
    public function setNumerKD($numerKD = null)
    {
        $this->numerKD = $numerKD;
        return $this;
    }
    /**
     * Get numerEZDO value
     * @return string|null
     */
    public function getNumerEZDO()
    {
        return $this->numerEZDO;
    }
    /**
     * Set numerEZDO value
     * @param string $numerEZDO
     * @return GetEZDOResponse
     */
    public function setNumerEZDO($numerEZDO = null)
    {
        $this->numerEZDO = $numerEZDO;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return GetEZDOResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
