<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EZDOPrzesylkaType StructType
 * @subpackage Structs
 */
class EZDOPrzesylkaType extends AbstractStructBase
{
    /**
     * The numerNadania
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 20
     * - minLength: 13
     * @var string
     */
    public $numerNadania;
    /**
     * The rodzaj
     * @var string
     */
    public $rodzaj;
    /**
     * The kategoria
     * @var string
     */
    public $kategoria;
    /**
     * The masa
     * Meta informations extracted from the WSDL
     * - documentation: masa przesyłki podana w gramach
     * - base: xsd:int
     * - maxInclusive: 9999999
     * - minInclusive: 1
     * @var int
     */
    public $masa;
    /**
     * The wartosc
     * Meta informations extracted from the WSDL
     * - documentation: zadeklarowana wartość przesyłki w groszach
     * - base: xsd:int
     * - maxInclusive: 9999999
     * - minInclusive: 0
     * @var int
     */
    public $wartosc;
    /**
     * The kwotaPobrania
     * Meta informations extracted from the WSDL
     * - documentation: kwota jaką należy pobrać podana w groszach
     * - base: xsd:int
     * - maxInclusive: 9999999
     * - minInclusive: 0
     * @var int
     */
    public $kwotaPobrania;
    /**
     * The numerWewnetrznyPrzesylki
     * @var string
     */
    public $numerWewnetrznyPrzesylki;
    /**
     * The zwrot
     * @var string
     */
    public $zwrot;
    /**
     * Constructor method for EZDOPrzesylkaType
     * @uses EZDOPrzesylkaType::setNumerNadania()
     * @uses EZDOPrzesylkaType::setRodzaj()
     * @uses EZDOPrzesylkaType::setKategoria()
     * @uses EZDOPrzesylkaType::setMasa()
     * @uses EZDOPrzesylkaType::setWartosc()
     * @uses EZDOPrzesylkaType::setKwotaPobrania()
     * @uses EZDOPrzesylkaType::setNumerWewnetrznyPrzesylki()
     * @uses EZDOPrzesylkaType::setZwrot()
     * @param string $numerNadania
     * @param string $rodzaj
     * @param string $kategoria
     * @param int $masa
     * @param int $wartosc
     * @param int $kwotaPobrania
     * @param string $numerWewnetrznyPrzesylki
     * @param string $zwrot
     */
    public function __construct($numerNadania = null, $rodzaj = null, $kategoria = null, $masa = null, $wartosc = null, $kwotaPobrania = null, $numerWewnetrznyPrzesylki = null, $zwrot = null)
    {
        $this
            ->setNumerNadania($numerNadania)
            ->setRodzaj($rodzaj)
            ->setKategoria($kategoria)
            ->setMasa($masa)
            ->setWartosc($wartosc)
            ->setKwotaPobrania($kwotaPobrania)
            ->setNumerWewnetrznyPrzesylki($numerWewnetrznyPrzesylki)
            ->setZwrot($zwrot);
    }
    /**
     * Get numerNadania value
     * @return string|null
     */
    public function getNumerNadania()
    {
        return $this->numerNadania;
    }
    /**
     * Set numerNadania value
     * @param string $numerNadania
     * @return EZDOPrzesylkaType
     */
    public function setNumerNadania($numerNadania = null)
    {
        $this->numerNadania = $numerNadania;
        return $this;
    }
    /**
     * Get rodzaj value
     * @return string|null
     */
    public function getRodzaj()
    {
        return $this->rodzaj;
    }
    /**
     * Set rodzaj value
     * @param string $rodzaj
     * @return EZDOPrzesylkaType
     */
    public function setRodzaj($rodzaj = null)
    {
        $this->rodzaj = $rodzaj;
        return $this;
    }
    /**
     * Get kategoria value
     * @return string|null
     */
    public function getKategoria()
    {
        return $this->kategoria;
    }
    /**
     * Set kategoria value
     * @param string $kategoria
     * @return EZDOPrzesylkaType
     */
    public function setKategoria($kategoria = null)
    {
        $this->kategoria = $kategoria;
        return $this;
    }
    /**
     * Get masa value
     * @return int|null
     */
    public function getMasa()
    {
        return $this->masa;
    }
    /**
     * Set masa value
     * @param int $masa
     * @return EZDOPrzesylkaType
     */
    public function setMasa($masa = null)
    {
        $this->masa = $masa;
        return $this;
    }
    /**
     * Get wartosc value
     * @return int|null
     */
    public function getWartosc()
    {
        return $this->wartosc;
    }
    /**
     * Set wartosc value
     * @param int $wartosc
     * @return EZDOPrzesylkaType
     */
    public function setWartosc($wartosc = null)
    {
        $this->wartosc = $wartosc;
        return $this;
    }
    /**
     * Get kwotaPobrania value
     * @return int|null
     */
    public function getKwotaPobrania()
    {
        return $this->kwotaPobrania;
    }
    /**
     * Set kwotaPobrania value
     * @param int $kwotaPobrania
     * @return EZDOPrzesylkaType
     */
    public function setKwotaPobrania($kwotaPobrania = null)
    {
        $this->kwotaPobrania = $kwotaPobrania;
        return $this;
    }
    /**
     * Get numerWewnetrznyPrzesylki value
     * @return string|null
     */
    public function getNumerWewnetrznyPrzesylki()
    {
        return $this->numerWewnetrznyPrzesylki;
    }
    /**
     * Set numerWewnetrznyPrzesylki value
     * @param string $numerWewnetrznyPrzesylki
     * @return EZDOPrzesylkaType
     */
    public function setNumerWewnetrznyPrzesylki($numerWewnetrznyPrzesylki = null)
    {
        $this->numerWewnetrznyPrzesylki = $numerWewnetrznyPrzesylki;
        return $this;
    }
    /**
     * Get zwrot value
     * @return string|null
     */
    public function getZwrot()
    {
        return $this->zwrot;
    }
    /**
     * Set zwrot value
     * @param string $zwrot
     * @return EZDOPrzesylkaType
     */
    public function setZwrot($zwrot = null)
    {
        $this->zwrot = $zwrot;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return EZDOPrzesylkaType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
