<?php
/**
 * This class stands for DeklaracaCelnaRodzajEnum EnumType
 * @subpackage Enumerations
 */
class DeklaracaCelnaRodzajEnum
{
    /**
     * Constant for value 'CN22'
     * @return string 'CN22'
     */
    const ENUM_VALUE_0 = 'CN22';
    /**
     * Constant for value 'CN23'
     * @return string 'CN23'
     */
    const ENUM_VALUE_1 = 'CN23';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::ENUM_VALUE_0
     * @uses self::ENUM_VALUE_1
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::ENUM_VALUE_0,
            self::ENUM_VALUE_1,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
