<?php
/**
 * This class stands for zasadySpecjalneEnum EnumType
 * @subpackage Enumerations
 */
class ZasadySpecjalneEnum
{
    /**
     * Constant for value 'ADMINISTRACYJNA'
     * @return string 'ADMINISTRACYJNA'
     */
    const ENUM_VALUE_0 = 'ADMINISTRACYJNA';
    /**
     * Constant for value 'PODATKOWA'
     * @return string 'PODATKOWA'
     */
    const ENUM_VALUE_1 = 'PODATKOWA';
    /**
     * Constant for value 'SADOWA_CYWILNA'
     * @return string 'SADOWA_CYWILNA'
     */
    const ENUM_VALUE_2 = 'SADOWA_CYWILNA';
    /**
     * Constant for value 'SADOWA_KARNA'
     * @return string 'SADOWA_KARNA'
     */
    const ENUM_VALUE_3 = 'SADOWA_KARNA';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::ENUM_VALUE_0
     * @uses self::ENUM_VALUE_1
     * @uses self::ENUM_VALUE_2
     * @uses self::ENUM_VALUE_3
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::ENUM_VALUE_0,
            self::ENUM_VALUE_1,
            self::ENUM_VALUE_2,
            self::ENUM_VALUE_3,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
