<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getPrintForParcel StructType
 * @subpackage Structs
 */
class GetPrintForParcel extends AbstractStructBase
{
    /**
     * The guid
     * Meta informations extracted from the WSDL
     * - documentation: parcels guids
     * - base: xsd:string
     * - length: 32
     * - maxOccurs: 500
     * - minOccurs: 1
     * - whiteSpace: collapse
     * @var string[]
     */
    public $guid;
    /**
     * The type
     * Meta informations extracted from the WSDL
     * - documentation: printout type
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var PrintType
     */
    public $type;
    /**
     * Constructor method for getPrintForParcel
     * @uses GetPrintForParcel::setGuid()
     * @uses GetPrintForParcel::setType()
     * @param string[] $guid
     * @param PrintType $type
     */
    public function __construct(array $guid = array(), PrintType $type = null)
    {
        $this
            ->setGuid($guid)
            ->setType($type);
    }
    /**
     * Get guid value
     * @return string[]
     */
    public function getGuid()
    {
        return $this->guid;
    }
    /**
     * Set guid value
     * @param string[] $guid
     * @return GetPrintForParcel
     */
    public function setGuid(array $guid = array())
    {
        $this->guid = $guid;
        return $this;
    }
    /**
     * Add item to guid value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return GetPrintForParcel
     */
    public function addToGuid($item)
    {
        $this->guid[] = $item;
        return $this;
    }
    /**
     * Get type value
     * @return PrintType
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @param PrintType $type
     * @return GetPrintForParcel
     */
    public function setType(PrintType $type = null)
    {
        $this->type = $type;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return GetPrintForParcel
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
