<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getEPOStatus StructType
 * @subpackage Structs
 */
class GetEPOStatus extends AbstractStructBase
{
    /**
     * The guid
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 32
     * - maxOccurs: 500
     * - minOccurs: 1
     * - whiteSpace: collapse
     * @var string[]
     */
    public $guid;
    /**
     * The endedOnly
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $endedOnly;
    /**
     * The idEnvelope
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $idEnvelope;
    /**
     * The withBioepo
     * Meta informations extracted from the WSDL
     * - documentation: Element służy do przekazania żądania uzupełnienia statusu EPO dla wskazanych przesyłek o dane dotyczące podpisu odbiorcy przesyłki. W zalezności od urządzenia wykorzystanego do utrwalenia podpisu, w odpowiedzi na wywołanie
     * metody może zostać zwrócony sam obraz podpisu lub obraz podpisu uzupełniony o jego dane biometryczne.
     * @var bool
     */
    public $withBioepo;
    /**
     * Constructor method for getEPOStatus
     * @uses GetEPOStatus::setGuid()
     * @uses GetEPOStatus::setEndedOnly()
     * @uses GetEPOStatus::setIdEnvelope()
     * @uses GetEPOStatus::setWithBioepo()
     * @param string[] $guid
     * @param bool $endedOnly
     * @param int $idEnvelope
     * @param bool $withBioepo
     */
    public function __construct(array $guid = array(), $endedOnly = null, $idEnvelope = null, $withBioepo = null)
    {
        $this
            ->setGuid($guid)
            ->setEndedOnly($endedOnly)
            ->setIdEnvelope($idEnvelope)
            ->setWithBioepo($withBioepo);
    }
    /**
     * Get guid value
     * @return string[]
     */
    public function getGuid()
    {
        return $this->guid;
    }
    /**
     * Set guid value
     * @param string[] $guid
     * @return GetEPOStatus
     */
    public function setGuid(array $guid = array())
    {
        $this->guid = $guid;
        return $this;
    }
    /**
     * Add item to guid value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return GetEPOStatus
     */
    public function addToGuid($item)
    {
        $this->guid[] = $item;
        return $this;
    }
    /**
     * Get endedOnly value
     * @return bool
     */
    public function getEndedOnly()
    {
        return $this->endedOnly;
    }
    /**
     * Set endedOnly value
     * @param bool $endedOnly
     * @return GetEPOStatus
     */
    public function setEndedOnly($endedOnly = null)
    {
        $this->endedOnly = $endedOnly;
        return $this;
    }
    /**
     * Get idEnvelope value
     * @return int
     */
    public function getIdEnvelope()
    {
        return $this->idEnvelope;
    }
    /**
     * Set idEnvelope value
     * @param int $idEnvelope
     * @return GetEPOStatus
     */
    public function setIdEnvelope($idEnvelope = null)
    {
        $this->idEnvelope = $idEnvelope;
        return $this;
    }
    /**
     * Get withBioepo value
     * @return bool|null
     */
    public function getWithBioepo()
    {
        return $this->withBioepo;
    }
    /**
     * Set withBioepo value
     * @param bool $withBioepo
     * @return GetEPOStatus
     */
    public function setWithBioepo($withBioepo = null)
    {
        $this->withBioepo = $withBioepo;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return GetEPOStatus
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
