<?php
/**
 * This class stands for formatType EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Określa format przesyłki. Format S: Maksymalne wymiary koperty [mm]: 160 x 230 x 20. Maksymalna waga [g]: 500 Format M: Maksymalne wymiary koperty [mm]: 230 x 325 x 20. Maksymalna waga [g]: 1000 Format L: Maksymalna suma wymiarów
 * koperty [mm]: 900. Maksymalna długość najdłuższego boku [mm]: 600 Rulony Maksymalna waga [g]: 2000
 * @subpackage Enumerations
 */
class FormatType
{
    /**
     * Constant for value 'S'
     * @return string 'S'
     */
    const ENUM_VALUE_0 = 'S';
    /**
     * Constant for value 'M'
     * @return string 'M'
     */
    const ENUM_VALUE_1 = 'M';
    /**
     * Constant for value 'L'
     * @return string 'L'
     */
    const ENUM_VALUE_2 = 'L';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::ENUM_VALUE_0
     * @uses self::ENUM_VALUE_1
     * @uses self::ENUM_VALUE_2
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::ENUM_VALUE_0,
            self::ENUM_VALUE_1,
            self::ENUM_VALUE_2,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
