<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getEPOStatusResponse StructType
 * @subpackage Structs
 */
class GetEPOStatusResponse extends AbstractStructBase
{
    /**
     * The epo
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var PrzesylkaEPOType[]
     */
    public $epo;
    /**
     * The error
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var ErrorType_1[]
     */
    public $error;
    /**
     * Constructor method for getEPOStatusResponse
     * @uses GetEPOStatusResponse::setEpo()
     * @uses GetEPOStatusResponse::setError()
     * @param PrzesylkaEPOType[] $epo
     * @param ErrorType_1[] $error
     */
    public function __construct(array $epo = array(), array $error = array())
    {
        $this
            ->setEpo($epo)
            ->setError($error);
    }
    /**
     * Get epo value
     * @return PrzesylkaEPOType[]|null
     */
    public function getEpo()
    {
        return $this->epo;
    }
    /**
     * Set epo value
     * @param PrzesylkaEPOType[] $epo
     * @return GetEPOStatusResponse
     */
    public function setEpo(array $epo = array())
    {
        $this->epo = $epo;
        return $this;
    }
    /**
     * Add item to epo value
     * @throws \InvalidArgumentException
     * @param PrzesylkaEPOType $item
     * @return GetEPOStatusResponse
     */
    public function addToEpo(PrzesylkaEPOType $item)
    {
        $this->epo[] = $item;
        return $this;
    }
    /**
     * Get error value
     * @return ErrorType_1[]|null
     */
    public function getError()
    {
        return $this->error;
    }
    /**
     * Set error value
     * @param ErrorType_1[] $error
     * @return GetEPOStatusResponse
     */
    public function setError(array $error = array())
    {
        $this->error = $error;
        return $this;
    }
    /**
     * Add item to error value
     * @throws \InvalidArgumentException
     * @param ErrorType_1 $item
     * @return GetEPOStatusResponse
     */
    public function addToError(ErrorType_1 $item)
    {
        $this->error[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return GetEPOStatusResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
