<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EMSType StructType
 * @subpackage Structs
 */
class EMSType extends PrzesylkaRejestrowanaType
{
    /**
     * The ubezpieczenie
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var UbezpieczenieType
     */
    public $ubezpieczenie;
    /**
     * The deklaracjaCelna
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var DeklaracjaCelnaType
     */
    public $deklaracjaCelna;
    /**
     * The potwierdzenieDoreczenia
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var PotwierdzenieDoreczeniaType
     */
    public $potwierdzenieDoreczenia;
    /**
     * The typOpakowania
     * @var string
     */
    public $typOpakowania;
    /**
     * The masa
     * Meta informations extracted from the WSDL
     * - documentation: masa przesyłki podana w gramach
     * - base: xsd:int
     * - maxInclusive: 9999999
     * - minInclusive: 1
     * @var int
     */
    public $masa;
    /**
     * The zalaczoneDokumenty
     * @var bool
     */
    public $zalaczoneDokumenty;
    /**
     * The numerPrzesylkiKlienta
     * @var string
     */
    public $numerPrzesylkiKlienta;
    /**
     * Constructor method for EMSType
     * @uses EMSType::setUbezpieczenie()
     * @uses EMSType::setDeklaracjaCelna()
     * @uses EMSType::setPotwierdzenieDoreczenia()
     * @uses EMSType::setTypOpakowania()
     * @uses EMSType::setMasa()
     * @uses EMSType::setZalaczoneDokumenty()
     * @uses EMSType::setNumerPrzesylkiKlienta()
     * @param UbezpieczenieType $ubezpieczenie
     * @param DeklaracjaCelnaType $deklaracjaCelna
     * @param PotwierdzenieDoreczeniaType $potwierdzenieDoreczenia
     * @param string $typOpakowania
     * @param int $masa
     * @param bool $zalaczoneDokumenty
     * @param string $numerPrzesylkiKlienta
     */
    public function __construct(UbezpieczenieType $ubezpieczenie = null, DeklaracjaCelnaType $deklaracjaCelna = null, PotwierdzenieDoreczeniaType $potwierdzenieDoreczenia = null, $typOpakowania = null, $masa = null, $zalaczoneDokumenty = null, $numerPrzesylkiKlienta = null)
    {
        $this
            ->setUbezpieczenie($ubezpieczenie)
            ->setDeklaracjaCelna($deklaracjaCelna)
            ->setPotwierdzenieDoreczenia($potwierdzenieDoreczenia)
            ->setTypOpakowania($typOpakowania)
            ->setMasa($masa)
            ->setZalaczoneDokumenty($zalaczoneDokumenty)
            ->setNumerPrzesylkiKlienta($numerPrzesylkiKlienta);
    }
    /**
     * Get ubezpieczenie value
     * @return UbezpieczenieType|null
     */
    public function getUbezpieczenie()
    {
        return $this->ubezpieczenie;
    }
    /**
     * Set ubezpieczenie value
     * @param UbezpieczenieType $ubezpieczenie
     * @return EMSType
     */
    public function setUbezpieczenie(UbezpieczenieType $ubezpieczenie = null)
    {
        $this->ubezpieczenie = $ubezpieczenie;
        return $this;
    }
    /**
     * Get deklaracjaCelna value
     * @return DeklaracjaCelnaType|null
     */
    public function getDeklaracjaCelna()
    {
        return $this->deklaracjaCelna;
    }
    /**
     * Set deklaracjaCelna value
     * @param DeklaracjaCelnaType $deklaracjaCelna
     * @return EMSType
     */
    public function setDeklaracjaCelna(DeklaracjaCelnaType $deklaracjaCelna = null)
    {
        $this->deklaracjaCelna = $deklaracjaCelna;
        return $this;
    }
    /**
     * Get potwierdzenieDoreczenia value
     * @return PotwierdzenieDoreczeniaType|null
     */
    public function getPotwierdzenieDoreczenia()
    {
        return $this->potwierdzenieDoreczenia;
    }
    /**
     * Set potwierdzenieDoreczenia value
     * @param PotwierdzenieDoreczeniaType $potwierdzenieDoreczenia
     * @return EMSType
     */
    public function setPotwierdzenieDoreczenia(PotwierdzenieDoreczeniaType $potwierdzenieDoreczenia = null)
    {
        $this->potwierdzenieDoreczenia = $potwierdzenieDoreczenia;
        return $this;
    }
    /**
     * Get typOpakowania value
     * @return string|null
     */
    public function getTypOpakowania()
    {
        return $this->typOpakowania;
    }
    /**
     * Set typOpakowania value
     * @param string $typOpakowania
     * @return EMSType
     */
    public function setTypOpakowania($typOpakowania = null)
    {
        $this->typOpakowania = $typOpakowania;
        return $this;
    }
    /**
     * Get masa value
     * @return int|null
     */
    public function getMasa()
    {
        return $this->masa;
    }
    /**
     * Set masa value
     * @param int $masa
     * @return EMSType
     */
    public function setMasa($masa = null)
    {
        $this->masa = $masa;
        return $this;
    }
    /**
     * Get zalaczoneDokumenty value
     * @return bool|null
     */
    public function getZalaczoneDokumenty()
    {
        return $this->zalaczoneDokumenty;
    }
    /**
     * Set zalaczoneDokumenty value
     * @param bool $zalaczoneDokumenty
     * @return EMSType
     */
    public function setZalaczoneDokumenty($zalaczoneDokumenty = null)
    {
        $this->zalaczoneDokumenty = $zalaczoneDokumenty;
        return $this;
    }
    /**
     * Get numerPrzesylkiKlienta value
     * @return string|null
     */
    public function getNumerPrzesylkiKlienta()
    {
        return $this->numerPrzesylkiKlienta;
    }
    /**
     * Set numerPrzesylkiKlienta value
     * @param string $numerPrzesylkiKlienta
     * @return EMSType
     */
    public function setNumerPrzesylkiKlienta($numerPrzesylkiKlienta = null)
    {
        $this->numerPrzesylkiKlienta = $numerPrzesylkiKlienta;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return EMSType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
