<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for addShipment StructType
 * @subpackage Structs
 */
class AddShipment extends AbstractStructBase
{
    /**
     * The przesylki
     * Meta informations extracted from the WSDL
     * - maxOccurs: 500
     * - minOccurs: 1
     * @var PrzesylkaType[]
     */
    public $przesylki;
    /**
     * The idBufor
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $idBufor;
    /**
     * Constructor method for addShipment
     * @uses AddShipment::setPrzesylki()
     * @uses AddShipment::setIdBufor()
     * @param PrzesylkaType[] $przesylki
     * @param int $idBufor
     */
    public function __construct(array $przesylki = array(), $idBufor = null)
    {
        $this
            ->setPrzesylki($przesylki)
            ->setIdBufor($idBufor);
    }
    /**
     * Get przesylki value
     * @return PrzesylkaType[]
     */
    public function getPrzesylki()
    {
        return $this->przesylki;
    }
    /**
     * Set przesylki value
     * @param PrzesylkaType[] $przesylki
     * @return AddShipment
     */
    public function setPrzesylki(array $przesylki = array())
    {
        $this->przesylki = $przesylki;
        return $this;
    }
    /**
     * Add item to przesylki value
     * @throws \InvalidArgumentException
     * @param PrzesylkaType $item
     * @return AddShipment
     */
    public function addToPrzesylki(PrzesylkaType $item)
    {
        $this->przesylki[] = $item;
        return $this;
    }
    /**
     * Get idBufor value
     * @return int|null
     */
    public function getIdBufor()
    {
        return $this->idBufor;
    }
    /**
     * Set idBufor value
     * @param int $idBufor
     * @return AddShipment
     */
    public function setIdBufor($idBufor = null)
    {
        $this->idBufor = $idBufor;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return AddShipment
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
