<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getReturnDocumentsProfileListResponse StructType
 * @subpackage Structs
 */
class GetReturnDocumentsProfileListResponse extends AbstractStructBase
{
    /**
     * The profile
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var ReturnDocumentProfileType[]
     */
    public $profile;
    /**
     * The error
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var ErrorType[]
     */
    public $error;
    /**
     * Constructor method for getReturnDocumentsProfileListResponse
     * @uses GetReturnDocumentsProfileListResponse::setProfile()
     * @uses GetReturnDocumentsProfileListResponse::setError()
     * @param ReturnDocumentProfileType[] $profile
     * @param ErrorType[] $error
     */
    public function __construct(array $profile = array(), array $error = array())
    {
        $this
            ->setProfile($profile)
            ->setError($error);
    }
    /**
     * Get profile value
     * @return ReturnDocumentProfileType[]|null
     */
    public function getProfile()
    {
        return $this->profile;
    }
    /**
     * Set profile value
     * @throws \InvalidArgumentException
     * @param ReturnDocumentProfileType[] $profile
     * @return GetReturnDocumentsProfileListResponse
     */
    public function setProfile(array $profile = array())
    {
        $this->profile = $profile;
        return $this;
    }
    /**
     * Add item to profile value
     * @throws \InvalidArgumentException
     * @param ReturnDocumentProfileType $item
     * @return GetReturnDocumentsProfileListResponse
     */
    public function addToProfile(ReturnDocumentProfileType $item)
    {
        $this->profile[] = $item;
        return $this;
    }
    /**
     * Get error value
     * @return ErrorType[]|null
     */
    public function getError()
    {
        return $this->error;
    }
    /**
     * Set error value
     * @throws \InvalidArgumentException
     * @param ErrorType[] $error
     * @return GetReturnDocumentsProfileListResponse
     */
    public function setError(array $error = array())
    {
        $this->error = $error;
        return $this;
    }
    /**
     * Add item to error value
     * @throws \InvalidArgumentException
     * @param ErrorType $item
     * @return GetReturnDocumentsProfileListResponse
     */
    public function addToError(ErrorType $item)
    {
        $this->error[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return GetReturnDocumentsProfileListResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
