<?php
/**
 * This class stands for gabarytType EnumType
 * @subpackage Enumerations
 */
class GabarytType
{
    /**
     * Constant for value 'GABARYT_A'
     * @return string 'GABARYT_A'
     */
    const ENUM_VALUE_0 = 'GABARYT_A';
    /**
     * Constant for value 'GABARYT_B'
     * @return string 'GABARYT_B'
     */
    const ENUM_VALUE_1 = 'GABARYT_B';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::ENUM_VALUE_0
     * @uses self::ENUM_VALUE_1
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::ENUM_VALUE_0,
            self::ENUM_VALUE_1,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
