<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for doreczeniePrzesylkiType StructType
 * @subpackage Structs
 */
class DoreczeniePrzesylkiType extends AbstractStructBase
{
    /**
     * The data
     * @var string
     */
    public $data;
    /**
     * The osobaOdbierajaca
     * @var string
     */
    public $osobaOdbierajaca;
    /**
     * The podmiotDoreczenia
     * @var string
     */
    public $podmiotDoreczenia;
    /**
     * The dataPelnomocnictwa
     * @var string
     */
    public $dataPelnomocnictwa;
    /**
     * The numerPelnomocnictwa
     * @var string
     */
    public $numerPelnomocnictwa;
    /**
     * The pieczecFirmowa
     * @var bool
     */
    public $pieczecFirmowa;
    /**
     * The miejscePozostawieniaZawiadomieniaODoreczeniu
     * @var string
     */
    public $miejscePozostawieniaZawiadomieniaODoreczeniu;
    /**
     * Constructor method for doreczeniePrzesylkiType
     * @uses DoreczeniePrzesylkiType::setData()
     * @uses DoreczeniePrzesylkiType::setOsobaOdbierajaca()
     * @uses DoreczeniePrzesylkiType::setPodmiotDoreczenia()
     * @uses DoreczeniePrzesylkiType::setDataPelnomocnictwa()
     * @uses DoreczeniePrzesylkiType::setNumerPelnomocnictwa()
     * @uses DoreczeniePrzesylkiType::setPieczecFirmowa()
     * @uses DoreczeniePrzesylkiType::setMiejscePozostawieniaZawiadomieniaODoreczeniu()
     * @param string $data
     * @param string $osobaOdbierajaca
     * @param string $podmiotDoreczenia
     * @param string $dataPelnomocnictwa
     * @param string $numerPelnomocnictwa
     * @param bool $pieczecFirmowa
     * @param string $miejscePozostawieniaZawiadomieniaODoreczeniu
     */
    public function __construct($data = null, $osobaOdbierajaca = null, $podmiotDoreczenia = null, $dataPelnomocnictwa = null, $numerPelnomocnictwa = null, $pieczecFirmowa = null, $miejscePozostawieniaZawiadomieniaODoreczeniu = null)
    {
        $this
            ->setData($data)
            ->setOsobaOdbierajaca($osobaOdbierajaca)
            ->setPodmiotDoreczenia($podmiotDoreczenia)
            ->setDataPelnomocnictwa($dataPelnomocnictwa)
            ->setNumerPelnomocnictwa($numerPelnomocnictwa)
            ->setPieczecFirmowa($pieczecFirmowa)
            ->setMiejscePozostawieniaZawiadomieniaODoreczeniu($miejscePozostawieniaZawiadomieniaODoreczeniu);
    }
    /**
     * Get data value
     * @return string|null
     */
    public function getData()
    {
        return $this->data;
    }
    /**
     * Set data value
     * @param string $data
     * @return DoreczeniePrzesylkiType
     */
    public function setData($data = null)
    {
        $this->data = $data;
        return $this;
    }
    /**
     * Get osobaOdbierajaca value
     * @return string|null
     */
    public function getOsobaOdbierajaca()
    {
        return $this->osobaOdbierajaca;
    }
    /**
     * Set osobaOdbierajaca value
     * @param string $osobaOdbierajaca
     * @return DoreczeniePrzesylkiType
     */
    public function setOsobaOdbierajaca($osobaOdbierajaca = null)
    {
        $this->osobaOdbierajaca = $osobaOdbierajaca;
        return $this;
    }
    /**
     * Get podmiotDoreczenia value
     * @return string|null
     */
    public function getPodmiotDoreczenia()
    {
        return $this->podmiotDoreczenia;
    }
    /**
     * Set podmiotDoreczenia value
     * @uses PodmiotDoreczeniaEnum::valueIsValid()
     * @uses PodmiotDoreczeniaEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $podmiotDoreczenia
     * @return DoreczeniePrzesylkiType
     */
    public function setPodmiotDoreczenia($podmiotDoreczenia = null)
    {
        $this->podmiotDoreczenia = $podmiotDoreczenia;
        return $this;
    }
    /**
     * Get dataPelnomocnictwa value
     * @return string|null
     */
    public function getDataPelnomocnictwa()
    {
        return $this->dataPelnomocnictwa;
    }
    /**
     * Set dataPelnomocnictwa value
     * @param string $dataPelnomocnictwa
     * @return DoreczeniePrzesylkiType
     */
    public function setDataPelnomocnictwa($dataPelnomocnictwa = null)
    {
        $this->dataPelnomocnictwa = $dataPelnomocnictwa;
        return $this;
    }
    /**
     * Get numerPelnomocnictwa value
     * @return string|null
     */
    public function getNumerPelnomocnictwa()
    {
        return $this->numerPelnomocnictwa;
    }
    /**
     * Set numerPelnomocnictwa value
     * @param string $numerPelnomocnictwa
     * @return DoreczeniePrzesylkiType
     */
    public function setNumerPelnomocnictwa($numerPelnomocnictwa = null)
    {
        $this->numerPelnomocnictwa = $numerPelnomocnictwa;
        return $this;
    }
    /**
     * Get pieczecFirmowa value
     * @return bool|null
     */
    public function getPieczecFirmowa()
    {
        return $this->pieczecFirmowa;
    }
    /**
     * Set pieczecFirmowa value
     * @param bool $pieczecFirmowa
     * @return DoreczeniePrzesylkiType
     */
    public function setPieczecFirmowa($pieczecFirmowa = null)
    {
        $this->pieczecFirmowa = $pieczecFirmowa;
        return $this;
    }
    /**
     * Get miejscePozostawieniaZawiadomieniaODoreczeniu value
     * @return string|null
     */
    public function getMiejscePozostawieniaZawiadomieniaODoreczeniu()
    {
        return $this->miejscePozostawieniaZawiadomieniaODoreczeniu;
    }
    /**
     * Set miejscePozostawieniaZawiadomieniaODoreczeniu value
     * @uses MiejscePozostawieniaZawiadomieniaODoreczeniuEnum::valueIsValid()
     * @uses MiejscePozostawieniaZawiadomieniaODoreczeniuEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $miejscePozostawieniaZawiadomieniaODoreczeniu
     * @return DoreczeniePrzesylkiType
     */
    public function setMiejscePozostawieniaZawiadomieniaODoreczeniu($miejscePozostawieniaZawiadomieniaODoreczeniu = null)
    {
        $this->miejscePozostawieniaZawiadomieniaODoreczeniu = $miejscePozostawieniaZawiadomieniaODoreczeniu;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return DoreczeniePrzesylkiType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
