<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for paczkaPocztowaType StructType
 * @subpackage Structs
 */
class PaczkaPocztowaType extends PrzesylkaRejestrowanaType
{
    /**
     * The kategoria
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $kategoria;
    /**
     * The gabaryt
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $gabaryt;
    /**
     * The epo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var EPOType
     */
    public $epo;
    /**
     * The ubezpieczenie
     * Meta informations extracted from the WSDL
     * - documentation: Ubezpieczenie dostępne tylko dla klientów indywidualnych
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var UbezpieczenieType
     */
    public $ubezpieczenie;
    /**
     * The zasadySpecjalne
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $zasadySpecjalne;
    /**
     * The posteRestante
     * Meta informations extracted from the WSDL
     * - default: false
     * - use: optional
     * @var bool
     */
    public $posteRestante;
    /**
     * The iloscPotwierdzenOdbioru
     * Meta informations extracted from the WSDL
     * - default: 0
     * - use: optional
     * - maxInclusive: 9
     * - minInclusive: 0
     * @var int
     */
    public $iloscPotwierdzenOdbioru;
    /**
     * The masa
     * Meta informations extracted from the WSDL
     * - documentation: masa przesyłki podana w gramach
     * - maxInclusive: 9999999
     * - minInclusive: 1
     * @var int
     */
    public $masa;
    /**
     * The wartosc
     * Meta informations extracted from the WSDL
     * - use: optional
     * - documentation: zadeklarowana wartość przesyłki w groszach
     * - maxInclusive: 9999999
     * - minInclusive: 0
     * @var int
     */
    public $wartosc;
    /**
     * The egzemplarzBiblioteczny
     * Meta informations extracted from the WSDL
     * - default: false
     * @var bool
     */
    public $egzemplarzBiblioteczny;
    /**
     * The dlaOciemnialych
     * Meta informations extracted from the WSDL
     * - default: false
     * @var bool
     */
    public $dlaOciemnialych;
    /**
     * Constructor method for paczkaPocztowaType
     * @uses PaczkaPocztowaType::setKategoria()
     * @uses PaczkaPocztowaType::setGabaryt()
     * @uses PaczkaPocztowaType::setEpo()
     * @uses PaczkaPocztowaType::setUbezpieczenie()
     * @uses PaczkaPocztowaType::setZasadySpecjalne()
     * @uses PaczkaPocztowaType::setPosteRestante()
     * @uses PaczkaPocztowaType::setIloscPotwierdzenOdbioru()
     * @uses PaczkaPocztowaType::setMasa()
     * @uses PaczkaPocztowaType::setWartosc()
     * @uses PaczkaPocztowaType::setEgzemplarzBiblioteczny()
     * @uses PaczkaPocztowaType::setDlaOciemnialych()
     * @param string $kategoria
     * @param string $gabaryt
     * @param EPOType $epo
     * @param UbezpieczenieType $ubezpieczenie
     * @param string $zasadySpecjalne
     * @param bool $posteRestante
     * @param int $iloscPotwierdzenOdbioru
     * @param int $masa
     * @param int $wartosc
     * @param bool $egzemplarzBiblioteczny
     * @param bool $dlaOciemnialych
     */
    public function __construct($kategoria = null, $gabaryt = null, EPOType $epo = null, UbezpieczenieType $ubezpieczenie = null, $zasadySpecjalne = null, $posteRestante = false, $iloscPotwierdzenOdbioru = 0, $masa = null, $wartosc = null, $egzemplarzBiblioteczny = false, $dlaOciemnialych = false)
    {
        $this
            ->setKategoria($kategoria)
            ->setGabaryt($gabaryt)
            ->setEpo($epo)
            ->setUbezpieczenie($ubezpieczenie)
            ->setZasadySpecjalne($zasadySpecjalne)
            ->setPosteRestante($posteRestante)
            ->setIloscPotwierdzenOdbioru($iloscPotwierdzenOdbioru)
            ->setMasa($masa)
            ->setWartosc($wartosc)
            ->setEgzemplarzBiblioteczny($egzemplarzBiblioteczny)
            ->setDlaOciemnialych($dlaOciemnialych);
    }
    /**
     * Get kategoria value
     * @return string
     */
    public function getKategoria()
    {
        return $this->kategoria;
    }
    /**
     * Set kategoria value
     * @uses KategoriaType::valueIsValid()
     * @uses KategoriaType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $kategoria
     * @return PaczkaPocztowaType
     */
    public function setKategoria($kategoria = null)
    {
        $this->kategoria = $kategoria;
        return $this;
    }
    /**
     * Get gabaryt value
     * @return string
     */
    public function getGabaryt()
    {
        return $this->gabaryt;
    }
    /**
     * Set gabaryt value
     * @uses GabarytType::valueIsValid()
     * @uses GabarytType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $gabaryt
     * @return PaczkaPocztowaType
     */
    public function setGabaryt($gabaryt = null)
    {
        $this->gabaryt = $gabaryt;
        return $this;
    }
    /**
     * Get epo value
     * @return EPOType|null
     */
    public function getEpo()
    {
        return $this->epo;
    }
    /**
     * Set epo value
     * @param EPOType $epo
     * @return PaczkaPocztowaType
     */
    public function setEpo(EPOType $epo = null)
    {
        $this->epo = $epo;
        return $this;
    }
    /**
     * Get ubezpieczenie value
     * @return UbezpieczenieType|null
     */
    public function getUbezpieczenie()
    {
        return $this->ubezpieczenie;
    }
    /**
     * Set ubezpieczenie value
     * @param UbezpieczenieType $ubezpieczenie
     * @return PaczkaPocztowaType
     */
    public function setUbezpieczenie(UbezpieczenieType $ubezpieczenie = null)
    {
        $this->ubezpieczenie = $ubezpieczenie;
        return $this;
    }
    /**
     * Get zasadySpecjalne value
     * @return string|null
     */
    public function getZasadySpecjalne()
    {
        return $this->zasadySpecjalne;
    }
    /**
     * Set zasadySpecjalne value
     * @uses ZasadySpecjalneEnum::valueIsValid()
     * @uses ZasadySpecjalneEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $zasadySpecjalne
     * @return PaczkaPocztowaType
     */
    public function setZasadySpecjalne($zasadySpecjalne = null)
    {
        $this->zasadySpecjalne = $zasadySpecjalne;
        return $this;
    }
    /**
     * Get posteRestante value
     * @return bool|null
     */
    public function getPosteRestante()
    {
        return $this->posteRestante;
    }
    /**
     * Set posteRestante value
     * @param bool $posteRestante
     * @return PaczkaPocztowaType
     */
    public function setPosteRestante($posteRestante = false)
    {
        $this->posteRestante = $posteRestante;
        return $this;
    }
    /**
     * Get iloscPotwierdzenOdbioru value
     * @return int|null
     */
    public function getIloscPotwierdzenOdbioru()
    {
        return $this->iloscPotwierdzenOdbioru;
    }
    /**
     * Set iloscPotwierdzenOdbioru value
     * @param int $iloscPotwierdzenOdbioru
     * @return PaczkaPocztowaType
     */
    public function setIloscPotwierdzenOdbioru($iloscPotwierdzenOdbioru = 0)
    {
        $this->iloscPotwierdzenOdbioru = $iloscPotwierdzenOdbioru;
        return $this;
    }
    /**
     * Get masa value
     * @return int|null
     */
    public function getMasa()
    {
        return $this->masa;
    }
    /**
     * Set masa value
     * @param int $masa
     * @return PaczkaPocztowaType
     */
    public function setMasa($masa = null)
    {
        $this->masa = $masa;
        return $this;
    }
    /**
     * Get wartosc value
     * @return int|null
     */
    public function getWartosc()
    {
        return $this->wartosc;
    }
    /**
     * Set wartosc value
     * @param int $wartosc
     * @return PaczkaPocztowaType
     */
    public function setWartosc($wartosc = null)
    {
        $this->wartosc = $wartosc;
        return $this;
    }
    /**
     * Get egzemplarzBiblioteczny value
     * @return bool|null
     */
    public function getEgzemplarzBiblioteczny()
    {
        return $this->egzemplarzBiblioteczny;
    }
    /**
     * Set egzemplarzBiblioteczny value
     * @param bool $egzemplarzBiblioteczny
     * @return PaczkaPocztowaType
     */
    public function setEgzemplarzBiblioteczny($egzemplarzBiblioteczny = false)
    {
        $this->egzemplarzBiblioteczny = $egzemplarzBiblioteczny;
        return $this;
    }
    /**
     * Get dlaOciemnialych value
     * @return bool|null
     */
    public function getDlaOciemnialych()
    {
        return $this->dlaOciemnialych;
    }
    /**
     * Set dlaOciemnialych value
     * @param bool $dlaOciemnialych
     * @return PaczkaPocztowaType
     */
    public function setDlaOciemnialych($dlaOciemnialych = false)
    {
        $this->dlaOciemnialych = $dlaOciemnialych;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return PaczkaPocztowaType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
