<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for przesylkaBiznesowaType StructType
 * @subpackage Structs
 */
class PrzesylkaBiznesowaType extends PrzesylkaRejestrowanaType
{
    /**
     * The subPrzesylka
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var SubPrzesylkaBiznesowaType[]
     */
    public $subPrzesylka;
    /**
     * The pobranie
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var PobranieType
     */
    public $pobranie;
    /**
     * The urzadWydaniaEPrzesylki
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var UrzadWydaniaEPrzesylkiType
     */
    public $urzadWydaniaEPrzesylki;
    /**
     * The ubezpieczenie
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var UbezpieczenieType
     */
    public $ubezpieczenie;
    /**
     * The epo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var EPOType
     */
    public $epo;
    /**
     * The zasadySpecjalne
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $zasadySpecjalne;
    /**
     * The masa
     * Meta informations extracted from the WSDL
     * - documentation: masa przesyłki podana w gramach
     * - maxInclusive: 9999999
     * - minInclusive: 1
     * @var int
     */
    public $masa;
    /**
     * The gabaryt
     * @var string
     */
    public $gabaryt;
    /**
     * The niestandardowa
     * Meta informations extracted from the WSDL
     * - documentation: TRUE jeżeli przesyłka niestandardowa. Za przesyłkę niestandardową uważa się przesyłkę spełniającą przynajmniej jedno z poniższych kryteriów: wymiary wynoszące 250 cm < (a+b+c) <= 300 cm, przy czym dł. maks. = 150 cm,
     * wymiary wynoszące (a+b+c) $lte; 250 cm, przy czym dł. maks. = 150 cm, posiadającej: - nieregularne kształty lub - wystające elementy, lub - składającej się z dwóch odrębnych części, połączonych w jedną nieregularną całość (np. za
     * pomocą folii stretch, taśmy itp.).
     * @var bool
     */
    public $niestandardowa;
    /**
     * The wartosc
     * Meta informations extracted from the WSDL
     * - documentation: zadeklarowana wartość przesyłki w groszach
     * - maxInclusive: 9999999
     * - minInclusive: 0
     * @var int
     */
    public $wartosc;
    /**
     * The ostroznie
     * @var bool
     */
    public $ostroznie;
    /**
     * The numerTransakcjiOdbioru
     * Meta informations extracted from the WSDL
     * - maxLength: 50
     * @var string
     */
    public $numerTransakcjiOdbioru;
    /**
     * Constructor method for przesylkaBiznesowaType
     * @uses PrzesylkaBiznesowaType::setSubPrzesylka()
     * @uses PrzesylkaBiznesowaType::setPobranie()
     * @uses PrzesylkaBiznesowaType::setUrzadWydaniaEPrzesylki()
     * @uses PrzesylkaBiznesowaType::setUbezpieczenie()
     * @uses PrzesylkaBiznesowaType::setEpo()
     * @uses PrzesylkaBiznesowaType::setZasadySpecjalne()
     * @uses PrzesylkaBiznesowaType::setMasa()
     * @uses PrzesylkaBiznesowaType::setGabaryt()
     * @uses PrzesylkaBiznesowaType::setNiestandardowa()
     * @uses PrzesylkaBiznesowaType::setWartosc()
     * @uses PrzesylkaBiznesowaType::setOstroznie()
     * @uses PrzesylkaBiznesowaType::setNumerTransakcjiOdbioru()
     * @param SubPrzesylkaBiznesowaType[] $subPrzesylka
     * @param PobranieType $pobranie
     * @param UrzadWydaniaEPrzesylkiType $urzadWydaniaEPrzesylki
     * @param UbezpieczenieType $ubezpieczenie
     * @param EPOType $epo
     * @param string $zasadySpecjalne
     * @param int $masa
     * @param string $gabaryt
     * @param bool $niestandardowa
     * @param int $wartosc
     * @param bool $ostroznie
     * @param string $numerTransakcjiOdbioru
     */
    public function __construct(array $subPrzesylka = array(), PobranieType $pobranie = null, UrzadWydaniaEPrzesylkiType $urzadWydaniaEPrzesylki = null, UbezpieczenieType $ubezpieczenie = null, EPOType $epo = null, $zasadySpecjalne = null, $masa = null, $gabaryt = null, $niestandardowa = null, $wartosc = null, $ostroznie = null, $numerTransakcjiOdbioru = null)
    {
        $this
            ->setSubPrzesylka($subPrzesylka)
            ->setPobranie($pobranie)
            ->setUrzadWydaniaEPrzesylki($urzadWydaniaEPrzesylki)
            ->setUbezpieczenie($ubezpieczenie)
            ->setEpo($epo)
            ->setZasadySpecjalne($zasadySpecjalne)
            ->setMasa($masa)
            ->setGabaryt($gabaryt)
            ->setNiestandardowa($niestandardowa)
            ->setWartosc($wartosc)
            ->setOstroznie($ostroznie)
            ->setNumerTransakcjiOdbioru($numerTransakcjiOdbioru);
    }
    /**
     * Get subPrzesylka value
     * @return SubPrzesylkaBiznesowaType[]
     */
    public function getSubPrzesylka()
    {
        return $this->subPrzesylka;
    }
    /**
     * Set subPrzesylka value
     * @throws \InvalidArgumentException
     * @param SubPrzesylkaBiznesowaType[] $subPrzesylka
     * @return PrzesylkaBiznesowaType
     */
    public function setSubPrzesylka(array $subPrzesylka = array())
    {
        $this->subPrzesylka = $subPrzesylka;
        return $this;
    }
    /**
     * Add item to subPrzesylka value
     * @throws \InvalidArgumentException
     * @param SubPrzesylkaBiznesowaType $item
     * @return PrzesylkaBiznesowaType
     */
    public function addToSubPrzesylka(SubPrzesylkaBiznesowaType $item)
    {
        $this->subPrzesylka[] = $item;
        return $this;
    }
    /**
     * Get pobranie value
     * @return PobranieType|null
     */
    public function getPobranie()
    {
        return $this->pobranie;
    }
    /**
     * Set pobranie value
     * @param PobranieType $pobranie
     * @return PrzesylkaBiznesowaType
     */
    public function setPobranie(PobranieType $pobranie = null)
    {
        $this->pobranie = $pobranie;
        return $this;
    }
    /**
     * Get urzadWydaniaEPrzesylki value
     * @return UrzadWydaniaEPrzesylkiType|null
     */
    public function getUrzadWydaniaEPrzesylki()
    {
        return $this->urzadWydaniaEPrzesylki;
    }
    /**
     * Set urzadWydaniaEPrzesylki value
     * @param UrzadWydaniaEPrzesylkiType $urzadWydaniaEPrzesylki
     * @return PrzesylkaBiznesowaType
     */
    public function setUrzadWydaniaEPrzesylki(UrzadWydaniaEPrzesylkiType $urzadWydaniaEPrzesylki = null)
    {
        $this->urzadWydaniaEPrzesylki = $urzadWydaniaEPrzesylki;
        return $this;
    }
    /**
     * Get ubezpieczenie value
     * @return UbezpieczenieType|null
     */
    public function getUbezpieczenie()
    {
        return $this->ubezpieczenie;
    }
    /**
     * Set ubezpieczenie value
     * @param UbezpieczenieType $ubezpieczenie
     * @return PrzesylkaBiznesowaType
     */
    public function setUbezpieczenie(UbezpieczenieType $ubezpieczenie = null)
    {
        $this->ubezpieczenie = $ubezpieczenie;
        return $this;
    }
    /**
     * Get epo value
     * @return EPOType|null
     */
    public function getEpo()
    {
        return $this->epo;
    }
    /**
     * Set epo value
     * @param EPOType $epo
     * @return PrzesylkaBiznesowaType
     */
    public function setEpo(EPOType $epo = null)
    {
        $this->epo = $epo;
        return $this;
    }
    /**
     * Get zasadySpecjalne value
     * @return string|null
     */
    public function getZasadySpecjalne()
    {
        return $this->zasadySpecjalne;
    }
    /**
     * Set zasadySpecjalne value
     * @uses ZasadySpecjalneEnum::valueIsValid()
     * @uses ZasadySpecjalneEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $zasadySpecjalne
     * @return PrzesylkaBiznesowaType
     */
    public function setZasadySpecjalne($zasadySpecjalne = null)
    {
        $this->zasadySpecjalne = $zasadySpecjalne;
        return $this;
    }
    /**
     * Get masa value
     * @return int|null
     */
    public function getMasa()
    {
        return $this->masa;
    }
    /**
     * Set masa value
     * @param int $masa
     * @return PrzesylkaBiznesowaType
     */
    public function setMasa($masa = null)
    {
        $this->masa = $masa;
        return $this;
    }
    /**
     * Get gabaryt value
     * @return string|null
     */
    public function getGabaryt()
    {
        return $this->gabaryt;
    }
    /**
     * Set gabaryt value
     * @uses GabarytBiznesowaType::valueIsValid()
     * @uses GabarytBiznesowaType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $gabaryt
     * @return PrzesylkaBiznesowaType
     */
    public function setGabaryt($gabaryt = null)
    {
        $this->gabaryt = $gabaryt;
        return $this;
    }
    /**
     * Get niestandardowa value
     * @return bool|null
     */
    public function getNiestandardowa()
    {
        return $this->niestandardowa;
    }
    /**
     * Set niestandardowa value
     * @param bool $niestandardowa
     * @return PrzesylkaBiznesowaType
     */
    public function setNiestandardowa($niestandardowa = null)
    {
        $this->niestandardowa = $niestandardowa;
        return $this;
    }
    /**
     * Get wartosc value
     * @return int|null
     */
    public function getWartosc()
    {
        return $this->wartosc;
    }
    /**
     * Set wartosc value
     * @param int $wartosc
     * @return PrzesylkaBiznesowaType
     */
    public function setWartosc($wartosc = null)
    {
        $this->wartosc = $wartosc;
        return $this;
    }
    /**
     * Get ostroznie value
     * @return bool|null
     */
    public function getOstroznie()
    {
        return $this->ostroznie;
    }
    /**
     * Set ostroznie value
     * @param bool $ostroznie
     * @return PrzesylkaBiznesowaType
     */
    public function setOstroznie($ostroznie = null)
    {
        $this->ostroznie = $ostroznie;
        return $this;
    }
    /**
     * Get numerTransakcjiOdbioru value
     * @return string|null
     */
    public function getNumerTransakcjiOdbioru()
    {
        return $this->numerTransakcjiOdbioru;
    }
    /**
     * Set numerTransakcjiOdbioru value
     * @param string $numerTransakcjiOdbioru
     * @return PrzesylkaBiznesowaType
     */
    public function setNumerTransakcjiOdbioru($numerTransakcjiOdbioru = null)
    {
        $this->numerTransakcjiOdbioru = $numerTransakcjiOdbioru;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return PrzesylkaBiznesowaType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
