<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for reklamowanaPrzesylkaType StructType
 * @subpackage Structs
 */
class ReklamowanaPrzesylkaType extends AbstractStructBase
{
    /**
     * The przesylka
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var PrzesylkaType
     */
    public $przesylka;
    /**
     * The powodReklamacji
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var PowodReklamacjiType
     */
    public $powodReklamacji;
    /**
     * The dataNadania
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $dataNadania;
    /**
     * The nrb
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 26
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $nrb;
    /**
     * The numerFaktury
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 100
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $numerFaktury;
    /**
     * The ezgoda
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $ezgoda;
    /**
     * The urzadNadania
     * Meta information extracted from the WSDL
     * - base: xsd:int
     * @var int
     */
    public $urzadNadania;
    /**
     * The powodReklamacjiOpis
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $powodReklamacjiOpis;
    /**
     * The odszkodowanie
     * @var int
     */
    public $odszkodowanie;
    /**
     * The oplata
     * @var int
     */
    public $oplata;
    /**
     * The oczekiwaneOdszkodowanie
     * @var int
     */
    public $oczekiwaneOdszkodowanie;
    /**
     * Constructor method for reklamowanaPrzesylkaType
     * @uses ReklamowanaPrzesylkaType::setPrzesylka()
     * @uses ReklamowanaPrzesylkaType::setPowodReklamacji()
     * @uses ReklamowanaPrzesylkaType::setDataNadania()
     * @uses ReklamowanaPrzesylkaType::setNrb()
     * @uses ReklamowanaPrzesylkaType::setNumerFaktury()
     * @uses ReklamowanaPrzesylkaType::setEzgoda()
     * @uses ReklamowanaPrzesylkaType::setUrzadNadania()
     * @uses ReklamowanaPrzesylkaType::setPowodReklamacjiOpis()
     * @uses ReklamowanaPrzesylkaType::setOdszkodowanie()
     * @uses ReklamowanaPrzesylkaType::setOplata()
     * @uses ReklamowanaPrzesylkaType::setOczekiwaneOdszkodowanie()
     * @param PrzesylkaType $przesylka
     * @param PowodReklamacjiType $powodReklamacji
     * @param string $dataNadania
     * @param string $nrb
     * @param string $numerFaktury
     * @param bool $ezgoda
     * @param int $urzadNadania
     * @param string $powodReklamacjiOpis
     * @param int $odszkodowanie
     * @param int $oplata
     * @param int $oczekiwaneOdszkodowanie
     */
    public function __construct(PrzesylkaType $przesylka = null, PowodReklamacjiType $powodReklamacji = null, $dataNadania = null, $nrb = null, $numerFaktury = null, $ezgoda = null, $urzadNadania = null, $powodReklamacjiOpis = null, $odszkodowanie = null, $oplata = null, $oczekiwaneOdszkodowanie = null)
    {
        $this
            ->setPrzesylka($przesylka)
            ->setPowodReklamacji($powodReklamacji)
            ->setDataNadania($dataNadania)
            ->setNrb($nrb)
            ->setNumerFaktury($numerFaktury)
            ->setEzgoda($ezgoda)
            ->setUrzadNadania($urzadNadania)
            ->setPowodReklamacjiOpis($powodReklamacjiOpis)
            ->setOdszkodowanie($odszkodowanie)
            ->setOplata($oplata)
            ->setOczekiwaneOdszkodowanie($oczekiwaneOdszkodowanie);
    }
    /**
     * Get przesylka value
     * @return PrzesylkaType
     */
    public function getPrzesylka()
    {
        return $this->przesylka;
    }
    /**
     * Set przesylka value
     * @param PrzesylkaType $przesylka
     * @return ReklamowanaPrzesylkaType
     */
    public function setPrzesylka(PrzesylkaType $przesylka = null)
    {
        $this->przesylka = $przesylka;
        return $this;
    }
    /**
     * Get powodReklamacji value
     * @return PowodReklamacjiType
     */
    public function getPowodReklamacji()
    {
        return $this->powodReklamacji;
    }
    /**
     * Set powodReklamacji value
     * @param PowodReklamacjiType $powodReklamacji
     * @return ReklamowanaPrzesylkaType
     */
    public function setPowodReklamacji(PowodReklamacjiType $powodReklamacji = null)
    {
        $this->powodReklamacji = $powodReklamacji;
        return $this;
    }
    /**
     * Get dataNadania value
     * @return string
     */
    public function getDataNadania()
    {
        return $this->dataNadania;
    }
    /**
     * Set dataNadania value
     * @param string $dataNadania
     * @return ReklamowanaPrzesylkaType
     */
    public function setDataNadania($dataNadania = null)
    {
        $this->dataNadania = $dataNadania;
        return $this;
    }
    /**
     * Get nrb value
     * @return string|null
     */
    public function getNrb()
    {
        return $this->nrb;
    }
    /**
     * Set nrb value
     * @param string $nrb
     * @return ReklamowanaPrzesylkaType
     */
    public function setNrb($nrb = null)
    {
        $this->nrb = $nrb;
        return $this;
    }
    /**
     * Get numerFaktury value
     * @return string|null
     */
    public function getNumerFaktury()
    {
        return $this->numerFaktury;
    }
    /**
     * Set numerFaktury value
     * @param string $numerFaktury
     * @return ReklamowanaPrzesylkaType
     */
    public function setNumerFaktury($numerFaktury = null)
    {
        $this->numerFaktury = $numerFaktury;
        return $this;
    }
    /**
     * Get ezgoda value
     * @return bool|null
     */
    public function getEzgoda()
    {
        return $this->ezgoda;
    }
    /**
     * Set ezgoda value
     * @param bool $ezgoda
     * @return ReklamowanaPrzesylkaType
     */
    public function setEzgoda($ezgoda = null)
    {
        $this->ezgoda = $ezgoda;
        return $this;
    }
    /**
     * Get urzadNadania value
     * @return int|null
     */
    public function getUrzadNadania()
    {
        return $this->urzadNadania;
    }
    /**
     * Set urzadNadania value
     * @param int $urzadNadania
     * @return ReklamowanaPrzesylkaType
     */
    public function setUrzadNadania($urzadNadania = null)
    {
        $this->urzadNadania = $urzadNadania;
        return $this;
    }
    /**
     * Get powodReklamacjiOpis value
     * @return string|null
     */
    public function getPowodReklamacjiOpis()
    {
        return $this->powodReklamacjiOpis;
    }
    /**
     * Set powodReklamacjiOpis value
     * @param string $powodReklamacjiOpis
     * @return ReklamowanaPrzesylkaType
     */
    public function setPowodReklamacjiOpis($powodReklamacjiOpis = null)
    {
        $this->powodReklamacjiOpis = $powodReklamacjiOpis;
        return $this;
    }
    /**
     * Get odszkodowanie value
     * @return int|null
     */
    public function getOdszkodowanie()
    {
        return $this->odszkodowanie;
    }
    /**
     * Set odszkodowanie value
     * @param int $odszkodowanie
     * @return ReklamowanaPrzesylkaType
     */
    public function setOdszkodowanie($odszkodowanie = null)
    {
        $this->odszkodowanie = $odszkodowanie;
        return $this;
    }
    /**
     * Get oplata value
     * @return int|null
     */
    public function getOplata()
    {
        return $this->oplata;
    }
    /**
     * Set oplata value
     * @param int $oplata
     * @return ReklamowanaPrzesylkaType
     */
    public function setOplata($oplata = null)
    {
        $this->oplata = $oplata;
        return $this;
    }
    /**
     * Get oczekiwaneOdszkodowanie value
     * @return int|null
     */
    public function getOczekiwaneOdszkodowanie()
    {
        return $this->oczekiwaneOdszkodowanie;
    }
    /**
     * Set oczekiwaneOdszkodowanie value
     * @param int $oczekiwaneOdszkodowanie
     * @return ReklamowanaPrzesylkaType
     */
    public function setOczekiwaneOdszkodowanie($oczekiwaneOdszkodowanie = null)
    {
        $this->oczekiwaneOdszkodowanie = $oczekiwaneOdszkodowanie;
        return $this;
    }
}
