<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getParcelContentListResponse StructType
 * @subpackage Structs
 */
class GetParcelContentListResponse extends AbstractStructBase
{
    /**
     * The parcelContent
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var ParcelContentType[]
     */
    public $parcelContent;
    /**
     * The error
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var ErrorType[]
     */
    public $error;
    /**
     * Constructor method for getParcelContentListResponse
     * @uses GetParcelContentListResponse::setParcelContent()
     * @uses GetParcelContentListResponse::setError()
     * @param ParcelContentType[] $parcelContent
     * @param ErrorType[] $error
     */
    public function __construct(array $parcelContent = array(), array $error = array())
    {
        $this
            ->setParcelContent($parcelContent)
            ->setError($error);
    }
    /**
     * Get parcelContent value
     * @return ParcelContentType[]|null
     */
    public function getParcelContent()
    {
        return $this->parcelContent;
    }
    /**
     * Set parcelContent value
     * @param ParcelContentType[] $parcelContent
     * @return GetParcelContentListResponse
     */
    public function setParcelContent(array $parcelContent = array())
    {
        $this->parcelContent = $parcelContent;
        return $this;
    }
    /**
     * Add item to parcelContent value
     * @throws \InvalidArgumentException
     * @param ParcelContentType $item
     * @return GetParcelContentListResponse
     */
    public function addToParcelContent(ParcelContentType $item)
    {
        $this->parcelContent[] = $item;
        return $this;
    }
    /**
     * Get error value
     * @return ErrorType[]|null
     */
    public function getError()
    {
        return $this->error;
    }
    /**
     * Set error value
     * @param ErrorType[] $error
     * @return GetParcelContentListResponse
     */
    public function setError(array $error = array())
    {
        $this->error = $error;
        return $this;
    }
    /**
     * Add item to error value
     * @throws \InvalidArgumentException
     * @param ErrorType $item
     * @return GetParcelContentListResponse
     */
    public function addToError(ErrorType $item)
    {
        $this->error[] = $item;
        return $this;
    }
}
