<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for przesylkaPoleconaKrajowaType StructType
 * @subpackage Structs
 */
class PrzesylkaPoleconaKrajowaType extends PrzesylkaRejestrowanaType
{
    /**
     * The kategoria
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $kategoria;
    /**
     * The epo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var EPOType
     */
    public $epo;
    /**
     * The potwierdzenieDoreczenia
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var PotwierdzenieDoreczeniaType
     */
    public $potwierdzenieDoreczenia;
    /**
     * The idLibraryForLegalDeposit
     * Meta information extracted from the WSDL
     * - documentation: Identifier library for legal deposit from list downloaded using the getLibrariesForLegalDeposits method
     * - base: xsd:string
     * - maxLength: 4
     * - maxOccurs: 1
     * - minLength: 4
     * - minOccurs: 0
     * @var string
     */
    public $idLibraryForLegalDeposit;
    /**
     * The zasadySpecjalne
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $zasadySpecjalne;
    /**
     * The posteRestante
     * Meta information extracted from the WSDL
     * - default: false
     * - use: optional
     * @var bool
     */
    public $posteRestante;
    /**
     * The iloscPotwierdzenOdbioru
     * Meta information extracted from the WSDL
     * - base: xsd:int
     * - default: 0
     * - maxInclusive: 9
     * - minInclusive: 0
     * - use: optional
     * @var int
     */
    public $iloscPotwierdzenOdbioru;
    /**
     * The gabaryt
     * Meta information extracted from the WSDL
     * - documentation: Gabaryt przesyłki
     * - use: optional
     * @var string
     */
    public $gabaryt;
    /**
     * The format
     * Meta information extracted from the WSDL
     * - documentation: Format przesyłki
     * - use: optional
     * @var string
     */
    public $format;
    /**
     * The masa
     * Meta information extracted from the WSDL
     * - documentation: masa przesyłki podana w gramach
     * - base: xsd:int
     * - maxInclusive: 9999999
     * - minInclusive: 1
     * - use: optional
     * @var int
     */
    public $masa;
    /**
     * The egzemplarzBiblioteczny
     * @var bool
     */
    public $egzemplarzBiblioteczny;
    /**
     * The dlaOciemnialych
     * @var bool
     */
    public $dlaOciemnialych;
    /**
     * The obszarMiasto
     * @var bool
     */
    public $obszarMiasto;
    /**
     * The miejscowa
     * @var bool
     */
    public $miejscowa;
    /**
     * The numerPrzesylkiKlienta
     * @var string
     */
    public $numerPrzesylkiKlienta;
    /**
     * Constructor method for przesylkaPoleconaKrajowaType
     * @uses PrzesylkaPoleconaKrajowaType::setKategoria()
     * @uses PrzesylkaPoleconaKrajowaType::setEpo()
     * @uses PrzesylkaPoleconaKrajowaType::setPotwierdzenieDoreczenia()
     * @uses PrzesylkaPoleconaKrajowaType::setIdLibraryForLegalDeposit()
     * @uses PrzesylkaPoleconaKrajowaType::setZasadySpecjalne()
     * @uses PrzesylkaPoleconaKrajowaType::setPosteRestante()
     * @uses PrzesylkaPoleconaKrajowaType::setIloscPotwierdzenOdbioru()
     * @uses PrzesylkaPoleconaKrajowaType::setGabaryt()
     * @uses PrzesylkaPoleconaKrajowaType::setFormat()
     * @uses PrzesylkaPoleconaKrajowaType::setMasa()
     * @uses PrzesylkaPoleconaKrajowaType::setEgzemplarzBiblioteczny()
     * @uses PrzesylkaPoleconaKrajowaType::setDlaOciemnialych()
     * @uses PrzesylkaPoleconaKrajowaType::setObszarMiasto()
     * @uses PrzesylkaPoleconaKrajowaType::setMiejscowa()
     * @uses PrzesylkaPoleconaKrajowaType::setNumerPrzesylkiKlienta()
     * @param string $kategoria
     * @param EPOType $epo
     * @param PotwierdzenieDoreczeniaType $potwierdzenieDoreczenia
     * @param string $idLibraryForLegalDeposit
     * @param string $zasadySpecjalne
     * @param bool $posteRestante
     * @param int $iloscPotwierdzenOdbioru
     * @param string $gabaryt
     * @param string $format
     * @param int $masa
     * @param bool $egzemplarzBiblioteczny
     * @param bool $dlaOciemnialych
     * @param bool $obszarMiasto
     * @param bool $miejscowa
     * @param string $numerPrzesylkiKlienta
     */
    public function __construct($kategoria = null, EPOType $epo = null, PotwierdzenieDoreczeniaType $potwierdzenieDoreczenia = null, $idLibraryForLegalDeposit = null, $zasadySpecjalne = null, $posteRestante = false, $iloscPotwierdzenOdbioru = 0, $gabaryt = null, $format = null, $masa = null, $egzemplarzBiblioteczny = null, $dlaOciemnialych = null, $obszarMiasto = null, $miejscowa = null, $numerPrzesylkiKlienta = null)
    {
        $this
            ->setKategoria($kategoria)
            ->setEpo($epo)
            ->setPotwierdzenieDoreczenia($potwierdzenieDoreczenia)
            ->setIdLibraryForLegalDeposit($idLibraryForLegalDeposit)
            ->setZasadySpecjalne($zasadySpecjalne)
            ->setPosteRestante($posteRestante)
            ->setIloscPotwierdzenOdbioru($iloscPotwierdzenOdbioru)
            ->setGabaryt($gabaryt)
            ->setFormat($format)
            ->setMasa($masa)
            ->setEgzemplarzBiblioteczny($egzemplarzBiblioteczny)
            ->setDlaOciemnialych($dlaOciemnialych)
            ->setObszarMiasto($obszarMiasto)
            ->setMiejscowa($miejscowa)
            ->setNumerPrzesylkiKlienta($numerPrzesylkiKlienta);
    }
    /**
     * Get kategoria value
     * @return string
     */
    public function getKategoria()
    {
        return $this->kategoria;
    }
    /**
     * Set kategoria value
     * @param string $kategoria
     * @return PrzesylkaPoleconaKrajowaType
     */
    public function setKategoria($kategoria = null)
    {
        $this->kategoria = $kategoria;
        return $this;
    }
    /**
     * Get epo value
     * @return EPOType|null
     */
    public function getEpo()
    {
        return $this->epo;
    }
    /**
     * Set epo value
     * @param EPOType $epo
     * @return PrzesylkaPoleconaKrajowaType
     */
    public function setEpo(EPOType $epo = null)
    {
        $this->epo = $epo;
        return $this;
    }
    /**
     * Get potwierdzenieDoreczenia value
     * @return PotwierdzenieDoreczeniaType|null
     */
    public function getPotwierdzenieDoreczenia()
    {
        return $this->potwierdzenieDoreczenia;
    }
    /**
     * Set potwierdzenieDoreczenia value
     * @param PotwierdzenieDoreczeniaType $potwierdzenieDoreczenia
     * @return PrzesylkaPoleconaKrajowaType
     */
    public function setPotwierdzenieDoreczenia(PotwierdzenieDoreczeniaType $potwierdzenieDoreczenia = null)
    {
        $this->potwierdzenieDoreczenia = $potwierdzenieDoreczenia;
        return $this;
    }
    /**
     * Get idLibraryForLegalDeposit value
     * @return string|null
     */
    public function getIdLibraryForLegalDeposit()
    {
        return $this->idLibraryForLegalDeposit;
    }
    /**
     * Set idLibraryForLegalDeposit value
     * @param string $idLibraryForLegalDeposit
     * @return PrzesylkaPoleconaKrajowaType
     */
    public function setIdLibraryForLegalDeposit($idLibraryForLegalDeposit = null)
    {
        $this->idLibraryForLegalDeposit = $idLibraryForLegalDeposit;
        return $this;
    }
    /**
     * Get zasadySpecjalne value
     * @return string|null
     */
    public function getZasadySpecjalne()
    {
        return $this->zasadySpecjalne;
    }
    /**
     * Set zasadySpecjalne value
     * @param string $zasadySpecjalne
     * @return PrzesylkaPoleconaKrajowaType
     */
    public function setZasadySpecjalne($zasadySpecjalne = null)
    {
        $this->zasadySpecjalne = $zasadySpecjalne;
        return $this;
    }
    /**
     * Get posteRestante value
     * @return bool|null
     */
    public function getPosteRestante()
    {
        return $this->posteRestante;
    }
    /**
     * Set posteRestante value
     * @param bool $posteRestante
     * @return PrzesylkaPoleconaKrajowaType
     */
    public function setPosteRestante($posteRestante = false)
    {
        $this->posteRestante = $posteRestante;
        return $this;
    }
    /**
     * Get iloscPotwierdzenOdbioru value
     * @return int|null
     */
    public function getIloscPotwierdzenOdbioru()
    {
        return $this->iloscPotwierdzenOdbioru;
    }
    /**
     * Set iloscPotwierdzenOdbioru value
     * @param int $iloscPotwierdzenOdbioru
     * @return PrzesylkaPoleconaKrajowaType
     */
    public function setIloscPotwierdzenOdbioru($iloscPotwierdzenOdbioru = 0)
    {
        $this->iloscPotwierdzenOdbioru = $iloscPotwierdzenOdbioru;
        return $this;
    }
    /**
     * Get gabaryt value
     * @return string|null
     */
    public function getGabaryt()
    {
        return $this->gabaryt;
    }
    /**
     * Set gabaryt value
     * @param string $gabaryt
     * @return PrzesylkaPoleconaKrajowaType
     */
    public function setGabaryt($gabaryt = null)
    {
        $this->gabaryt = $gabaryt;
        return $this;
    }
    /**
     * Get format value
     * @return string|null
     */
    public function getFormat()
    {
        return $this->format;
    }
    /**
     * Set format value
     * @param string $format
     * @return PrzesylkaPoleconaKrajowaType
     */
    public function setFormat($format = null)
    {
        $this->format = $format;
        return $this;
    }
    /**
     * Get masa value
     * @return int|null
     */
    public function getMasa()
    {
        return $this->masa;
    }
    /**
     * Set masa value
     * @param int $masa
     * @return PrzesylkaPoleconaKrajowaType
     */
    public function setMasa($masa = null)
    {
        $this->masa = $masa;
        return $this;
    }
    /**
     * Get egzemplarzBiblioteczny value
     * @return bool|null
     */
    public function getEgzemplarzBiblioteczny()
    {
        return $this->egzemplarzBiblioteczny;
    }
    /**
     * Set egzemplarzBiblioteczny value
     * @param bool $egzemplarzBiblioteczny
     * @return PrzesylkaPoleconaKrajowaType
     */
    public function setEgzemplarzBiblioteczny($egzemplarzBiblioteczny = null)
    {
        $this->egzemplarzBiblioteczny = $egzemplarzBiblioteczny;
        return $this;
    }
    /**
     * Get dlaOciemnialych value
     * @return bool|null
     */
    public function getDlaOciemnialych()
    {
        return $this->dlaOciemnialych;
    }
    /**
     * Set dlaOciemnialych value
     * @param bool $dlaOciemnialych
     * @return PrzesylkaPoleconaKrajowaType
     */
    public function setDlaOciemnialych($dlaOciemnialych = null)
    {
        $this->dlaOciemnialych = $dlaOciemnialych;
        return $this;
    }
    /**
     * Get obszarMiasto value
     * @return bool|null
     */
    public function getObszarMiasto()
    {
        return $this->obszarMiasto;
    }
    /**
     * Set obszarMiasto value
     * @param bool $obszarMiasto
     * @return PrzesylkaPoleconaKrajowaType
     */
    public function setObszarMiasto($obszarMiasto = null)
    {
        $this->obszarMiasto = $obszarMiasto;
        return $this;
    }
    /**
     * Get miejscowa value
     * @return bool|null
     */
    public function getMiejscowa()
    {
        return $this->miejscowa;
    }
    /**
     * Set miejscowa value
     * @param bool $miejscowa
     * @return PrzesylkaPoleconaKrajowaType
     */
    public function setMiejscowa($miejscowa = null)
    {
        $this->miejscowa = $miejscowa;
        return $this;
    }
    /**
     * Get numerPrzesylkiKlienta value
     * @return string|null
     */
    public function getNumerPrzesylkiKlienta()
    {
        return $this->numerPrzesylkiKlienta;
    }
    /**
     * Set numerPrzesylkiKlienta value
     * @param string $numerPrzesylkiKlienta
     * @return PrzesylkaPoleconaKrajowaType
     */
    public function setNumerPrzesylkiKlienta($numerPrzesylkiKlienta = null)
    {
        $this->numerPrzesylkiKlienta = $numerPrzesylkiKlienta;
        return $this;
    }
}
