<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for przesylkaPobraniowaType StructType
 * @subpackage Structs
 */
class PrzesylkaPobraniowaType extends PrzesylkaRejestrowanaType
{
    /**
     * The kategoria
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $kategoria;
    /**
     * The gabaryt
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $gabaryt;
    /**
     * The wartosc
     * Meta information extracted from the WSDL
     * - documentation: zadeklarowana wartość przesyłki w groszach
     * - base: xsd:int
     * - maxInclusive: 9999999
     * - minInclusive: 0
     * - use: required
     * @var int
     */
    public $wartosc;
    /**
     * The pobranie
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var PobranieType
     */
    public $pobranie;
    /**
     * The posteRestante
     * Meta information extracted from the WSDL
     * - default: false
     * - use: optional
     * @var bool
     */
    public $posteRestante;
    /**
     * The iloscPotwierdzenOdbioru
     * Meta information extracted from the WSDL
     * - base: xsd:int
     * - default: 0
     * - maxInclusive: 9
     * - minInclusive: 0
     * - use: optional
     * @var int
     */
    public $iloscPotwierdzenOdbioru;
    /**
     * The ostroznie
     * Meta information extracted from the WSDL
     * - default: false
     * - use: optional
     * @var bool
     */
    public $ostroznie;
    /**
     * The masa
     * Meta information extracted from the WSDL
     * - documentation: masa przesyłki podana w gramach
     * - base: xsd:int
     * - maxInclusive: 9999999
     * - minInclusive: 1
     * - use: optional
     * @var int
     */
    public $masa;
    /**
     * Constructor method for przesylkaPobraniowaType
     * @uses PrzesylkaPobraniowaType::setKategoria()
     * @uses PrzesylkaPobraniowaType::setGabaryt()
     * @uses PrzesylkaPobraniowaType::setWartosc()
     * @uses PrzesylkaPobraniowaType::setPobranie()
     * @uses PrzesylkaPobraniowaType::setPosteRestante()
     * @uses PrzesylkaPobraniowaType::setIloscPotwierdzenOdbioru()
     * @uses PrzesylkaPobraniowaType::setOstroznie()
     * @uses PrzesylkaPobraniowaType::setMasa()
     * @param string $kategoria
     * @param string $gabaryt
     * @param int $wartosc
     * @param PobranieType $pobranie
     * @param bool $posteRestante
     * @param int $iloscPotwierdzenOdbioru
     * @param bool $ostroznie
     * @param int $masa
     */
    public function __construct($kategoria = null, $gabaryt = null, $wartosc = null, PobranieType $pobranie = null, $posteRestante = false, $iloscPotwierdzenOdbioru = 0, $ostroznie = false, $masa = null)
    {
        $this
            ->setKategoria($kategoria)
            ->setGabaryt($gabaryt)
            ->setWartosc($wartosc)
            ->setPobranie($pobranie)
            ->setPosteRestante($posteRestante)
            ->setIloscPotwierdzenOdbioru($iloscPotwierdzenOdbioru)
            ->setOstroznie($ostroznie)
            ->setMasa($masa);
    }
    /**
     * Get kategoria value
     * @return string
     */
    public function getKategoria()
    {
        return $this->kategoria;
    }
    /**
     * Set kategoria value
     * @param string $kategoria
     * @return PrzesylkaPobraniowaType
     */
    public function setKategoria($kategoria = null)
    {
        $this->kategoria = $kategoria;
        return $this;
    }
    /**
     * Get gabaryt value
     * @return string
     */
    public function getGabaryt()
    {
        return $this->gabaryt;
    }
    /**
     * Set gabaryt value
     * @param string $gabaryt
     * @return PrzesylkaPobraniowaType
     */
    public function setGabaryt($gabaryt = null)
    {
        $this->gabaryt = $gabaryt;
        return $this;
    }
    /**
     * Get wartosc value
     * @return int
     */
    public function getWartosc()
    {
        return $this->wartosc;
    }
    /**
     * Set wartosc value
     * @param int $wartosc
     * @return PrzesylkaPobraniowaType
     */
    public function setWartosc($wartosc = null)
    {
        $this->wartosc = $wartosc;
        return $this;
    }
    /**
     * Get pobranie value
     * @return PobranieType|null
     */
    public function getPobranie()
    {
        return $this->pobranie;
    }
    /**
     * Set pobranie value
     * @param PobranieType $pobranie
     * @return PrzesylkaPobraniowaType
     */
    public function setPobranie(PobranieType $pobranie = null)
    {
        $this->pobranie = $pobranie;
        return $this;
    }
    /**
     * Get posteRestante value
     * @return bool|null
     */
    public function getPosteRestante()
    {
        return $this->posteRestante;
    }
    /**
     * Set posteRestante value
     * @param bool $posteRestante
     * @return PrzesylkaPobraniowaType
     */
    public function setPosteRestante($posteRestante = false)
    {
        $this->posteRestante = $posteRestante;
        return $this;
    }
    /**
     * Get iloscPotwierdzenOdbioru value
     * @return int|null
     */
    public function getIloscPotwierdzenOdbioru()
    {
        return $this->iloscPotwierdzenOdbioru;
    }
    /**
     * Set iloscPotwierdzenOdbioru value
     * @param int $iloscPotwierdzenOdbioru
     * @return PrzesylkaPobraniowaType
     */
    public function setIloscPotwierdzenOdbioru($iloscPotwierdzenOdbioru = 0)
    {
        $this->iloscPotwierdzenOdbioru = $iloscPotwierdzenOdbioru;
        return $this;
    }
    /**
     * Get ostroznie value
     * @return bool|null
     */
    public function getOstroznie()
    {
        return $this->ostroznie;
    }
    /**
     * Set ostroznie value
     * @param bool $ostroznie
     * @return PrzesylkaPobraniowaType
     */
    public function setOstroznie($ostroznie = false)
    {
        $this->ostroznie = $ostroznie;
        return $this;
    }
    /**
     * Get masa value
     * @return int|null
     */
    public function getMasa()
    {
        return $this->masa;
    }
    /**
     * Set masa value
     * @param int $masa
     * @return PrzesylkaPobraniowaType
     */
    public function setMasa($masa = null)
    {
        $this->masa = $masa;
        return $this;
    }
}
