<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getPrintForParcel StructType
 * @subpackage Structs
 */
class GetPrintForParcel extends AbstractStructBase
{
    /**
     * The guid
     * Meta information extracted from the WSDL
     * - documentation: parcels guids
     * - base: xsd:string
     * - length: 32
     * - maxOccurs: 500
     * - minOccurs: 1
     * - whiteSpace: collapse
     * @var string[]
     */
    public $guid;
    /**
     * The type
     * Meta information extracted from the WSDL
     * - documentation: printout type
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var PrintType
     */
    public $type;
    /**
     * Constructor method for getPrintForParcel
     * @uses GetPrintForParcel::setGuid()
     * @uses GetPrintForParcel::setType()
     * @param string[] $guid
     * @param PrintType $type
     */
    public function __construct(array $guid = array(), PrintType $type = null)
    {
        $this
            ->setGuid($guid)
            ->setType($type);
    }
    /**
     * Get guid value
     * @return string[]
     */
    public function getGuid()
    {
        return $this->guid;
    }
    /**
     * Set guid value
     * @param string[] $guid
     * @return GetPrintForParcel
     */
    public function setGuid(array $guid = array())
    {
        $this->guid = $guid;
        return $this;
    }
    /**
     * Add item to guid value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return GetPrintForParcel
     */
    public function addToGuid($item)
    {
        $this->guid[] = $item;
        return $this;
    }
    /**
     * Get type value
     * @return PrintType
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @param PrintType $type
     * @return GetPrintForParcel
     */
    public function setType(PrintType $type = null)
    {
        $this->type = $type;
        return $this;
    }
}
