<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LibraryForLegalDepositType StructType
 * @subpackage Structs
 */
class LibraryForLegalDepositType extends AbstractStructBase
{
    /**
     * The idLibraryForLegalDeposit
     * Meta information extracted from the WSDL
     * - documentation: Library ID to use for shipment data in the <idLibraryForLegalDeposit/> element
     * - base: xsd:string
     * - maxLength: 4
     * - maxOccurs: 1
     * - minLength: 4
     * - minOccurs: 1
     * @var string
     */
    public $idLibraryForLegalDeposit;
    /**
     * The libraryName
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 60
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * @var string
     */
    public $libraryName;
    /**
     * The street
     * Meta information extracted from the WSDL
     * - documentation: For a P.O. Box, this item includes a string &quot;skr. poczt.&quot; and box_number
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $street;
    /**
     * The houseNumber
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 11
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $houseNumber;
    /**
     * The apartmentNumber
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 11
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $apartmentNumber;
    /**
     * The zipCode
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $zipCode;
    /**
     * The city
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 63
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $city;
    /**
     * Constructor method for LibraryForLegalDepositType
     * @uses LibraryForLegalDepositType::setIdLibraryForLegalDeposit()
     * @uses LibraryForLegalDepositType::setLibraryName()
     * @uses LibraryForLegalDepositType::setStreet()
     * @uses LibraryForLegalDepositType::setHouseNumber()
     * @uses LibraryForLegalDepositType::setApartmentNumber()
     * @uses LibraryForLegalDepositType::setZipCode()
     * @uses LibraryForLegalDepositType::setCity()
     * @param string $idLibraryForLegalDeposit
     * @param string $libraryName
     * @param string $street
     * @param string $houseNumber
     * @param string $apartmentNumber
     * @param string $zipCode
     * @param string $city
     */
    public function __construct($idLibraryForLegalDeposit = null, $libraryName = null, $street = null, $houseNumber = null, $apartmentNumber = null, $zipCode = null, $city = null)
    {
        $this
            ->setIdLibraryForLegalDeposit($idLibraryForLegalDeposit)
            ->setLibraryName($libraryName)
            ->setStreet($street)
            ->setHouseNumber($houseNumber)
            ->setApartmentNumber($apartmentNumber)
            ->setZipCode($zipCode)
            ->setCity($city);
    }
    /**
     * Get idLibraryForLegalDeposit value
     * @return string
     */
    public function getIdLibraryForLegalDeposit()
    {
        return $this->idLibraryForLegalDeposit;
    }
    /**
     * Set idLibraryForLegalDeposit value
     * @param string $idLibraryForLegalDeposit
     * @return LibraryForLegalDepositType
     */
    public function setIdLibraryForLegalDeposit($idLibraryForLegalDeposit = null)
    {
        $this->idLibraryForLegalDeposit = $idLibraryForLegalDeposit;
        return $this;
    }
    /**
     * Get libraryName value
     * @return string
     */
    public function getLibraryName()
    {
        return $this->libraryName;
    }
    /**
     * Set libraryName value
     * @param string $libraryName
     * @return LibraryForLegalDepositType
     */
    public function setLibraryName($libraryName = null)
    {
        $this->libraryName = $libraryName;
        return $this;
    }
    /**
     * Get street value
     * @return string|null
     */
    public function getStreet()
    {
        return $this->street;
    }
    /**
     * Set street value
     * @param string $street
     * @return LibraryForLegalDepositType
     */
    public function setStreet($street = null)
    {
        $this->street = $street;
        return $this;
    }
    /**
     * Get houseNumber value
     * @return string|null
     */
    public function getHouseNumber()
    {
        return $this->houseNumber;
    }
    /**
     * Set houseNumber value
     * @param string $houseNumber
     * @return LibraryForLegalDepositType
     */
    public function setHouseNumber($houseNumber = null)
    {
        $this->houseNumber = $houseNumber;
        return $this;
    }
    /**
     * Get apartmentNumber value
     * @return string|null
     */
    public function getApartmentNumber()
    {
        return $this->apartmentNumber;
    }
    /**
     * Set apartmentNumber value
     * @param string $apartmentNumber
     * @return LibraryForLegalDepositType
     */
    public function setApartmentNumber($apartmentNumber = null)
    {
        $this->apartmentNumber = $apartmentNumber;
        return $this;
    }
    /**
     * Get zipCode value
     * @return string|null
     */
    public function getZipCode()
    {
        return $this->zipCode;
    }
    /**
     * Set zipCode value
     * @param string $zipCode
     * @return LibraryForLegalDepositType
     */
    public function setZipCode($zipCode = null)
    {
        $this->zipCode = $zipCode;
        return $this;
    }
    /**
     * Get city value
     * @return string|null
     */
    public function getCity()
    {
        return $this->city;
    }
    /**
     * Set city value
     * @param string $city
     * @return LibraryForLegalDepositType
     */
    public function setCity($city = null)
    {
        $this->city = $city;
        return $this;
    }
}
