<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getAccountListResponse StructType
 * @subpackage Structs
 */
class GetAccountListResponse extends AbstractStructBase
{
    /**
     * The account
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var AccountType[]
     */
    public $account;
    /**
     * Constructor method for getAccountListResponse
     * @uses GetAccountListResponse::setAccount()
     * @param AccountType[] $account
     */
    public function __construct(array $account = array())
    {
        $this
            ->setAccount($account);
    }
    /**
     * Get account value
     * @return AccountType[]|null
     */
    public function getAccount()
    {
        return $this->account;
    }
    /**
     * Set account value
     * @param AccountType[] $account
     * @return GetAccountListResponse
     */
    public function setAccount(array $account = array())
    {
        $this->account = $account;
        return $this;
    }
    /**
     * Add item to account value
     * @throws \InvalidArgumentException
     * @param AccountType $item
     * @return GetAccountListResponse
     */
    public function addToAccount(AccountType $item)
    {
        $this->account[] = $item;
        return $this;
    }
}
