<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for adresType StructType
 * @subpackage Structs
 */
class AdresType extends AbstractStructBase
{
    /**
     * The nazwa
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 60
     * - minLength: 1
     * - whiteSpace: collapse
     * @var string
     */
    public $nazwa;
    /**
     * The nazwa2
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 60
     * - minLength: 0
     * - whiteSpace: collapse
     * @var string
     */
    public $nazwa2;
    /**
     * The ulica
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - minLength: 1
     * - whiteSpace: collapse
     * @var string
     */
    public $ulica;
    /**
     * The numerDomu
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 11
     * - minLength: 0
     * - whiteSpace: collapse
     * @var string
     */
    public $numerDomu;
    /**
     * The numerLokalu
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 11
     * - minLength: 0
     * - whiteSpace: collapse
     * @var string
     */
    public $numerLokalu;
    /**
     * The miejscowosc
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 63
     * - minLength: 1
     * - whiteSpace: collapse
     * @var string
     */
    public $miejscowosc;
    /**
     * The kodPocztowy
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 10
     * - minLength: 0
     * - whiteSpace: collapse
     * @var string
     */
    public $kodPocztowy;
    /**
     * The kraj
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: Polska
     * - maxLength: 40
     * - minLength: 0
     * - use: optional
     * @var string
     */
    public $kraj;
    /**
     * The telefon
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 20
     * - minLength: 0
     * @var string
     */
    public $telefon;
    /**
     * The email
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - minLength: 6
     * @var string
     */
    public $email;
    /**
     * The mobile
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * @var string
     */
    public $mobile;
    /**
     * The osobaKontaktowa
     * @var string
     */
    public $osobaKontaktowa;
    /**
     * The nip
     * @var string
     */
    public $nip;
    /**
     * Constructor method for adresType
     * @uses AdresType::setNazwa()
     * @uses AdresType::setNazwa2()
     * @uses AdresType::setUlica()
     * @uses AdresType::setNumerDomu()
     * @uses AdresType::setNumerLokalu()
     * @uses AdresType::setMiejscowosc()
     * @uses AdresType::setKodPocztowy()
     * @uses AdresType::setKraj()
     * @uses AdresType::setTelefon()
     * @uses AdresType::setEmail()
     * @uses AdresType::setMobile()
     * @uses AdresType::setOsobaKontaktowa()
     * @uses AdresType::setNip()
     * @param string $nazwa
     * @param string $nazwa2
     * @param string $ulica
     * @param string $numerDomu
     * @param string $numerLokalu
     * @param string $miejscowosc
     * @param string $kodPocztowy
     * @param string $kraj
     * @param string $telefon
     * @param string $email
     * @param string $mobile
     * @param string $osobaKontaktowa
     * @param string $nip
     */
    public function __construct($nazwa = null, $nazwa2 = null, $ulica = null, $numerDomu = null, $numerLokalu = null, $miejscowosc = null, $kodPocztowy = null, $kraj = 'Polska', $telefon = null, $email = null, $mobile = null, $osobaKontaktowa = null, $nip = null)
    {
        $this
            ->setNazwa($nazwa)
            ->setNazwa2($nazwa2)
            ->setUlica($ulica)
            ->setNumerDomu($numerDomu)
            ->setNumerLokalu($numerLokalu)
            ->setMiejscowosc($miejscowosc)
            ->setKodPocztowy($kodPocztowy)
            ->setKraj($kraj)
            ->setTelefon($telefon)
            ->setEmail($email)
            ->setMobile($mobile)
            ->setOsobaKontaktowa($osobaKontaktowa)
            ->setNip($nip);
    }
    /**
     * Get nazwa value
     * @return string|null
     */
    public function getNazwa()
    {
        return $this->nazwa;
    }
    /**
     * Set nazwa value
     * @param string $nazwa
     * @return AdresType
     */
    public function setNazwa($nazwa = null)
    {
        $this->nazwa = $nazwa;
        return $this;
    }
    /**
     * Get nazwa2 value
     * @return string|null
     */
    public function getNazwa2()
    {
        return $this->nazwa2;
    }
    /**
     * Set nazwa2 value
     * @param string $nazwa2
     * @return AdresType
     */
    public function setNazwa2($nazwa2 = null)
    {
        $this->nazwa2 = $nazwa2;
        return $this;
    }
    /**
     * Get ulica value
     * @return string|null
     */
    public function getUlica()
    {
        return $this->ulica;
    }
    /**
     * Set ulica value
     * @param string $ulica
     * @return AdresType
     */
    public function setUlica($ulica = null)
    {
        $this->ulica = $ulica;
        return $this;
    }
    /**
     * Get numerDomu value
     * @return string|null
     */
    public function getNumerDomu()
    {
        return $this->numerDomu;
    }
    /**
     * Set numerDomu value
     * @param string $numerDomu
     * @return AdresType
     */
    public function setNumerDomu($numerDomu = null)
    {
        $this->numerDomu = $numerDomu;
        return $this;
    }
    /**
     * Get numerLokalu value
     * @return string|null
     */
    public function getNumerLokalu()
    {
        return $this->numerLokalu;
    }
    /**
     * Set numerLokalu value
     * @param string $numerLokalu
     * @return AdresType
     */
    public function setNumerLokalu($numerLokalu = null)
    {
        $this->numerLokalu = $numerLokalu;
        return $this;
    }
    /**
     * Get miejscowosc value
     * @return string|null
     */
    public function getMiejscowosc()
    {
        return $this->miejscowosc;
    }
    /**
     * Set miejscowosc value
     * @param string $miejscowosc
     * @return AdresType
     */
    public function setMiejscowosc($miejscowosc = null)
    {
        $this->miejscowosc = $miejscowosc;
        return $this;
    }
    /**
     * Get kodPocztowy value
     * @return string|null
     */
    public function getKodPocztowy()
    {
        return $this->kodPocztowy;
    }
    /**
     * Set kodPocztowy value
     * @param string $kodPocztowy
     * @return AdresType
     */
    public function setKodPocztowy($kodPocztowy = null)
    {
        $this->kodPocztowy = $kodPocztowy;
        return $this;
    }
    /**
     * Get kraj value
     * @return string|null
     */
    public function getKraj()
    {
        return $this->kraj;
    }
    /**
     * Set kraj value
     * @param string $kraj
     * @return AdresType
     */
    public function setKraj($kraj = 'Polska')
    {
        $this->kraj = $kraj;
        return $this;
    }
    /**
     * Get telefon value
     * @return string|null
     */
    public function getTelefon()
    {
        return $this->telefon;
    }
    /**
     * Set telefon value
     * @param string $telefon
     * @return AdresType
     */
    public function setTelefon($telefon = null)
    {
        $this->telefon = $telefon;
        return $this;
    }
    /**
     * Get email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->email;
    }
    /**
     * Set email value
     * @param string $email
     * @return AdresType
     */
    public function setEmail($email = null)
    {
        $this->email = $email;
        return $this;
    }
    /**
     * Get mobile value
     * @return string|null
     */
    public function getMobile()
    {
        return $this->mobile;
    }
    /**
     * Set mobile value
     * @param string $mobile
     * @return AdresType
     */
    public function setMobile($mobile = null)
    {
        $this->mobile = $mobile;
        return $this;
    }
    /**
     * Get osobaKontaktowa value
     * @return string|null
     */
    public function getOsobaKontaktowa()
    {
        return $this->osobaKontaktowa;
    }
    /**
     * Set osobaKontaktowa value
     * @param string $osobaKontaktowa
     * @return AdresType
     */
    public function setOsobaKontaktowa($osobaKontaktowa = null)
    {
        $this->osobaKontaktowa = $osobaKontaktowa;
        return $this;
    }
    /**
     * Get nip value
     * @return string|null
     */
    public function getNip()
    {
        return $this->nip;
    }
    /**
     * Set nip value
     * @param string $nip
     * @return AdresType
     */
    public function setNip($nip = null)
    {
        $this->nip = $nip;
        return $this;
    }
}
