<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomsDeclarationType StructType
 * Meta information extracted from the WSDL
 * - maxOccurs: 1
 * - minOccurs: 0
 * - type: xsd:string
 * @subpackage Structs
 */
class CustomsDeclarationType extends AbstractStructBase
{
    /**
     * The content
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $content;
    /**
     * The currencyCode
     * Meta information extracted from the WSDL
     * - documentation: Code (ISO 4217) of the currency in which the values of the items specified in the shipmentContentsDetails element are expressed. example: EUR
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $currencyCode;
    /**
     * The shipmentContentsDetails
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var ShipmentContentsDetailsType[]
     */
    public $shipmentContentsDetails;
    /**
     * The type
     * Meta information extracted from the WSDL
     * - documentation: CN type.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $type;
    /**
     * The accompanyingDocuments
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var AccompanyingDocumentsType[]
     */
    public $accompanyingDocuments;
    /**
     * The explanation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $explanation;
    /**
     * The postalCharges
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $postalCharges;
    /**
     * The comments
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $comments;
    /**
     * The importerReferenceNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $importerReferenceNumber;
    /**
     * The importerPhoneNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $importerPhoneNumber;
    /**
     * The customsReferenceNumber
     * @var string
     */
    public $customsReferenceNumber;
    /**
     * Constructor method for CustomsDeclarationType
     * @uses CustomsDeclarationType::setContent()
     * @uses CustomsDeclarationType::setCurrencyCode()
     * @uses CustomsDeclarationType::setShipmentContentsDetails()
     * @uses CustomsDeclarationType::setType()
     * @uses CustomsDeclarationType::setAccompanyingDocuments()
     * @uses CustomsDeclarationType::setExplanation()
     * @uses CustomsDeclarationType::setPostalCharges()
     * @uses CustomsDeclarationType::setComments()
     * @uses CustomsDeclarationType::setImporterReferenceNumber()
     * @uses CustomsDeclarationType::setImporterPhoneNumber()
     * @uses CustomsDeclarationType::setCustomsReferenceNumber()
     * @param string $content
     * @param string $currencyCode
     * @param ShipmentContentsDetailsType[] $shipmentContentsDetails
     * @param string $type
     * @param AccompanyingDocumentsType[] $accompanyingDocuments
     * @param string $explanation
     * @param string $postalCharges
     * @param string $comments
     * @param string $importerReferenceNumber
     * @param string $importerPhoneNumber
     * @param string $customsReferenceNumber
     */
    public function __construct($content = null, $currencyCode = null, array $shipmentContentsDetails = array(), $type = null, array $accompanyingDocuments = array(), $explanation = null, $postalCharges = null, $comments = null, $importerReferenceNumber = null, $importerPhoneNumber = null, $customsReferenceNumber = null)
    {
        $this
            ->setContent($content)
            ->setCurrencyCode($currencyCode)
            ->setShipmentContentsDetails($shipmentContentsDetails)
            ->setType($type)
            ->setAccompanyingDocuments($accompanyingDocuments)
            ->setExplanation($explanation)
            ->setPostalCharges($postalCharges)
            ->setComments($comments)
            ->setImporterReferenceNumber($importerReferenceNumber)
            ->setImporterPhoneNumber($importerPhoneNumber)
            ->setCustomsReferenceNumber($customsReferenceNumber);
    }
    /**
     * Get content value
     * @return string
     */
    public function getContent()
    {
        return $this->content;
    }
    /**
     * Set content value
     * @param string $content
     * @return CustomsDeclarationType
     */
    public function setContent($content = null)
    {
        $this->content = $content;
        return $this;
    }
    /**
     * Get currencyCode value
     * @return string
     */
    public function getCurrencyCode()
    {
        return $this->currencyCode;
    }
    /**
     * Set currencyCode value
     * @param string $currencyCode
     * @return CustomsDeclarationType
     */
    public function setCurrencyCode($currencyCode = null)
    {
        $this->currencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get shipmentContentsDetails value
     * @return ShipmentContentsDetailsType[]
     */
    public function getShipmentContentsDetails()
    {
        return $this->shipmentContentsDetails;
    }
    /**
     * Set shipmentContentsDetails value
     * @param ShipmentContentsDetailsType[] $shipmentContentsDetails
     * @return CustomsDeclarationType
     */
    public function setShipmentContentsDetails(array $shipmentContentsDetails = array())
    {
        $this->shipmentContentsDetails = $shipmentContentsDetails;
        return $this;
    }
    /**
     * Add item to shipmentContentsDetails value
     * @throws \InvalidArgumentException
     * @param ShipmentContentsDetailsType $item
     * @return CustomsDeclarationType
     */
    public function addToShipmentContentsDetails(ShipmentContentsDetailsType $item)
    {
        $this->shipmentContentsDetails[] = $item;
        return $this;
    }
    /**
     * Get type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @param string $type
     * @return CustomsDeclarationType
     */
    public function setType($type = null)
    {
        $this->type = $type;
        return $this;
    }
    /**
     * Get accompanyingDocuments value
     * @return AccompanyingDocumentsType[]|null
     */
    public function getAccompanyingDocuments()
    {
        return $this->accompanyingDocuments;
    }
    /**
     * Set accompanyingDocuments value
     * @param AccompanyingDocumentsType[] $accompanyingDocuments
     * @return CustomsDeclarationType
     */
    public function setAccompanyingDocuments(array $accompanyingDocuments = array())
    {
        $this->accompanyingDocuments = $accompanyingDocuments;
        return $this;
    }
    /**
     * Add item to accompanyingDocuments value
     * @throws \InvalidArgumentException
     * @param AccompanyingDocumentsType $item
     * @return CustomsDeclarationType
     */
    public function addToAccompanyingDocuments(AccompanyingDocumentsType $item)
    {
        $this->accompanyingDocuments[] = $item;
        return $this;
    }
    /**
     * Get explanation value
     * @return string|null
     */
    public function getExplanation()
    {
        return $this->explanation;
    }
    /**
     * Set explanation value
     * @param string $explanation
     * @return CustomsDeclarationType
     */
    public function setExplanation($explanation = null)
    {
        $this->explanation = $explanation;
        return $this;
    }
    /**
     * Get postalCharges value
     * @return string|null
     */
    public function getPostalCharges()
    {
        return $this->postalCharges;
    }
    /**
     * Set postalCharges value
     * @param string $postalCharges
     * @return CustomsDeclarationType
     */
    public function setPostalCharges($postalCharges = null)
    {
        $this->postalCharges = $postalCharges;
        return $this;
    }
    /**
     * Get comments value
     * @return string|null
     */
    public function getComments()
    {
        return $this->comments;
    }
    /**
     * Set comments value
     * @param string $comments
     * @return CustomsDeclarationType
     */
    public function setComments($comments = null)
    {
        $this->comments = $comments;
        return $this;
    }
    /**
     * Get importerReferenceNumber value
     * @return string|null
     */
    public function getImporterReferenceNumber()
    {
        return $this->importerReferenceNumber;
    }
    /**
     * Set importerReferenceNumber value
     * @param string $importerReferenceNumber
     * @return CustomsDeclarationType
     */
    public function setImporterReferenceNumber($importerReferenceNumber = null)
    {
        $this->importerReferenceNumber = $importerReferenceNumber;
        return $this;
    }
    /**
     * Get importerPhoneNumber value
     * @return string|null
     */
    public function getImporterPhoneNumber()
    {
        return $this->importerPhoneNumber;
    }
    /**
     * Set importerPhoneNumber value
     * @param string $importerPhoneNumber
     * @return CustomsDeclarationType
     */
    public function setImporterPhoneNumber($importerPhoneNumber = null)
    {
        $this->importerPhoneNumber = $importerPhoneNumber;
        return $this;
    }
    /**
     * Get customsReferenceNumber value
     * @return string|null
     */
    public function getCustomsReferenceNumber()
    {
        return $this->customsReferenceNumber;
    }
    /**
     * Set customsReferenceNumber value
     * @param string $customsReferenceNumber
     * @return CustomsDeclarationType
     */
    public function setCustomsReferenceNumber($customsReferenceNumber = null)
    {
        $this->customsReferenceNumber = $customsReferenceNumber;
        return $this;
    }
}
