<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for jednostkaOrganizacyjnaType StructType
 * @subpackage Structs
 */
class JednostkaOrganizacyjnaType extends AbstractStructBase
{
    /**
     * The account
     * Meta information extracted from the WSDL
     * - documentation: Wystarczy przesłać obiekt z ustawionym id reszta pól może zostać pominięta (aby zmniejszyć ilośc danych do transmisji)
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var AccountType[]
     */
    public $account;
    /**
     * The jednostkaNadrzedna
     * Meta information extracted from the WSDL
     * - documentation: Wystarczy przesłać obiekt z ustawionym id reszta pól może zostać pominięta (aby zmniejszyć ilośc danych do transmisji)
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var JednostkaOrganizacyjnaType
     */
    public $jednostkaNadrzedna;
    /**
     * The rodzajPrzypisania
     * Meta information extracted from the WSDL
     * - maxOccurs: 2
     * - minOccurs: 0
     * @var string[]
     */
    public $rodzajPrzypisania;
    /**
     * The id
     * @var int
     */
    public $id;
    /**
     * The nazwa
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - minLength: 1
     * @var string
     */
    public $nazwa;
    /**
     * The opis
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 4000
     * - minLength: 0
     * @var string
     */
    public $opis;
    /**
     * The mpk
     * @var string
     */
    public $mpk;
    /**
     * Constructor method for jednostkaOrganizacyjnaType
     * @uses JednostkaOrganizacyjnaType::setAccount()
     * @uses JednostkaOrganizacyjnaType::setJednostkaNadrzedna()
     * @uses JednostkaOrganizacyjnaType::setRodzajPrzypisania()
     * @uses JednostkaOrganizacyjnaType::setId()
     * @uses JednostkaOrganizacyjnaType::setNazwa()
     * @uses JednostkaOrganizacyjnaType::setOpis()
     * @uses JednostkaOrganizacyjnaType::setMpk()
     * @param AccountType[] $account
     * @param JednostkaOrganizacyjnaType $jednostkaNadrzedna
     * @param string[] $rodzajPrzypisania
     * @param int $id
     * @param string $nazwa
     * @param string $opis
     * @param string $mpk
     */
    public function __construct(array $account = array(), JednostkaOrganizacyjnaType $jednostkaNadrzedna = null, array $rodzajPrzypisania = array(), $id = null, $nazwa = null, $opis = null, $mpk = null)
    {
        $this
            ->setAccount($account)
            ->setJednostkaNadrzedna($jednostkaNadrzedna)
            ->setRodzajPrzypisania($rodzajPrzypisania)
            ->setId($id)
            ->setNazwa($nazwa)
            ->setOpis($opis)
            ->setMpk($mpk);
    }
    /**
     * Get account value
     * @return AccountType[]|null
     */
    public function getAccount()
    {
        return $this->account;
    }
    /**
     * Set account value
     * @param AccountType[] $account
     * @return JednostkaOrganizacyjnaType
     */
    public function setAccount(array $account = array())
    {
        $this->account = $account;
        return $this;
    }
    /**
     * Add item to account value
     * @throws \InvalidArgumentException
     * @param AccountType $item
     * @return JednostkaOrganizacyjnaType
     */
    public function addToAccount(AccountType $item)
    {
        $this->account[] = $item;
        return $this;
    }
    /**
     * Get jednostkaNadrzedna value
     * @return JednostkaOrganizacyjnaType|null
     */
    public function getJednostkaNadrzedna()
    {
        return $this->jednostkaNadrzedna;
    }
    /**
     * Set jednostkaNadrzedna value
     * @param JednostkaOrganizacyjnaType $jednostkaNadrzedna
     * @return JednostkaOrganizacyjnaType
     */
    public function setJednostkaNadrzedna(JednostkaOrganizacyjnaType $jednostkaNadrzedna = null)
    {
        $this->jednostkaNadrzedna = $jednostkaNadrzedna;
        return $this;
    }
    /**
     * Get rodzajPrzypisania value
     * @return string[]|null
     */
    public function getRodzajPrzypisania()
    {
        return $this->rodzajPrzypisania;
    }
    /**
     * Set rodzajPrzypisania value
     * @param string[] $rodzajPrzypisania
     * @return JednostkaOrganizacyjnaType
     */
    public function setRodzajPrzypisania(array $rodzajPrzypisania = array())
    {
        $this->rodzajPrzypisania = $rodzajPrzypisania;
        return $this;
    }
    /**
     * Add item to rodzajPrzypisania value
     * @uses RodzajPrzypisaniaDoJednostkiEnum::valueIsValid()
     * @uses RodzajPrzypisaniaDoJednostkiEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return JednostkaOrganizacyjnaType
     */
    public function addToRodzajPrzypisania($item)
    {
        $this->rodzajPrzypisania[] = $item;
        return $this;
    }
    /**
     * Get id value
     * @return int|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param int $id
     * @return JednostkaOrganizacyjnaType
     */
    public function setId($id = null)
    {
        $this->id = $id;
        return $this;
    }
    /**
     * Get nazwa value
     * @return string|null
     */
    public function getNazwa()
    {
        return $this->nazwa;
    }
    /**
     * Set nazwa value
     * @param string $nazwa
     * @return JednostkaOrganizacyjnaType
     */
    public function setNazwa($nazwa = null)
    {
        $this->nazwa = $nazwa;
        return $this;
    }
    /**
     * Get opis value
     * @return string|null
     */
    public function getOpis()
    {
        return $this->opis;
    }
    /**
     * Set opis value
     * @param string $opis
     * @return JednostkaOrganizacyjnaType
     */
    public function setOpis($opis = null)
    {
        $this->opis = $opis;
        return $this;
    }
    /**
     * Get mpk value
     * @return string|null
     */
    public function getMpk()
    {
        return $this->mpk;
    }
    /**
     * Set mpk value
     * @param string $mpk
     * @return JednostkaOrganizacyjnaType
     */
    public function setMpk($mpk = null)
    {
        $this->mpk = $mpk;
        return $this;
    }
}
