<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://securedwebapp.com/api/service.asmx?WSDL',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://securedwebapp.com/api/service.asmx?WSDL',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Update ServiceType
 */
$update = new \ServiceType\Update($options);
/**
 * Sample call for UpdateCustomer operation/method
 */
if ($update->UpdateCustomer(new \StructType\UpdateCustomer()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateSupplier operation/method
 */
if ($update->UpdateSupplier(new \StructType\UpdateSupplier()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateBankTransaction operation/method
 */
if ($update->UpdateBankTransaction(new \StructType\UpdateBankTransaction()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateJournal operation/method
 */
if ($update->UpdateJournal(new \StructType\UpdateJournal()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateJournalHeader operation/method
 */
if ($update->UpdateJournalHeader(new \StructType\UpdateJournalHeader()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateQuote operation/method
 */
if ($update->UpdateQuote(new \StructType\UpdateQuote()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateQuoteHeader operation/method
 */
if ($update->UpdateQuoteHeader(new \StructType\UpdateQuoteHeader()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateInvoice operation/method
 */
if ($update->UpdateInvoice(new \StructType\UpdateInvoice()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateInvoice_TypeDefined operation/method
 */
if ($update->UpdateInvoice_TypeDefined(new \StructType\UpdateInvoice_TypeDefined()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateInvoiceHeader operation/method
 */
if ($update->UpdateInvoiceHeader(new \StructType\UpdateInvoiceHeader()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateReceipt_TypeDefined operation/method
 */
if ($update->UpdateReceipt_TypeDefined(new \StructType\UpdateReceipt_TypeDefined()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateReceipt operation/method
 */
if ($update->UpdateReceipt(new \StructType\UpdateReceipt()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateReceiptHeader operation/method
 */
if ($update->UpdateReceiptHeader(new \StructType\UpdateReceiptHeader()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Samples for Search ServiceType
 */
$search = new \ServiceType\Search($options);
/**
 * Sample call for SearchCustomerByCustText operation/method
 */
if ($search->SearchCustomerByCustText(new \StructType\SearchCustomerByCustText()) !== false) {
    print_r($search->getResult());
} else {
    print_r($search->getLastError());
}
/**
 * Samples for Set ServiceType
 */
$set = new \ServiceType\Set($options);
/**
 * Sample call for SetCustomerVATNumber operation/method
 */
if ($set->SetCustomerVATNumber(new \StructType\SetCustomerVATNumber()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for SetCustomerCurrency operation/method
 */
if ($set->SetCustomerCurrency(new \StructType\SetCustomerCurrency()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for SetSupplierVATNumber operation/method
 */
if ($set->SetSupplierVATNumber(new \StructType\SetSupplierVATNumber()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for SetSupplierCurrency operation/method
 */
if ($set->SetSupplierCurrency(new \StructType\SetSupplierCurrency()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Samples for Get ServiceType
 */
$get = new \ServiceType\Get($options);
/**
 * Sample call for GetCustomerCurrency operation/method
 */
if ($get->GetCustomerCurrency(new \StructType\GetCustomerCurrency()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCustomerSources operation/method
 */
if ($get->GetCustomerSources(new \StructType\GetCustomerSources()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCustomersByPostcode operation/method
 */
if ($get->GetCustomersByPostcode(new \StructType\GetCustomersByPostcode()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCustomerBalance operation/method
 */
if ($get->GetCustomerBalance(new \StructType\GetCustomerBalance()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCustomerAdvancePayments operation/method
 */
if ($get->GetCustomerAdvancePayments(new \StructType\GetCustomerAdvancePayments()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetProjects_Full operation/method
 */
if ($get->GetProjects_Full(new \StructType\GetProjects_Full()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetProjects operation/method
 */
if ($get->GetProjects(new \StructType\GetProjects()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetProjectById operation/method
 */
if ($get->GetProjectById(new \StructType\GetProjectById()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetProjectByRef operation/method
 */
if ($get->GetProjectByRef(new \StructType\GetProjectByRef()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetProjectByName operation/method
 */
if ($get->GetProjectByName(new \StructType\GetProjectByName()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetSupplierVATNumber operation/method
 */
if ($get->GetSupplierVATNumber(new \StructType\GetSupplierVATNumber()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetSupplier operation/method
 */
if ($get->GetSupplier(new \StructType\GetSupplier()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetSuppliers operation/method
 */
if ($get->GetSuppliers(new \StructType\GetSuppliers()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetSupplierCurrency operation/method
 */
if ($get->GetSupplierCurrency(new \StructType\GetSupplierCurrency()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetSupplierByID operation/method
 */
if ($get->GetSupplierByID(new \StructType\GetSupplierByID()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetBankBalance operation/method
 */
if ($get->GetBankBalance(new \StructType\GetBankBalance()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetBankAccounts operation/method
 */
if ($get->GetBankAccounts(new \StructType\GetBankAccounts()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetBankTxTypes operation/method
 */
if ($get->GetBankTxTypes(new \StructType\GetBankTxTypes()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetBankTransactions operation/method
 */
if ($get->GetBankTransactions(new \StructType\GetBankTransactions()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetBalanceSheet operation/method
 */
if ($get->GetBalanceSheet(new \StructType\GetBalanceSheet()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetProfitAndLoss operation/method
 */
if ($get->GetProfitAndLoss(new \StructType\GetProfitAndLoss()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetMonthlyProfitAndLoss operation/method
 */
if ($get->GetMonthlyProfitAndLoss(new \StructType\GetMonthlyProfitAndLoss()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetTrialBalance operation/method
 */
if ($get->GetTrialBalance(new \StructType\GetTrialBalance()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetTrialBalanceWithOpeningBalances operation/method
 */
if ($get->GetTrialBalanceWithOpeningBalances(new \StructType\GetTrialBalanceWithOpeningBalances()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetVATReport operation/method
 */
if ($get->GetVATReport(new \StructType\GetVATReport()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetDigitaCSVFile operation/method
 */
if ($get->GetDigitaCSVFile(new \StructType\GetDigitaCSVFile()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetNominalLedger operation/method
 */
if ($get->GetNominalLedger(new \StructType\GetNominalLedger()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAgedDebtors operation/method
 */
if ($get->GetAgedDebtors(new \StructType\GetAgedDebtors()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAgedCreditors operation/method
 */
if ($get->GetAgedCreditors(new \StructType\GetAgedCreditors()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetIncomeByCustomer operation/method
 */
if ($get->GetIncomeByCustomer(new \StructType\GetIncomeByCustomer()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetJournals operation/method
 */
if ($get->GetJournals(new \StructType\GetJournals()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetJournal operation/method
 */
if ($get->GetJournal(new \StructType\GetJournal()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetBankOverview operation/method
 */
if ($get->GetBankOverview(new \StructType\GetBankOverview()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAccountOverview operation/method
 */
if ($get->GetAccountOverview(new \StructType\GetAccountOverview()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCurrencies operation/method
 */
if ($get->GetCurrencies(new \StructType\GetCurrencies()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetUserAccountDefaults operation/method
 */
if ($get->GetUserAccountDefaults(new \StructType\GetUserAccountDefaults()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetUserAccountDefaults_TypeDefined operation/method
 */
if ($get->GetUserAccountDefaults_TypeDefined(new \StructType\GetUserAccountDefaults_TypeDefined()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetReceiptAttachments operation/method
 */
if ($get->GetReceiptAttachments(new \StructType\GetReceiptAttachments()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetRemoteLoginURL operation/method
 */
if ($get->GetRemoteLoginURL(new \StructType\GetRemoteLoginURL()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetProducts operation/method
 */
if ($get->GetProducts(new \StructType\GetProducts()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetSubProducts operation/method
 */
if ($get->GetSubProducts(new \StructType\GetSubProducts()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetSubProductByID operation/method
 */
if ($get->GetSubProductByID(new \StructType\GetSubProductByID()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetSubProductByCode operation/method
 */
if ($get->GetSubProductByCode(new \StructType\GetSubProductByCode()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetProductsWithSubProducts operation/method
 */
if ($get->GetProductsWithSubProducts(new \StructType\GetProductsWithSubProducts()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetNominalCodes operation/method
 */
if ($get->GetNominalCodes(new \StructType\GetNominalCodes()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetNominalCodesExtended operation/method
 */
if ($get->GetNominalCodesExtended(new \StructType\GetNominalCodesExtended()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetKPIs operation/method
 */
if ($get->GetKPIs(new \StructType\GetKPIs()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetVATRates operation/method
 */
if ($get->GetVATRates(new \StructType\GetVATRates()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCompanyDetails operation/method
 */
if ($get->GetCompanyDetails(new \StructType\GetCompanyDetails()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetQuoteByID operation/method
 */
if ($get->GetQuoteByID(new \StructType\GetQuoteByID()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetQuoteByNumber operation/method
 */
if ($get->GetQuoteByNumber(new \StructType\GetQuoteByNumber()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetQuotes_Recent operation/method
 */
if ($get->GetQuotes_Recent(new \StructType\GetQuotes_Recent()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetQuotes operation/method
 */
if ($get->GetQuotes(new \StructType\GetQuotes()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetQuotesForCustomer operation/method
 */
if ($get->GetQuotesForCustomer(new \StructType\GetQuotesForCustomer()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetInvoiceByID operation/method
 */
if ($get->GetInvoiceByID(new \StructType\GetInvoiceByID()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetInvoice operation/method
 */
if ($get->GetInvoice(new \StructType\GetInvoice()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetInvoice_TypeDefined operation/method
 */
if ($get->GetInvoice_TypeDefined(new \StructType\GetInvoice_TypeDefined()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetInvoicesByDateRange operation/method
 */
if ($get->GetInvoicesByDateRange(new \StructType\GetInvoicesByDateRange()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetInvoicesForCustomer operation/method
 */
if ($get->GetInvoicesForCustomer(new \StructType\GetInvoicesForCustomer()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetInvoices_Unpaid operation/method
 */
if ($get->GetInvoices_Unpaid(new \StructType\GetInvoices_Unpaid()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetInvoices_Unpaid_TypeDefined operation/method
 */
if ($get->GetInvoices_Unpaid_TypeDefined(new \StructType\GetInvoices_Unpaid_TypeDefined()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetInvoices_Overdue operation/method
 */
if ($get->GetInvoices_Overdue(new \StructType\GetInvoices_Overdue()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetInvoices_Overdue_TypeDefined operation/method
 */
if ($get->GetInvoices_Overdue_TypeDefined(new \StructType\GetInvoices_Overdue_TypeDefined()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetInvoices_Recent operation/method
 */
if ($get->GetInvoices_Recent(new \StructType\GetInvoices_Recent()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetInvoices_Recent_TypeDefined operation/method
 */
if ($get->GetInvoices_Recent_TypeDefined(new \StructType\GetInvoices_Recent_TypeDefined()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetInvoicesForCustomer_typeDefined operation/method
 */
if ($get->GetInvoicesForCustomer_typeDefined(new \StructType\GetInvoicesForCustomer_typeDefined()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetInvoicePayment operation/method
 */
if ($get->GetInvoicePayment(new \StructType\GetInvoicePayment()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetInvPayMethods operation/method
 */
if ($get->GetInvPayMethods(new \StructType\GetInvPayMethods()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetPaypalLink operation/method
 */
if ($get->GetPaypalLink(new \StructType\GetPaypalLink()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetInvoiceNotes operation/method
 */
if ($get->GetInvoiceNotes(new \StructType\GetInvoiceNotes()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetInvoicePaymentsCountforDateRange operation/method
 */
if ($get->GetInvoicePaymentsCountforDateRange(new \StructType\GetInvoicePaymentsCountforDateRange()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetInvoicePaymentsByDateRange operation/method
 */
if ($get->GetInvoicePaymentsByDateRange(new \StructType\GetInvoicePaymentsByDateRange()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetReceipt_TypeDefined operation/method
 */
if ($get->GetReceipt_TypeDefined(new \StructType\GetReceipt_TypeDefined()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetReceipt operation/method
 */
if ($get->GetReceipt(new \StructType\GetReceipt()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetReceipts_Recent operation/method
 */
if ($get->GetReceipts_Recent(new \StructType\GetReceipts_Recent()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetReceipts operation/method
 */
if ($get->GetReceipts(new \StructType\GetReceipts()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetReceiptsWithPaging operation/method
 */
if ($get->GetReceiptsWithPaging(new \StructType\GetReceiptsWithPaging()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetReceiptsForSupplier operation/method
 */
if ($get->GetReceiptsForSupplier(new \StructType\GetReceiptsForSupplier()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetReceiptPayment operation/method
 */
if ($get->GetReceiptPayment(new \StructType\GetReceiptPayment()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetRecPayMethods operation/method
 */
if ($get->GetRecPayMethods(new \StructType\GetRecPayMethods()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetReceiptNotes operation/method
 */
if ($get->GetReceiptNotes(new \StructType\GetReceiptNotes()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCustomerVATNumber operation/method
 */
if ($get->GetCustomerVATNumber(new \StructType\GetCustomerVATNumber()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCustomer operation/method
 */
if ($get->GetCustomer(new \StructType\GetCustomer()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCustomerByID operation/method
 */
if ($get->GetCustomerByID(new \StructType\GetCustomerByID()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCustomerByEmail operation/method
 */
if ($get->GetCustomerByEmail(new \StructType\GetCustomerByEmail()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCustomersModifiedSince operation/method
 */
if ($get->GetCustomersModifiedSince(new \StructType\GetCustomersModifiedSince()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCustomers operation/method
 */
if ($get->GetCustomers(new \StructType\GetCustomers()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Delete ServiceType
 */
$delete = new \ServiceType\Delete($options);
/**
 * Sample call for DeleteCustomer operation/method
 */
if ($delete->DeleteCustomer(new \StructType\DeleteCustomer()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for DeleteSupplier operation/method
 */
if ($delete->DeleteSupplier(new \StructType\DeleteSupplier()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for DeleteBankTransaction operation/method
 */
if ($delete->DeleteBankTransaction(new \StructType\DeleteBankTransaction()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for DeleteJournal operation/method
 */
if ($delete->DeleteJournal(new \StructType\DeleteJournal()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for DeleteJournalByID operation/method
 */
if ($delete->DeleteJournalByID(new \StructType\DeleteJournalByID()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for DeleteReceiptAttachment operation/method
 */
if ($delete->DeleteReceiptAttachment(new \StructType\DeleteReceiptAttachment()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for DeleteQuote operation/method
 */
if ($delete->DeleteQuote(new \StructType\DeleteQuote()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for DeleteQuoteByID operation/method
 */
if ($delete->DeleteQuoteByID(new \StructType\DeleteQuoteByID()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for DeleteQuoteLineWithQuoteID operation/method
 */
if ($delete->DeleteQuoteLineWithQuoteID(new \StructType\DeleteQuoteLineWithQuoteID()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for DeleteQuoteLine operation/method
 */
if ($delete->DeleteQuoteLine(new \StructType\DeleteQuoteLine()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for DeleteInvoicePayment operation/method
 */
if ($delete->DeleteInvoicePayment(new \StructType\DeleteInvoicePayment()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for DeleteInvoice operation/method
 */
if ($delete->DeleteInvoice(new \StructType\DeleteInvoice()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for DeleteInvoiceByID operation/method
 */
if ($delete->DeleteInvoiceByID(new \StructType\DeleteInvoiceByID()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for DeleteInvoiceLineWithInvoiceID operation/method
 */
if ($delete->DeleteInvoiceLineWithInvoiceID(new \StructType\DeleteInvoiceLineWithInvoiceID()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for DeleteInvoiceLine operation/method
 */
if ($delete->DeleteInvoiceLine(new \StructType\DeleteInvoiceLine()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for DeleteReceipt operation/method
 */
if ($delete->DeleteReceipt(new \StructType\DeleteReceipt()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for DeleteReceiptByID operation/method
 */
if ($delete->DeleteReceiptByID(new \StructType\DeleteReceiptByID()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for DeleteReceiptLine operation/method
 */
if ($delete->DeleteReceiptLine(new \StructType\DeleteReceiptLine()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for DeleteReceiptLineWithReceiptID operation/method
 */
if ($delete->DeleteReceiptLineWithReceiptID(new \StructType\DeleteReceiptLineWithReceiptID()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for DeleteReceiptPayment operation/method
 */
if ($delete->DeleteReceiptPayment(new \StructType\DeleteReceiptPayment()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Samples for Insert ServiceType
 */
$insert = new \ServiceType\Insert($options);
/**
 * Sample call for InsertOrUpdateProject operation/method
 */
if ($insert->InsertOrUpdateProject(new \StructType\InsertOrUpdateProject()) !== false) {
    print_r($insert->getResult());
} else {
    print_r($insert->getLastError());
}
/**
 * Sample call for InsertSupplier operation/method
 */
if ($insert->InsertSupplier(new \StructType\InsertSupplier()) !== false) {
    print_r($insert->getResult());
} else {
    print_r($insert->getLastError());
}
/**
 * Sample call for InsertBankTransaction operation/method
 */
if ($insert->InsertBankTransaction(new \StructType\InsertBankTransaction()) !== false) {
    print_r($insert->getResult());
} else {
    print_r($insert->getLastError());
}
/**
 * Sample call for InsertJournal operation/method
 */
if ($insert->InsertJournal(new \StructType\InsertJournal()) !== false) {
    print_r($insert->getResult());
} else {
    print_r($insert->getLastError());
}
/**
 * Sample call for InsertNominalCode operation/method
 */
if ($insert->InsertNominalCode(new \StructType\InsertNominalCode()) !== false) {
    print_r($insert->getResult());
} else {
    print_r($insert->getLastError());
}
/**
 * Sample call for InsertQuote operation/method
 */
if ($insert->InsertQuote(new \StructType\InsertQuote()) !== false) {
    print_r($insert->getResult());
} else {
    print_r($insert->getLastError());
}
/**
 * Sample call for InsertQuoteLine operation/method
 */
if ($insert->InsertQuoteLine(new \StructType\InsertQuoteLine()) !== false) {
    print_r($insert->getResult());
} else {
    print_r($insert->getLastError());
}
/**
 * Sample call for InsertInvoice operation/method
 */
if ($insert->InsertInvoice(new \StructType\InsertInvoice()) !== false) {
    print_r($insert->getResult());
} else {
    print_r($insert->getLastError());
}
/**
 * Sample call for InsertInvoice_TypeDefined operation/method
 */
if ($insert->InsertInvoice_TypeDefined(new \StructType\InsertInvoice_TypeDefined()) !== false) {
    print_r($insert->getResult());
} else {
    print_r($insert->getLastError());
}
/**
 * Sample call for InsertInvoiceLine operation/method
 */
if ($insert->InsertInvoiceLine(new \StructType\InsertInvoiceLine()) !== false) {
    print_r($insert->getResult());
} else {
    print_r($insert->getLastError());
}
/**
 * Sample call for InsertInvoiceLineWithInvoiceNumber operation/method
 */
if ($insert->InsertInvoiceLineWithInvoiceNumber(new \StructType\InsertInvoiceLineWithInvoiceNumber()) !== false) {
    print_r($insert->getResult());
} else {
    print_r($insert->getLastError());
}
/**
 * Sample call for InsertInvoicePayment operation/method
 */
if ($insert->InsertInvoicePayment(new \StructType\InsertInvoicePayment()) !== false) {
    print_r($insert->getResult());
} else {
    print_r($insert->getLastError());
}
/**
 * Sample call for InsertInvoiceNote operation/method
 */
if ($insert->InsertInvoiceNote(new \StructType\InsertInvoiceNote()) !== false) {
    print_r($insert->getResult());
} else {
    print_r($insert->getLastError());
}
/**
 * Sample call for InsertReceipt_TypeDefined operation/method
 */
if ($insert->InsertReceipt_TypeDefined(new \StructType\InsertReceipt_TypeDefined()) !== false) {
    print_r($insert->getResult());
} else {
    print_r($insert->getLastError());
}
/**
 * Sample call for InsertReceipt operation/method
 */
if ($insert->InsertReceipt(new \StructType\InsertReceipt()) !== false) {
    print_r($insert->getResult());
} else {
    print_r($insert->getLastError());
}
/**
 * Sample call for InsertReceiptLine operation/method
 */
if ($insert->InsertReceiptLine(new \StructType\InsertReceiptLine()) !== false) {
    print_r($insert->getResult());
} else {
    print_r($insert->getLastError());
}
/**
 * Sample call for InsertReceiptLineFromNumber operation/method
 */
if ($insert->InsertReceiptLineFromNumber(new \StructType\InsertReceiptLineFromNumber()) !== false) {
    print_r($insert->getResult());
} else {
    print_r($insert->getLastError());
}
/**
 * Sample call for InsertReceiptPayment operation/method
 */
if ($insert->InsertReceiptPayment(new \StructType\InsertReceiptPayment()) !== false) {
    print_r($insert->getResult());
} else {
    print_r($insert->getLastError());
}
/**
 * Sample call for InsertReceiptNote operation/method
 */
if ($insert->InsertReceiptNote(new \StructType\InsertReceiptNote()) !== false) {
    print_r($insert->getResult());
} else {
    print_r($insert->getLastError());
}
/**
 * Sample call for InsertCustomer operation/method
 */
if ($insert->InsertCustomer(new \StructType\InsertCustomer()) !== false) {
    print_r($insert->getResult());
} else {
    print_r($insert->getLastError());
}
/**
 * Samples for Create ServiceType
 */
$create = new \ServiceType\Create($options);
/**
 * Sample call for CreateBankAccount operation/method
 */
if ($create->CreateBankAccount(new \StructType\CreateBankAccount()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for createAccount operation/method
 */
if ($create->createAccount(new \StructType\CreateAccount()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Samples for VCFT ServiceType
 */
$vCFT = new \ServiceType\VCFT($options);
/**
 * Sample call for VCFToCustomerObjects operation/method
 */
if ($vCFT->VCFToCustomerObjects(new \StructType\VCFToCustomerObjects()) !== false) {
    print_r($vCFT->getResult());
} else {
    print_r($vCFT->getLastError());
}
/**
 * Samples for Attach ServiceType
 */
$attach = new \ServiceType\Attach($options);
/**
 * Sample call for AttachFileToReceipt operation/method
 */
if ($attach->AttachFileToReceipt(new \StructType\AttachFileToReceipt()) !== false) {
    print_r($attach->getResult());
} else {
    print_r($attach->getLastError());
}
/**
 * Samples for Auto ServiceType
 */
$auto = new \ServiceType\Auto($options);
/**
 * Sample call for AutoAuthIP operation/method
 */
if ($auto->AutoAuthIP(new \StructType\AutoAuthIP()) !== false) {
    print_r($auto->getResult());
} else {
    print_r($auto->getLastError());
}
/**
 * Samples for Is ServiceType
 */
$is = new \ServiceType\Is($options);
/**
 * Sample call for isUserVATRegistered operation/method
 */
if ($is->isUserVATRegistered(new \StructType\IsUserVATRegistered()) !== false) {
    print_r($is->getResult());
} else {
    print_r($is->getLastError());
}
/**
 * Sample call for IsOneSaaSEnabled operation/method
 */
if ($is->IsOneSaaSEnabled(new \StructType\IsOneSaaSEnabled()) !== false) {
    print_r($is->getResult());
} else {
    print_r($is->getLastError());
}
/**
 * Sample call for isStillQuote operation/method
 */
if ($is->isStillQuote(new \StructType\IsStillQuote()) !== false) {
    print_r($is->getResult());
} else {
    print_r($is->getLastError());
}
/**
 * Samples for Add ServiceType
 */
$add = new \ServiceType\Add($options);
/**
 * Sample call for AddOrUpdateSubProduct operation/method
 */
if ($add->AddOrUpdateSubProduct(new \StructType\AddOrUpdateSubProduct()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Samples for Sage ServiceType
 */
$sage = new \ServiceType\Sage($options);
/**
 * Sample call for SageFile operation/method
 */
if ($sage->SageFile(new \StructType\SageFile()) !== false) {
    print_r($sage->getResult());
} else {
    print_r($sage->getLastError());
}
/**
 * Sample call for SageFileImport operation/method
 */
if ($sage->SageFileImport(new \StructType\SageFileImport()) !== false) {
    print_r($sage->getResult());
} else {
    print_r($sage->getLastError());
}
/**
 * Samples for Convert ServiceType
 */
$convert = new \ServiceType\Convert($options);
/**
 * Sample call for ConvertQuoteToInvoice operation/method
 */
if ($convert->ConvertQuoteToInvoice(new \StructType\ConvertQuoteToInvoice()) !== false) {
    print_r($convert->getResult());
} else {
    print_r($convert->getLastError());
}
/**
 * Samples for Apply ServiceType
 */
$apply = new \ServiceType\Apply($options);
/**
 * Sample call for applyCreditNoteToInvoice operation/method
 */
if ($apply->applyCreditNoteToInvoice(new \StructType\ApplyCreditNoteToInvoice()) !== false) {
    print_r($apply->getResult());
} else {
    print_r($apply->getLastError());
}
/**
 * Samples for Print ServiceType
 */
$print = new \ServiceType\_Print($options);
/**
 * Sample call for PrintInvoice operation/method
 */
if ($print->PrintInvoice(new \StructType\PrintInvoice()) !== false) {
    print_r($print->getResult());
} else {
    print_r($print->getLastError());
}
/**
 * Sample call for PrintPurchaseOrder operation/method
 */
if ($print->PrintPurchaseOrder(new \StructType\PrintPurchaseOrder()) !== false) {
    print_r($print->getResult());
} else {
    print_r($print->getLastError());
}
/**
 * Samples for Email ServiceType
 */
$email = new \ServiceType\Email($options);
/**
 * Sample call for EmailInvoice operation/method
 */
if ($email->EmailInvoice(new \StructType\EmailInvoice()) !== false) {
    print_r($email->getResult());
} else {
    print_r($email->getLastError());
}
/**
 * Sample call for EmailPurchaseOrder operation/method
 */
if ($email->EmailPurchaseOrder(new \StructType\EmailPurchaseOrder()) !== false) {
    print_r($email->getResult());
} else {
    print_r($email->getLastError());
}
/**
 * Samples for Allocate ServiceType
 */
$allocate = new \ServiceType\Allocate($options);
/**
 * Sample call for AllocateAdvancePaymentToInvoice operation/method
 */
if ($allocate->AllocateAdvancePaymentToInvoice(new \StructType\AllocateAdvancePaymentToInvoice()) !== false) {
    print_r($allocate->getResult());
} else {
    print_r($allocate->getLastError());
}
/**
 * Sample call for AllocateAdvancePaymentToReceipt operation/method
 */
if ($allocate->AllocateAdvancePaymentToReceipt(new \StructType\AllocateAdvancePaymentToReceipt()) !== false) {
    print_r($allocate->getResult());
} else {
    print_r($allocate->getLastError());
}
