<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UserAccountDefaults_TypeDefined StructType
 * @subpackage Structs
 */
class UserAccountDefaults_TypeDefined extends AbstractStructBase
{
    /**
     * The isVATRegistered
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $isVATRegistered;
    /**
     * The VATNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $VATNumber;
    /**
     * The Currencies
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfCurrencies
     */
    public $Currencies;
    /**
     * Constructor method for UserAccountDefaults_TypeDefined
     * @uses UserAccountDefaults_TypeDefined::setIsVATRegistered()
     * @uses UserAccountDefaults_TypeDefined::setVATNumber()
     * @uses UserAccountDefaults_TypeDefined::setCurrencies()
     * @param bool $isVATRegistered
     * @param string $vATNumber
     * @param \ArrayType\ArrayOfCurrencies $currencies
     */
    public function __construct($isVATRegistered = null, $vATNumber = null, \ArrayType\ArrayOfCurrencies $currencies = null)
    {
        $this
            ->setIsVATRegistered($isVATRegistered)
            ->setVATNumber($vATNumber)
            ->setCurrencies($currencies);
    }
    /**
     * Get isVATRegistered value
     * @return bool
     */
    public function getIsVATRegistered()
    {
        return $this->isVATRegistered;
    }
    /**
     * Set isVATRegistered value
     * @param bool $isVATRegistered
     * @return \StructType\UserAccountDefaults_TypeDefined
     */
    public function setIsVATRegistered($isVATRegistered = null)
    {
        // validation for constraint: boolean
        if (!is_null($isVATRegistered) && !is_bool($isVATRegistered)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isVATRegistered)), __LINE__);
        }
        $this->isVATRegistered = $isVATRegistered;
        return $this;
    }
    /**
     * Get VATNumber value
     * @return string|null
     */
    public function getVATNumber()
    {
        return $this->VATNumber;
    }
    /**
     * Set VATNumber value
     * @param string $vATNumber
     * @return \StructType\UserAccountDefaults_TypeDefined
     */
    public function setVATNumber($vATNumber = null)
    {
        // validation for constraint: string
        if (!is_null($vATNumber) && !is_string($vATNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($vATNumber)), __LINE__);
        }
        $this->VATNumber = $vATNumber;
        return $this;
    }
    /**
     * Get Currencies value
     * @return \ArrayType\ArrayOfCurrencies|null
     */
    public function getCurrencies()
    {
        return $this->Currencies;
    }
    /**
     * Set Currencies value
     * @param \ArrayType\ArrayOfCurrencies $currencies
     * @return \StructType\UserAccountDefaults_TypeDefined
     */
    public function setCurrencies(\ArrayType\ArrayOfCurrencies $currencies = null)
    {
        $this->Currencies = $currencies;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UserAccountDefaults_TypeDefined
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
