<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateSupplier StructType
 * @subpackage Structs
 */
class UpdateSupplier extends AbstractStructBase
{
    /**
     * The UserName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UserName;
    /**
     * The Password
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Password;
    /**
     * The sup
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Supplier
     */
    public $sup;
    /**
     * Constructor method for UpdateSupplier
     * @uses UpdateSupplier::setUserName()
     * @uses UpdateSupplier::setPassword()
     * @uses UpdateSupplier::setSup()
     * @param string $userName
     * @param string $password
     * @param \StructType\Supplier $sup
     */
    public function __construct($userName = null, $password = null, \StructType\Supplier $sup = null)
    {
        $this
            ->setUserName($userName)
            ->setPassword($password)
            ->setSup($sup);
    }
    /**
     * Get UserName value
     * @return string|null
     */
    public function getUserName()
    {
        return $this->UserName;
    }
    /**
     * Set UserName value
     * @param string $userName
     * @return \StructType\UpdateSupplier
     */
    public function setUserName($userName = null)
    {
        // validation for constraint: string
        if (!is_null($userName) && !is_string($userName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userName)), __LINE__);
        }
        $this->UserName = $userName;
        return $this;
    }
    /**
     * Get Password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->Password;
    }
    /**
     * Set Password value
     * @param string $password
     * @return \StructType\UpdateSupplier
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->Password = $password;
        return $this;
    }
    /**
     * Get sup value
     * @return \StructType\Supplier|null
     */
    public function getSup()
    {
        return $this->sup;
    }
    /**
     * Set sup value
     * @param \StructType\Supplier $sup
     * @return \StructType\UpdateSupplier
     */
    public function setSup(\StructType\Supplier $sup = null)
    {
        $this->sup = $sup;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UpdateSupplier
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
