<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Supplier StructType
 * @subpackage Structs
 */
class Supplier extends AbstractStructBase
{
    /**
     * The SupplierID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SupplierID;
    /**
     * The Created
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Created;
    /**
     * The Updated
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Updated;
    /**
     * The EC
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $EC;
    /**
     * The CurrencyID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CurrencyID;
    /**
     * The PaymentTerms
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PaymentTerms;
    /**
     * The Code
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Code;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The Contact
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Contact;
    /**
     * The Mobile
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Mobile;
    /**
     * The Fax
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Fax;
    /**
     * The Address1
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Address1;
    /**
     * The Address2
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Address2;
    /**
     * The Address3
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Address3;
    /**
     * The Address4
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Address4;
    /**
     * The PostCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PostCode;
    /**
     * The Telephone
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Telephone;
    /**
     * The Website
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Website;
    /**
     * The Email
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Email;
    /**
     * The VATNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $VATNumber;
    /**
     * The Notes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Notes;
    /**
     * The ContactTitle
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ContactTitle;
    /**
     * The ContactFirstName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ContactFirstName;
    /**
     * The ContactLastName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ContactLastName;
    /**
     * Constructor method for Supplier
     * @uses Supplier::setSupplierID()
     * @uses Supplier::setCreated()
     * @uses Supplier::setUpdated()
     * @uses Supplier::setEC()
     * @uses Supplier::setCurrencyID()
     * @uses Supplier::setPaymentTerms()
     * @uses Supplier::setCode()
     * @uses Supplier::setName()
     * @uses Supplier::setContact()
     * @uses Supplier::setMobile()
     * @uses Supplier::setFax()
     * @uses Supplier::setAddress1()
     * @uses Supplier::setAddress2()
     * @uses Supplier::setAddress3()
     * @uses Supplier::setAddress4()
     * @uses Supplier::setPostCode()
     * @uses Supplier::setTelephone()
     * @uses Supplier::setWebsite()
     * @uses Supplier::setEmail()
     * @uses Supplier::setVATNumber()
     * @uses Supplier::setNotes()
     * @uses Supplier::setContactTitle()
     * @uses Supplier::setContactFirstName()
     * @uses Supplier::setContactLastName()
     * @param int $supplierID
     * @param string $created
     * @param string $updated
     * @param int $eC
     * @param int $currencyID
     * @param int $paymentTerms
     * @param string $code
     * @param string $name
     * @param string $contact
     * @param string $mobile
     * @param string $fax
     * @param string $address1
     * @param string $address2
     * @param string $address3
     * @param string $address4
     * @param string $postCode
     * @param string $telephone
     * @param string $website
     * @param string $email
     * @param string $vATNumber
     * @param string $notes
     * @param string $contactTitle
     * @param string $contactFirstName
     * @param string $contactLastName
     */
    public function __construct($supplierID = null, $created = null, $updated = null, $eC = null, $currencyID = null, $paymentTerms = null, $code = null, $name = null, $contact = null, $mobile = null, $fax = null, $address1 = null, $address2 = null, $address3 = null, $address4 = null, $postCode = null, $telephone = null, $website = null, $email = null, $vATNumber = null, $notes = null, $contactTitle = null, $contactFirstName = null, $contactLastName = null)
    {
        $this
            ->setSupplierID($supplierID)
            ->setCreated($created)
            ->setUpdated($updated)
            ->setEC($eC)
            ->setCurrencyID($currencyID)
            ->setPaymentTerms($paymentTerms)
            ->setCode($code)
            ->setName($name)
            ->setContact($contact)
            ->setMobile($mobile)
            ->setFax($fax)
            ->setAddress1($address1)
            ->setAddress2($address2)
            ->setAddress3($address3)
            ->setAddress4($address4)
            ->setPostCode($postCode)
            ->setTelephone($telephone)
            ->setWebsite($website)
            ->setEmail($email)
            ->setVATNumber($vATNumber)
            ->setNotes($notes)
            ->setContactTitle($contactTitle)
            ->setContactFirstName($contactFirstName)
            ->setContactLastName($contactLastName);
    }
    /**
     * Get SupplierID value
     * @return int
     */
    public function getSupplierID()
    {
        return $this->SupplierID;
    }
    /**
     * Set SupplierID value
     * @param int $supplierID
     * @return \StructType\Supplier
     */
    public function setSupplierID($supplierID = null)
    {
        // validation for constraint: int
        if (!is_null($supplierID) && !is_numeric($supplierID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($supplierID)), __LINE__);
        }
        $this->SupplierID = $supplierID;
        return $this;
    }
    /**
     * Get Created value
     * @return string
     */
    public function getCreated()
    {
        return $this->Created;
    }
    /**
     * Set Created value
     * @param string $created
     * @return \StructType\Supplier
     */
    public function setCreated($created = null)
    {
        // validation for constraint: string
        if (!is_null($created) && !is_string($created)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($created)), __LINE__);
        }
        $this->Created = $created;
        return $this;
    }
    /**
     * Get Updated value
     * @return string
     */
    public function getUpdated()
    {
        return $this->Updated;
    }
    /**
     * Set Updated value
     * @param string $updated
     * @return \StructType\Supplier
     */
    public function setUpdated($updated = null)
    {
        // validation for constraint: string
        if (!is_null($updated) && !is_string($updated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($updated)), __LINE__);
        }
        $this->Updated = $updated;
        return $this;
    }
    /**
     * Get EC value
     * @return int
     */
    public function getEC()
    {
        return $this->EC;
    }
    /**
     * Set EC value
     * @param int $eC
     * @return \StructType\Supplier
     */
    public function setEC($eC = null)
    {
        // validation for constraint: int
        if (!is_null($eC) && !is_numeric($eC)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($eC)), __LINE__);
        }
        $this->EC = $eC;
        return $this;
    }
    /**
     * Get CurrencyID value
     * @return int
     */
    public function getCurrencyID()
    {
        return $this->CurrencyID;
    }
    /**
     * Set CurrencyID value
     * @param int $currencyID
     * @return \StructType\Supplier
     */
    public function setCurrencyID($currencyID = null)
    {
        // validation for constraint: int
        if (!is_null($currencyID) && !is_numeric($currencyID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($currencyID)), __LINE__);
        }
        $this->CurrencyID = $currencyID;
        return $this;
    }
    /**
     * Get PaymentTerms value
     * @return int
     */
    public function getPaymentTerms()
    {
        return $this->PaymentTerms;
    }
    /**
     * Set PaymentTerms value
     * @param int $paymentTerms
     * @return \StructType\Supplier
     */
    public function setPaymentTerms($paymentTerms = null)
    {
        // validation for constraint: int
        if (!is_null($paymentTerms) && !is_numeric($paymentTerms)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($paymentTerms)), __LINE__);
        }
        $this->PaymentTerms = $paymentTerms;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\Supplier
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\Supplier
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Contact value
     * @return string|null
     */
    public function getContact()
    {
        return $this->Contact;
    }
    /**
     * Set Contact value
     * @param string $contact
     * @return \StructType\Supplier
     */
    public function setContact($contact = null)
    {
        // validation for constraint: string
        if (!is_null($contact) && !is_string($contact)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($contact)), __LINE__);
        }
        $this->Contact = $contact;
        return $this;
    }
    /**
     * Get Mobile value
     * @return string|null
     */
    public function getMobile()
    {
        return $this->Mobile;
    }
    /**
     * Set Mobile value
     * @param string $mobile
     * @return \StructType\Supplier
     */
    public function setMobile($mobile = null)
    {
        // validation for constraint: string
        if (!is_null($mobile) && !is_string($mobile)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mobile)), __LINE__);
        }
        $this->Mobile = $mobile;
        return $this;
    }
    /**
     * Get Fax value
     * @return string|null
     */
    public function getFax()
    {
        return $this->Fax;
    }
    /**
     * Set Fax value
     * @param string $fax
     * @return \StructType\Supplier
     */
    public function setFax($fax = null)
    {
        // validation for constraint: string
        if (!is_null($fax) && !is_string($fax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fax)), __LINE__);
        }
        $this->Fax = $fax;
        return $this;
    }
    /**
     * Get Address1 value
     * @return string|null
     */
    public function getAddress1()
    {
        return $this->Address1;
    }
    /**
     * Set Address1 value
     * @param string $address1
     * @return \StructType\Supplier
     */
    public function setAddress1($address1 = null)
    {
        // validation for constraint: string
        if (!is_null($address1) && !is_string($address1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($address1)), __LINE__);
        }
        $this->Address1 = $address1;
        return $this;
    }
    /**
     * Get Address2 value
     * @return string|null
     */
    public function getAddress2()
    {
        return $this->Address2;
    }
    /**
     * Set Address2 value
     * @param string $address2
     * @return \StructType\Supplier
     */
    public function setAddress2($address2 = null)
    {
        // validation for constraint: string
        if (!is_null($address2) && !is_string($address2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($address2)), __LINE__);
        }
        $this->Address2 = $address2;
        return $this;
    }
    /**
     * Get Address3 value
     * @return string|null
     */
    public function getAddress3()
    {
        return $this->Address3;
    }
    /**
     * Set Address3 value
     * @param string $address3
     * @return \StructType\Supplier
     */
    public function setAddress3($address3 = null)
    {
        // validation for constraint: string
        if (!is_null($address3) && !is_string($address3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($address3)), __LINE__);
        }
        $this->Address3 = $address3;
        return $this;
    }
    /**
     * Get Address4 value
     * @return string|null
     */
    public function getAddress4()
    {
        return $this->Address4;
    }
    /**
     * Set Address4 value
     * @param string $address4
     * @return \StructType\Supplier
     */
    public function setAddress4($address4 = null)
    {
        // validation for constraint: string
        if (!is_null($address4) && !is_string($address4)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($address4)), __LINE__);
        }
        $this->Address4 = $address4;
        return $this;
    }
    /**
     * Get PostCode value
     * @return string|null
     */
    public function getPostCode()
    {
        return $this->PostCode;
    }
    /**
     * Set PostCode value
     * @param string $postCode
     * @return \StructType\Supplier
     */
    public function setPostCode($postCode = null)
    {
        // validation for constraint: string
        if (!is_null($postCode) && !is_string($postCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($postCode)), __LINE__);
        }
        $this->PostCode = $postCode;
        return $this;
    }
    /**
     * Get Telephone value
     * @return string|null
     */
    public function getTelephone()
    {
        return $this->Telephone;
    }
    /**
     * Set Telephone value
     * @param string $telephone
     * @return \StructType\Supplier
     */
    public function setTelephone($telephone = null)
    {
        // validation for constraint: string
        if (!is_null($telephone) && !is_string($telephone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($telephone)), __LINE__);
        }
        $this->Telephone = $telephone;
        return $this;
    }
    /**
     * Get Website value
     * @return string|null
     */
    public function getWebsite()
    {
        return $this->Website;
    }
    /**
     * Set Website value
     * @param string $website
     * @return \StructType\Supplier
     */
    public function setWebsite($website = null)
    {
        // validation for constraint: string
        if (!is_null($website) && !is_string($website)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($website)), __LINE__);
        }
        $this->Website = $website;
        return $this;
    }
    /**
     * Get Email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->Email;
    }
    /**
     * Set Email value
     * @param string $email
     * @return \StructType\Supplier
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($email)), __LINE__);
        }
        $this->Email = $email;
        return $this;
    }
    /**
     * Get VATNumber value
     * @return string|null
     */
    public function getVATNumber()
    {
        return $this->VATNumber;
    }
    /**
     * Set VATNumber value
     * @param string $vATNumber
     * @return \StructType\Supplier
     */
    public function setVATNumber($vATNumber = null)
    {
        // validation for constraint: string
        if (!is_null($vATNumber) && !is_string($vATNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($vATNumber)), __LINE__);
        }
        $this->VATNumber = $vATNumber;
        return $this;
    }
    /**
     * Get Notes value
     * @return string|null
     */
    public function getNotes()
    {
        return $this->Notes;
    }
    /**
     * Set Notes value
     * @param string $notes
     * @return \StructType\Supplier
     */
    public function setNotes($notes = null)
    {
        // validation for constraint: string
        if (!is_null($notes) && !is_string($notes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($notes)), __LINE__);
        }
        $this->Notes = $notes;
        return $this;
    }
    /**
     * Get ContactTitle value
     * @return string|null
     */
    public function getContactTitle()
    {
        return $this->ContactTitle;
    }
    /**
     * Set ContactTitle value
     * @param string $contactTitle
     * @return \StructType\Supplier
     */
    public function setContactTitle($contactTitle = null)
    {
        // validation for constraint: string
        if (!is_null($contactTitle) && !is_string($contactTitle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($contactTitle)), __LINE__);
        }
        $this->ContactTitle = $contactTitle;
        return $this;
    }
    /**
     * Get ContactFirstName value
     * @return string|null
     */
    public function getContactFirstName()
    {
        return $this->ContactFirstName;
    }
    /**
     * Set ContactFirstName value
     * @param string $contactFirstName
     * @return \StructType\Supplier
     */
    public function setContactFirstName($contactFirstName = null)
    {
        // validation for constraint: string
        if (!is_null($contactFirstName) && !is_string($contactFirstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($contactFirstName)), __LINE__);
        }
        $this->ContactFirstName = $contactFirstName;
        return $this;
    }
    /**
     * Get ContactLastName value
     * @return string|null
     */
    public function getContactLastName()
    {
        return $this->ContactLastName;
    }
    /**
     * Set ContactLastName value
     * @param string $contactLastName
     * @return \StructType\Supplier
     */
    public function setContactLastName($contactLastName = null)
    {
        // validation for constraint: string
        if (!is_null($contactLastName) && !is_string($contactLastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($contactLastName)), __LINE__);
        }
        $this->ContactLastName = $contactLastName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Supplier
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
