<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SubProduct StructType
 * @subpackage Structs
 */
class SubProduct extends AbstractStructBase
{
    /**
     * The id
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $id;
    /**
     * The ParentID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ParentID;
    /**
     * The Price
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Price;
    /**
     * The VatRate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $VatRate;
    /**
     * The WholesalePrice
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $WholesalePrice;
    /**
     * The Managed
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Managed;
    /**
     * The QtyInStock
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $QtyInStock;
    /**
     * The StockWarnQty
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $StockWarnQty;
    /**
     * The AutoFill
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AutoFill;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The Code
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Code;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * Constructor method for SubProduct
     * @uses SubProduct::setId()
     * @uses SubProduct::setParentID()
     * @uses SubProduct::setPrice()
     * @uses SubProduct::setVatRate()
     * @uses SubProduct::setWholesalePrice()
     * @uses SubProduct::setManaged()
     * @uses SubProduct::setQtyInStock()
     * @uses SubProduct::setStockWarnQty()
     * @uses SubProduct::setAutoFill()
     * @uses SubProduct::setName()
     * @uses SubProduct::setCode()
     * @uses SubProduct::setDescription()
     * @param int $id
     * @param int $parentID
     * @param float $price
     * @param float $vatRate
     * @param float $wholesalePrice
     * @param int $managed
     * @param int $qtyInStock
     * @param int $stockWarnQty
     * @param int $autoFill
     * @param string $name
     * @param string $code
     * @param string $description
     */
    public function __construct($id = null, $parentID = null, $price = null, $vatRate = null, $wholesalePrice = null, $managed = null, $qtyInStock = null, $stockWarnQty = null, $autoFill = null, $name = null, $code = null, $description = null)
    {
        $this
            ->setId($id)
            ->setParentID($parentID)
            ->setPrice($price)
            ->setVatRate($vatRate)
            ->setWholesalePrice($wholesalePrice)
            ->setManaged($managed)
            ->setQtyInStock($qtyInStock)
            ->setStockWarnQty($stockWarnQty)
            ->setAutoFill($autoFill)
            ->setName($name)
            ->setCode($code)
            ->setDescription($description);
    }
    /**
     * Get id value
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param int $id
     * @return \StructType\SubProduct
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !is_numeric($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get ParentID value
     * @return int
     */
    public function getParentID()
    {
        return $this->ParentID;
    }
    /**
     * Set ParentID value
     * @param int $parentID
     * @return \StructType\SubProduct
     */
    public function setParentID($parentID = null)
    {
        // validation for constraint: int
        if (!is_null($parentID) && !is_numeric($parentID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($parentID)), __LINE__);
        }
        $this->ParentID = $parentID;
        return $this;
    }
    /**
     * Get Price value
     * @return float
     */
    public function getPrice()
    {
        return $this->Price;
    }
    /**
     * Set Price value
     * @param float $price
     * @return \StructType\SubProduct
     */
    public function setPrice($price = null)
    {
        $this->Price = $price;
        return $this;
    }
    /**
     * Get VatRate value
     * @return float
     */
    public function getVatRate()
    {
        return $this->VatRate;
    }
    /**
     * Set VatRate value
     * @param float $vatRate
     * @return \StructType\SubProduct
     */
    public function setVatRate($vatRate = null)
    {
        $this->VatRate = $vatRate;
        return $this;
    }
    /**
     * Get WholesalePrice value
     * @return float
     */
    public function getWholesalePrice()
    {
        return $this->WholesalePrice;
    }
    /**
     * Set WholesalePrice value
     * @param float $wholesalePrice
     * @return \StructType\SubProduct
     */
    public function setWholesalePrice($wholesalePrice = null)
    {
        $this->WholesalePrice = $wholesalePrice;
        return $this;
    }
    /**
     * Get Managed value
     * @return int
     */
    public function getManaged()
    {
        return $this->Managed;
    }
    /**
     * Set Managed value
     * @param int $managed
     * @return \StructType\SubProduct
     */
    public function setManaged($managed = null)
    {
        // validation for constraint: int
        if (!is_null($managed) && !is_numeric($managed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($managed)), __LINE__);
        }
        $this->Managed = $managed;
        return $this;
    }
    /**
     * Get QtyInStock value
     * @return int
     */
    public function getQtyInStock()
    {
        return $this->QtyInStock;
    }
    /**
     * Set QtyInStock value
     * @param int $qtyInStock
     * @return \StructType\SubProduct
     */
    public function setQtyInStock($qtyInStock = null)
    {
        // validation for constraint: int
        if (!is_null($qtyInStock) && !is_numeric($qtyInStock)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($qtyInStock)), __LINE__);
        }
        $this->QtyInStock = $qtyInStock;
        return $this;
    }
    /**
     * Get StockWarnQty value
     * @return int
     */
    public function getStockWarnQty()
    {
        return $this->StockWarnQty;
    }
    /**
     * Set StockWarnQty value
     * @param int $stockWarnQty
     * @return \StructType\SubProduct
     */
    public function setStockWarnQty($stockWarnQty = null)
    {
        // validation for constraint: int
        if (!is_null($stockWarnQty) && !is_numeric($stockWarnQty)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($stockWarnQty)), __LINE__);
        }
        $this->StockWarnQty = $stockWarnQty;
        return $this;
    }
    /**
     * Get AutoFill value
     * @return int
     */
    public function getAutoFill()
    {
        return $this->AutoFill;
    }
    /**
     * Set AutoFill value
     * @param int $autoFill
     * @return \StructType\SubProduct
     */
    public function setAutoFill($autoFill = null)
    {
        // validation for constraint: int
        if (!is_null($autoFill) && !is_numeric($autoFill)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($autoFill)), __LINE__);
        }
        $this->AutoFill = $autoFill;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\SubProduct
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\SubProduct
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\SubProduct
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SubProduct
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
