<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SageFile StructType
 * @subpackage Structs
 */
class SageFile extends AbstractStructBase
{
    /**
     * The buffer
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $buffer;
    /**
     * The reference
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $reference;
    /**
     * Constructor method for SageFile
     * @uses SageFile::setBuffer()
     * @uses SageFile::setReference()
     * @param string $buffer
     * @param string $reference
     */
    public function __construct($buffer = null, $reference = null)
    {
        $this
            ->setBuffer($buffer)
            ->setReference($reference);
    }
    /**
     * Get buffer value
     * @return string|null
     */
    public function getBuffer()
    {
        return $this->buffer;
    }
    /**
     * Set buffer value
     * @param string $buffer
     * @return \StructType\SageFile
     */
    public function setBuffer($buffer = null)
    {
        // validation for constraint: string
        if (!is_null($buffer) && !is_string($buffer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($buffer)), __LINE__);
        }
        $this->buffer = $buffer;
        return $this;
    }
    /**
     * Get reference value
     * @return string|null
     */
    public function getReference()
    {
        return $this->reference;
    }
    /**
     * Set reference value
     * @param string $reference
     * @return \StructType\SageFile
     */
    public function setReference($reference = null)
    {
        // validation for constraint: string
        if (!is_null($reference) && !is_string($reference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($reference)), __LINE__);
        }
        $this->reference = $reference;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SageFile
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
