<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Payment StructType
 * @subpackage Structs
 */
class Payment extends AbstractStructBase
{
    /**
     * The PayID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PayID;
    /**
     * The PayInvoice
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PayInvoice;
    /**
     * The PayDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PayDate;
    /**
     * The PayMethod
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PayMethod;
    /**
     * The PayAccount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PayAccount;
    /**
     * The PayAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $PayAmount;
    /**
     * The PayNote
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PayNote;
    /**
     * Constructor method for Payment
     * @uses Payment::setPayID()
     * @uses Payment::setPayInvoice()
     * @uses Payment::setPayDate()
     * @uses Payment::setPayMethod()
     * @uses Payment::setPayAccount()
     * @uses Payment::setPayAmount()
     * @uses Payment::setPayNote()
     * @param int $payID
     * @param int $payInvoice
     * @param string $payDate
     * @param int $payMethod
     * @param int $payAccount
     * @param float $payAmount
     * @param string $payNote
     */
    public function __construct($payID = null, $payInvoice = null, $payDate = null, $payMethod = null, $payAccount = null, $payAmount = null, $payNote = null)
    {
        $this
            ->setPayID($payID)
            ->setPayInvoice($payInvoice)
            ->setPayDate($payDate)
            ->setPayMethod($payMethod)
            ->setPayAccount($payAccount)
            ->setPayAmount($payAmount)
            ->setPayNote($payNote);
    }
    /**
     * Get PayID value
     * @return int
     */
    public function getPayID()
    {
        return $this->PayID;
    }
    /**
     * Set PayID value
     * @param int $payID
     * @return \StructType\Payment
     */
    public function setPayID($payID = null)
    {
        // validation for constraint: int
        if (!is_null($payID) && !is_numeric($payID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($payID)), __LINE__);
        }
        $this->PayID = $payID;
        return $this;
    }
    /**
     * Get PayInvoice value
     * @return int
     */
    public function getPayInvoice()
    {
        return $this->PayInvoice;
    }
    /**
     * Set PayInvoice value
     * @param int $payInvoice
     * @return \StructType\Payment
     */
    public function setPayInvoice($payInvoice = null)
    {
        // validation for constraint: int
        if (!is_null($payInvoice) && !is_numeric($payInvoice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($payInvoice)), __LINE__);
        }
        $this->PayInvoice = $payInvoice;
        return $this;
    }
    /**
     * Get PayDate value
     * @return string
     */
    public function getPayDate()
    {
        return $this->PayDate;
    }
    /**
     * Set PayDate value
     * @param string $payDate
     * @return \StructType\Payment
     */
    public function setPayDate($payDate = null)
    {
        // validation for constraint: string
        if (!is_null($payDate) && !is_string($payDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($payDate)), __LINE__);
        }
        $this->PayDate = $payDate;
        return $this;
    }
    /**
     * Get PayMethod value
     * @return int
     */
    public function getPayMethod()
    {
        return $this->PayMethod;
    }
    /**
     * Set PayMethod value
     * @param int $payMethod
     * @return \StructType\Payment
     */
    public function setPayMethod($payMethod = null)
    {
        // validation for constraint: int
        if (!is_null($payMethod) && !is_numeric($payMethod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($payMethod)), __LINE__);
        }
        $this->PayMethod = $payMethod;
        return $this;
    }
    /**
     * Get PayAccount value
     * @return int
     */
    public function getPayAccount()
    {
        return $this->PayAccount;
    }
    /**
     * Set PayAccount value
     * @param int $payAccount
     * @return \StructType\Payment
     */
    public function setPayAccount($payAccount = null)
    {
        // validation for constraint: int
        if (!is_null($payAccount) && !is_numeric($payAccount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($payAccount)), __LINE__);
        }
        $this->PayAccount = $payAccount;
        return $this;
    }
    /**
     * Get PayAmount value
     * @return float
     */
    public function getPayAmount()
    {
        return $this->PayAmount;
    }
    /**
     * Set PayAmount value
     * @param float $payAmount
     * @return \StructType\Payment
     */
    public function setPayAmount($payAmount = null)
    {
        $this->PayAmount = $payAmount;
        return $this;
    }
    /**
     * Get PayNote value
     * @return string|null
     */
    public function getPayNote()
    {
        return $this->PayNote;
    }
    /**
     * Set PayNote value
     * @param string $payNote
     * @return \StructType\Payment
     */
    public function setPayNote($payNote = null)
    {
        // validation for constraint: string
        if (!is_null($payNote) && !is_string($payNote)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($payNote)), __LINE__);
        }
        $this->PayNote = $payNote;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Payment
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
