<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NominalCodeExtended StructType
 * @subpackage Structs
 */
class NominalCodeExtended extends AbstractStructBase
{
    /**
     * The id
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $id;
    /**
     * The Code
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Code;
    /**
     * The debit
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $debit;
    /**
     * The credit
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $credit;
    /**
     * The balance
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $balance;
    /**
     * The TypeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TypeID;
    /**
     * The ClassificationID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ClassificationID;
    /**
     * The AutoFill
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AutoFill;
    /**
     * The Price
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Price;
    /**
     * The VATRate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $VATRate;
    /**
     * The Archived
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Archived;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The TypeName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TypeName;
    /**
     * The ClassificationName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ClassificationName;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * Constructor method for NominalCodeExtended
     * @uses NominalCodeExtended::setId()
     * @uses NominalCodeExtended::setCode()
     * @uses NominalCodeExtended::setDebit()
     * @uses NominalCodeExtended::setCredit()
     * @uses NominalCodeExtended::setBalance()
     * @uses NominalCodeExtended::setTypeID()
     * @uses NominalCodeExtended::setClassificationID()
     * @uses NominalCodeExtended::setAutoFill()
     * @uses NominalCodeExtended::setPrice()
     * @uses NominalCodeExtended::setVATRate()
     * @uses NominalCodeExtended::setArchived()
     * @uses NominalCodeExtended::setName()
     * @uses NominalCodeExtended::setTypeName()
     * @uses NominalCodeExtended::setClassificationName()
     * @uses NominalCodeExtended::setDescription()
     * @param int $id
     * @param int $code
     * @param float $debit
     * @param float $credit
     * @param float $balance
     * @param int $typeID
     * @param int $classificationID
     * @param int $autoFill
     * @param float $price
     * @param float $vATRate
     * @param bool $archived
     * @param string $name
     * @param string $typeName
     * @param string $classificationName
     * @param string $description
     */
    public function __construct($id = null, $code = null, $debit = null, $credit = null, $balance = null, $typeID = null, $classificationID = null, $autoFill = null, $price = null, $vATRate = null, $archived = null, $name = null, $typeName = null, $classificationName = null, $description = null)
    {
        $this
            ->setId($id)
            ->setCode($code)
            ->setDebit($debit)
            ->setCredit($credit)
            ->setBalance($balance)
            ->setTypeID($typeID)
            ->setClassificationID($classificationID)
            ->setAutoFill($autoFill)
            ->setPrice($price)
            ->setVATRate($vATRate)
            ->setArchived($archived)
            ->setName($name)
            ->setTypeName($typeName)
            ->setClassificationName($classificationName)
            ->setDescription($description);
    }
    /**
     * Get id value
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param int $id
     * @return \StructType\NominalCodeExtended
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !is_numeric($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get Code value
     * @return int
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param int $code
     * @return \StructType\NominalCodeExtended
     */
    public function setCode($code = null)
    {
        // validation for constraint: int
        if (!is_null($code) && !is_numeric($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get debit value
     * @return float
     */
    public function getDebit()
    {
        return $this->debit;
    }
    /**
     * Set debit value
     * @param float $debit
     * @return \StructType\NominalCodeExtended
     */
    public function setDebit($debit = null)
    {
        $this->debit = $debit;
        return $this;
    }
    /**
     * Get credit value
     * @return float
     */
    public function getCredit()
    {
        return $this->credit;
    }
    /**
     * Set credit value
     * @param float $credit
     * @return \StructType\NominalCodeExtended
     */
    public function setCredit($credit = null)
    {
        $this->credit = $credit;
        return $this;
    }
    /**
     * Get balance value
     * @return float
     */
    public function getBalance()
    {
        return $this->balance;
    }
    /**
     * Set balance value
     * @param float $balance
     * @return \StructType\NominalCodeExtended
     */
    public function setBalance($balance = null)
    {
        $this->balance = $balance;
        return $this;
    }
    /**
     * Get TypeID value
     * @return int
     */
    public function getTypeID()
    {
        return $this->TypeID;
    }
    /**
     * Set TypeID value
     * @param int $typeID
     * @return \StructType\NominalCodeExtended
     */
    public function setTypeID($typeID = null)
    {
        // validation for constraint: int
        if (!is_null($typeID) && !is_numeric($typeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($typeID)), __LINE__);
        }
        $this->TypeID = $typeID;
        return $this;
    }
    /**
     * Get ClassificationID value
     * @return int
     */
    public function getClassificationID()
    {
        return $this->ClassificationID;
    }
    /**
     * Set ClassificationID value
     * @param int $classificationID
     * @return \StructType\NominalCodeExtended
     */
    public function setClassificationID($classificationID = null)
    {
        // validation for constraint: int
        if (!is_null($classificationID) && !is_numeric($classificationID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($classificationID)), __LINE__);
        }
        $this->ClassificationID = $classificationID;
        return $this;
    }
    /**
     * Get AutoFill value
     * @return int
     */
    public function getAutoFill()
    {
        return $this->AutoFill;
    }
    /**
     * Set AutoFill value
     * @param int $autoFill
     * @return \StructType\NominalCodeExtended
     */
    public function setAutoFill($autoFill = null)
    {
        // validation for constraint: int
        if (!is_null($autoFill) && !is_numeric($autoFill)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($autoFill)), __LINE__);
        }
        $this->AutoFill = $autoFill;
        return $this;
    }
    /**
     * Get Price value
     * @return float
     */
    public function getPrice()
    {
        return $this->Price;
    }
    /**
     * Set Price value
     * @param float $price
     * @return \StructType\NominalCodeExtended
     */
    public function setPrice($price = null)
    {
        $this->Price = $price;
        return $this;
    }
    /**
     * Get VATRate value
     * @return float
     */
    public function getVATRate()
    {
        return $this->VATRate;
    }
    /**
     * Set VATRate value
     * @param float $vATRate
     * @return \StructType\NominalCodeExtended
     */
    public function setVATRate($vATRate = null)
    {
        $this->VATRate = $vATRate;
        return $this;
    }
    /**
     * Get Archived value
     * @return bool
     */
    public function getArchived()
    {
        return $this->Archived;
    }
    /**
     * Set Archived value
     * @param bool $archived
     * @return \StructType\NominalCodeExtended
     */
    public function setArchived($archived = null)
    {
        // validation for constraint: boolean
        if (!is_null($archived) && !is_bool($archived)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($archived)), __LINE__);
        }
        $this->Archived = $archived;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\NominalCodeExtended
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get TypeName value
     * @return string|null
     */
    public function getTypeName()
    {
        return $this->TypeName;
    }
    /**
     * Set TypeName value
     * @param string $typeName
     * @return \StructType\NominalCodeExtended
     */
    public function setTypeName($typeName = null)
    {
        // validation for constraint: string
        if (!is_null($typeName) && !is_string($typeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($typeName)), __LINE__);
        }
        $this->TypeName = $typeName;
        return $this;
    }
    /**
     * Get ClassificationName value
     * @return string|null
     */
    public function getClassificationName()
    {
        return $this->ClassificationName;
    }
    /**
     * Set ClassificationName value
     * @param string $classificationName
     * @return \StructType\NominalCodeExtended
     */
    public function setClassificationName($classificationName = null)
    {
        // validation for constraint: string
        if (!is_null($classificationName) && !is_string($classificationName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($classificationName)), __LINE__);
        }
        $this->ClassificationName = $classificationName;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\NominalCodeExtended
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\NominalCodeExtended
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
