<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetInvoices_Recent_TypeDefined StructType
 * @subpackage Structs
 */
class GetInvoices_Recent_TypeDefined extends AbstractStructBase
{
    /**
     * The NumberOfInvoices
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $NumberOfInvoices;
    /**
     * The UserName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UserName;
    /**
     * The Password
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Password;
    /**
     * Constructor method for GetInvoices_Recent_TypeDefined
     * @uses GetInvoices_Recent_TypeDefined::setNumberOfInvoices()
     * @uses GetInvoices_Recent_TypeDefined::setUserName()
     * @uses GetInvoices_Recent_TypeDefined::setPassword()
     * @param int $numberOfInvoices
     * @param string $userName
     * @param string $password
     */
    public function __construct($numberOfInvoices = null, $userName = null, $password = null)
    {
        $this
            ->setNumberOfInvoices($numberOfInvoices)
            ->setUserName($userName)
            ->setPassword($password);
    }
    /**
     * Get NumberOfInvoices value
     * @return int
     */
    public function getNumberOfInvoices()
    {
        return $this->NumberOfInvoices;
    }
    /**
     * Set NumberOfInvoices value
     * @param int $numberOfInvoices
     * @return \StructType\GetInvoices_Recent_TypeDefined
     */
    public function setNumberOfInvoices($numberOfInvoices = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfInvoices) && !is_numeric($numberOfInvoices)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($numberOfInvoices)), __LINE__);
        }
        $this->NumberOfInvoices = $numberOfInvoices;
        return $this;
    }
    /**
     * Get UserName value
     * @return string|null
     */
    public function getUserName()
    {
        return $this->UserName;
    }
    /**
     * Set UserName value
     * @param string $userName
     * @return \StructType\GetInvoices_Recent_TypeDefined
     */
    public function setUserName($userName = null)
    {
        // validation for constraint: string
        if (!is_null($userName) && !is_string($userName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userName)), __LINE__);
        }
        $this->UserName = $userName;
        return $this;
    }
    /**
     * Get Password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->Password;
    }
    /**
     * Set Password value
     * @param string $password
     * @return \StructType\GetInvoices_Recent_TypeDefined
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->Password = $password;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetInvoices_Recent_TypeDefined
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
