<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerBalance StructType
 * @subpackage Structs
 */
class CustomerBalance extends AbstractStructBase
{
    /**
     * The CustomerId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerId;
    /**
     * The Value
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Value;
    /**
     * The Balance
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Balance;
    /**
     * The CustomerCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerCode;
    /**
     * Constructor method for CustomerBalance
     * @uses CustomerBalance::setCustomerId()
     * @uses CustomerBalance::setValue()
     * @uses CustomerBalance::setBalance()
     * @uses CustomerBalance::setCustomerCode()
     * @param int $customerId
     * @param float $value
     * @param float $balance
     * @param string $customerCode
     */
    public function __construct($customerId = null, $value = null, $balance = null, $customerCode = null)
    {
        $this
            ->setCustomerId($customerId)
            ->setValue($value)
            ->setBalance($balance)
            ->setCustomerCode($customerCode);
    }
    /**
     * Get CustomerId value
     * @return int
     */
    public function getCustomerId()
    {
        return $this->CustomerId;
    }
    /**
     * Set CustomerId value
     * @param int $customerId
     * @return \StructType\CustomerBalance
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: int
        if (!is_null($customerId) && !is_numeric($customerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($customerId)), __LINE__);
        }
        $this->CustomerId = $customerId;
        return $this;
    }
    /**
     * Get Value value
     * @return float
     */
    public function getValue()
    {
        return $this->Value;
    }
    /**
     * Set Value value
     * @param float $value
     * @return \StructType\CustomerBalance
     */
    public function setValue($value = null)
    {
        $this->Value = $value;
        return $this;
    }
    /**
     * Get Balance value
     * @return float
     */
    public function getBalance()
    {
        return $this->Balance;
    }
    /**
     * Set Balance value
     * @param float $balance
     * @return \StructType\CustomerBalance
     */
    public function setBalance($balance = null)
    {
        $this->Balance = $balance;
        return $this;
    }
    /**
     * Get CustomerCode value
     * @return string|null
     */
    public function getCustomerCode()
    {
        return $this->CustomerCode;
    }
    /**
     * Set CustomerCode value
     * @param string $customerCode
     * @return \StructType\CustomerBalance
     */
    public function setCustomerCode($customerCode = null)
    {
        // validation for constraint: string
        if (!is_null($customerCode) && !is_string($customerCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customerCode)), __LINE__);
        }
        $this->CustomerCode = $customerCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CustomerBalance
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
