<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ConvertQuoteToInvoice StructType
 * @subpackage Structs
 */
class ConvertQuoteToInvoice extends AbstractStructBase
{
    /**
     * The QuoteID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $QuoteID;
    /**
     * The CustomerID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerID;
    /**
     * The CopyQuoteReference
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CopyQuoteReference;
    /**
     * The deleteQuoteAfterConversion
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $deleteQuoteAfterConversion;
    /**
     * The UserName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UserName;
    /**
     * The Password
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Password;
    /**
     * Constructor method for ConvertQuoteToInvoice
     * @uses ConvertQuoteToInvoice::setQuoteID()
     * @uses ConvertQuoteToInvoice::setCustomerID()
     * @uses ConvertQuoteToInvoice::setCopyQuoteReference()
     * @uses ConvertQuoteToInvoice::setDeleteQuoteAfterConversion()
     * @uses ConvertQuoteToInvoice::setUserName()
     * @uses ConvertQuoteToInvoice::setPassword()
     * @param int $quoteID
     * @param int $customerID
     * @param int $copyQuoteReference
     * @param int $deleteQuoteAfterConversion
     * @param string $userName
     * @param string $password
     */
    public function __construct($quoteID = null, $customerID = null, $copyQuoteReference = null, $deleteQuoteAfterConversion = null, $userName = null, $password = null)
    {
        $this
            ->setQuoteID($quoteID)
            ->setCustomerID($customerID)
            ->setCopyQuoteReference($copyQuoteReference)
            ->setDeleteQuoteAfterConversion($deleteQuoteAfterConversion)
            ->setUserName($userName)
            ->setPassword($password);
    }
    /**
     * Get QuoteID value
     * @return int
     */
    public function getQuoteID()
    {
        return $this->QuoteID;
    }
    /**
     * Set QuoteID value
     * @param int $quoteID
     * @return \StructType\ConvertQuoteToInvoice
     */
    public function setQuoteID($quoteID = null)
    {
        // validation for constraint: int
        if (!is_null($quoteID) && !is_numeric($quoteID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($quoteID)), __LINE__);
        }
        $this->QuoteID = $quoteID;
        return $this;
    }
    /**
     * Get CustomerID value
     * @return int
     */
    public function getCustomerID()
    {
        return $this->CustomerID;
    }
    /**
     * Set CustomerID value
     * @param int $customerID
     * @return \StructType\ConvertQuoteToInvoice
     */
    public function setCustomerID($customerID = null)
    {
        // validation for constraint: int
        if (!is_null($customerID) && !is_numeric($customerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($customerID)), __LINE__);
        }
        $this->CustomerID = $customerID;
        return $this;
    }
    /**
     * Get CopyQuoteReference value
     * @return int
     */
    public function getCopyQuoteReference()
    {
        return $this->CopyQuoteReference;
    }
    /**
     * Set CopyQuoteReference value
     * @param int $copyQuoteReference
     * @return \StructType\ConvertQuoteToInvoice
     */
    public function setCopyQuoteReference($copyQuoteReference = null)
    {
        // validation for constraint: int
        if (!is_null($copyQuoteReference) && !is_numeric($copyQuoteReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($copyQuoteReference)), __LINE__);
        }
        $this->CopyQuoteReference = $copyQuoteReference;
        return $this;
    }
    /**
     * Get deleteQuoteAfterConversion value
     * @return int
     */
    public function getDeleteQuoteAfterConversion()
    {
        return $this->deleteQuoteAfterConversion;
    }
    /**
     * Set deleteQuoteAfterConversion value
     * @param int $deleteQuoteAfterConversion
     * @return \StructType\ConvertQuoteToInvoice
     */
    public function setDeleteQuoteAfterConversion($deleteQuoteAfterConversion = null)
    {
        // validation for constraint: int
        if (!is_null($deleteQuoteAfterConversion) && !is_numeric($deleteQuoteAfterConversion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($deleteQuoteAfterConversion)), __LINE__);
        }
        $this->deleteQuoteAfterConversion = $deleteQuoteAfterConversion;
        return $this;
    }
    /**
     * Get UserName value
     * @return string|null
     */
    public function getUserName()
    {
        return $this->UserName;
    }
    /**
     * Set UserName value
     * @param string $userName
     * @return \StructType\ConvertQuoteToInvoice
     */
    public function setUserName($userName = null)
    {
        // validation for constraint: string
        if (!is_null($userName) && !is_string($userName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userName)), __LINE__);
        }
        $this->UserName = $userName;
        return $this;
    }
    /**
     * Get Password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->Password;
    }
    /**
     * Set Password value
     * @param string $password
     * @return \StructType\ConvertQuoteToInvoice
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->Password = $password;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ConvertQuoteToInvoice
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
