<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AutoAuthIPResponse StructType
 * @subpackage Structs
 */
class AutoAuthIPResponse extends AbstractStructBase
{
    /**
     * The AutoAuthIPResult
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AutoAuthIPResult;
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Status;
    /**
     * The StatusDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $StatusDetail;
    /**
     * Constructor method for AutoAuthIPResponse
     * @uses AutoAuthIPResponse::setAutoAuthIPResult()
     * @uses AutoAuthIPResponse::setStatus()
     * @uses AutoAuthIPResponse::setStatusDetail()
     * @param int $autoAuthIPResult
     * @param string $status
     * @param string $statusDetail
     */
    public function __construct($autoAuthIPResult = null, $status = null, $statusDetail = null)
    {
        $this
            ->setAutoAuthIPResult($autoAuthIPResult)
            ->setStatus($status)
            ->setStatusDetail($statusDetail);
    }
    /**
     * Get AutoAuthIPResult value
     * @return int
     */
    public function getAutoAuthIPResult()
    {
        return $this->AutoAuthIPResult;
    }
    /**
     * Set AutoAuthIPResult value
     * @param int $autoAuthIPResult
     * @return \StructType\AutoAuthIPResponse
     */
    public function setAutoAuthIPResult($autoAuthIPResult = null)
    {
        // validation for constraint: int
        if (!is_null($autoAuthIPResult) && !is_numeric($autoAuthIPResult)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($autoAuthIPResult)), __LINE__);
        }
        $this->AutoAuthIPResult = $autoAuthIPResult;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param string $status
     * @return \StructType\AutoAuthIPResponse
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get StatusDetail value
     * @return string|null
     */
    public function getStatusDetail()
    {
        return $this->StatusDetail;
    }
    /**
     * Set StatusDetail value
     * @param string $statusDetail
     * @return \StructType\AutoAuthIPResponse
     */
    public function setStatusDetail($statusDetail = null)
    {
        // validation for constraint: string
        if (!is_null($statusDetail) && !is_string($statusDetail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($statusDetail)), __LINE__);
        }
        $this->StatusDetail = $statusDetail;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AutoAuthIPResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
