<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Is ServiceType
 * @subpackage Services
 */
class Is extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named isUserVATRegistered
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\IsUserVATRegistered $parameters
     * @return \StructType\IsUserVATRegisteredResponse|bool
     */
    public function isUserVATRegistered(\StructType\IsUserVATRegistered $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->isUserVATRegistered($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named IsOneSaaSEnabled
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\IsOneSaaSEnabled $parameters
     * @return \StructType\IsOneSaaSEnabledResponse|bool
     */
    public function IsOneSaaSEnabled(\StructType\IsOneSaaSEnabled $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->IsOneSaaSEnabled($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named isStillQuote
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\IsStillQuote $parameters
     * @return \StructType\IsStillQuoteResponse|bool
     */
    public function isStillQuote(\StructType\IsStillQuote $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->isStillQuote($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\IsOneSaaSEnabledResponse|\StructType\IsStillQuoteResponse|\StructType\IsUserVATRegisteredResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
