<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GetCustomerCurrency
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCustomerCurrency $parameters
     * @return \StructType\GetCustomerCurrencyResponse|bool
     */
    public function GetCustomerCurrency(\StructType\GetCustomerCurrency $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetCustomerCurrency($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCustomerSources
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCustomerSources $parameters
     * @return \StructType\GetCustomerSourcesResponse|bool
     */
    public function GetCustomerSources(\StructType\GetCustomerSources $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetCustomerSources($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCustomersByPostcode
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCustomersByPostcode $parameters
     * @return \StructType\GetCustomersByPostcodeResponse|bool
     */
    public function GetCustomersByPostcode(\StructType\GetCustomersByPostcode $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetCustomersByPostcode($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCustomerBalance
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCustomerBalance $parameters
     * @return \StructType\GetCustomerBalanceResponse|bool
     */
    public function GetCustomerBalance(\StructType\GetCustomerBalance $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetCustomerBalance($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCustomerAdvancePayments
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCustomerAdvancePayments $parameters
     * @return \StructType\GetCustomerAdvancePaymentsResponse|bool
     */
    public function GetCustomerAdvancePayments(\StructType\GetCustomerAdvancePayments $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetCustomerAdvancePayments($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetProjects_Full
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetProjects_Full $parameters
     * @return \StructType\GetProjects_FullResponse|bool
     */
    public function GetProjects_Full(\StructType\GetProjects_Full $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetProjects_Full($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetProjects
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetProjects $parameters
     * @return \StructType\GetProjectsResponse|bool
     */
    public function GetProjects(\StructType\GetProjects $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetProjects($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetProjectById
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetProjectById $parameters
     * @return \StructType\GetProjectByIdResponse|bool
     */
    public function GetProjectById(\StructType\GetProjectById $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetProjectById($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetProjectByRef
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetProjectByRef $parameters
     * @return \StructType\GetProjectByRefResponse|bool
     */
    public function GetProjectByRef(\StructType\GetProjectByRef $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetProjectByRef($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetProjectByName
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetProjectByName $parameters
     * @return \StructType\GetProjectByNameResponse|bool
     */
    public function GetProjectByName(\StructType\GetProjectByName $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetProjectByName($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetSupplierVATNumber
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetSupplierVATNumber $parameters
     * @return \StructType\GetSupplierVATNumberResponse|bool
     */
    public function GetSupplierVATNumber(\StructType\GetSupplierVATNumber $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetSupplierVATNumber($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetSupplier
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetSupplier $parameters
     * @return \StructType\GetSupplierResponse|bool
     */
    public function GetSupplier(\StructType\GetSupplier $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetSupplier($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetSuppliers
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetSuppliers $parameters
     * @return \StructType\GetSuppliersResponse|bool
     */
    public function GetSuppliers(\StructType\GetSuppliers $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetSuppliers($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetSupplierCurrency
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetSupplierCurrency $parameters
     * @return \StructType\GetSupplierCurrencyResponse|bool
     */
    public function GetSupplierCurrency(\StructType\GetSupplierCurrency $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetSupplierCurrency($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetSupplierByID
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetSupplierByID $parameters
     * @return \StructType\GetSupplierByIDResponse|bool
     */
    public function GetSupplierByID(\StructType\GetSupplierByID $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetSupplierByID($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetBankBalance
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetBankBalance $parameters
     * @return \StructType\GetBankBalanceResponse|bool
     */
    public function GetBankBalance(\StructType\GetBankBalance $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetBankBalance($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetBankAccounts
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetBankAccounts $parameters
     * @return \StructType\GetBankAccountsResponse|bool
     */
    public function GetBankAccounts(\StructType\GetBankAccounts $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetBankAccounts($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetBankTxTypes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetBankTxTypes $parameters
     * @return \StructType\GetBankTxTypesResponse|bool
     */
    public function GetBankTxTypes(\StructType\GetBankTxTypes $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetBankTxTypes($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetBankTransactions
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetBankTransactions $parameters
     * @return \StructType\GetBankTransactionsResponse|bool
     */
    public function GetBankTransactions(\StructType\GetBankTransactions $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetBankTransactions($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetBalanceSheet
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetBalanceSheet $parameters
     * @return \StructType\GetBalanceSheetResponse|bool
     */
    public function GetBalanceSheet(\StructType\GetBalanceSheet $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetBalanceSheet($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetProfitAndLoss
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetProfitAndLoss $parameters
     * @return \StructType\GetProfitAndLossResponse|bool
     */
    public function GetProfitAndLoss(\StructType\GetProfitAndLoss $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetProfitAndLoss($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetMonthlyProfitAndLoss
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetMonthlyProfitAndLoss $parameters
     * @return \StructType\GetMonthlyProfitAndLossResponse|bool
     */
    public function GetMonthlyProfitAndLoss(\StructType\GetMonthlyProfitAndLoss $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetMonthlyProfitAndLoss($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetTrialBalance
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetTrialBalance $parameters
     * @return \StructType\GetTrialBalanceResponse|bool
     */
    public function GetTrialBalance(\StructType\GetTrialBalance $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetTrialBalance($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetTrialBalanceWithOpeningBalances
     * Meta informations extracted from the WSDL
     * - documentation: Returns NominalCodeBalance which extends NominalCode. Please refer to WSDL service description for reference
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetTrialBalanceWithOpeningBalances $parameters
     * @return \StructType\GetTrialBalanceWithOpeningBalancesResponse|bool
     */
    public function GetTrialBalanceWithOpeningBalances(\StructType\GetTrialBalanceWithOpeningBalances $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetTrialBalanceWithOpeningBalances($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetVATReport
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetVATReport $parameters
     * @return \StructType\GetVATReportResponse|bool
     */
    public function GetVATReport(\StructType\GetVATReport $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetVATReport($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetDigitaCSVFile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetDigitaCSVFile $parameters
     * @return \StructType\GetDigitaCSVFileResponse|bool
     */
    public function GetDigitaCSVFile(\StructType\GetDigitaCSVFile $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetDigitaCSVFile($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetNominalLedger
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetNominalLedger $parameters
     * @return \StructType\GetNominalLedgerResponse|bool
     */
    public function GetNominalLedger(\StructType\GetNominalLedger $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetNominalLedger($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAgedDebtors
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAgedDebtors $parameters
     * @return \StructType\GetAgedDebtorsResponse|bool
     */
    public function GetAgedDebtors(\StructType\GetAgedDebtors $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetAgedDebtors($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAgedCreditors
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAgedCreditors $parameters
     * @return \StructType\GetAgedCreditorsResponse|bool
     */
    public function GetAgedCreditors(\StructType\GetAgedCreditors $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetAgedCreditors($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetIncomeByCustomer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetIncomeByCustomer $parameters
     * @return \StructType\GetIncomeByCustomerResponse|bool
     */
    public function GetIncomeByCustomer(\StructType\GetIncomeByCustomer $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetIncomeByCustomer($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetJournals
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetJournals $parameters
     * @return \StructType\GetJournalsResponse|bool
     */
    public function GetJournals(\StructType\GetJournals $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetJournals($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetJournal
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetJournal $parameters
     * @return \StructType\GetJournalResponse|bool
     */
    public function GetJournal(\StructType\GetJournal $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetJournal($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetBankOverview
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetBankOverview $parameters
     * @return \StructType\GetBankOverviewResponse|bool
     */
    public function GetBankOverview(\StructType\GetBankOverview $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetBankOverview($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAccountOverview
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAccountOverview $parameters
     * @return \StructType\GetAccountOverviewResponse|bool
     */
    public function GetAccountOverview(\StructType\GetAccountOverview $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetAccountOverview($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCurrencies
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCurrencies $parameters
     * @return \StructType\GetCurrenciesResponse|bool
     */
    public function GetCurrencies(\StructType\GetCurrencies $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetCurrencies($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetUserAccountDefaults
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetUserAccountDefaults $parameters
     * @return \StructType\GetUserAccountDefaultsResponse|bool
     */
    public function GetUserAccountDefaults(\StructType\GetUserAccountDefaults $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetUserAccountDefaults($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetUserAccountDefaults_TypeDefined
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetUserAccountDefaults_TypeDefined $parameters
     * @return \StructType\GetUserAccountDefaults_TypeDefinedResponse|bool
     */
    public function GetUserAccountDefaults_TypeDefined(\StructType\GetUserAccountDefaults_TypeDefined $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetUserAccountDefaults_TypeDefined($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetReceiptAttachments
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetReceiptAttachments $parameters
     * @return \StructType\GetReceiptAttachmentsResponse|bool
     */
    public function GetReceiptAttachments(\StructType\GetReceiptAttachments $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetReceiptAttachments($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetRemoteLoginURL
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetRemoteLoginURL $parameters
     * @return \StructType\GetRemoteLoginURLResponse|bool
     */
    public function GetRemoteLoginURL(\StructType\GetRemoteLoginURL $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetRemoteLoginURL($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetProducts
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetProducts $parameters
     * @return \StructType\GetProductsResponse|bool
     */
    public function GetProducts(\StructType\GetProducts $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetProducts($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetSubProducts
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetSubProducts $parameters
     * @return \StructType\GetSubProductsResponse|bool
     */
    public function GetSubProducts(\StructType\GetSubProducts $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetSubProducts($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetSubProductByID
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetSubProductByID $parameters
     * @return \StructType\GetSubProductByIDResponse|bool
     */
    public function GetSubProductByID(\StructType\GetSubProductByID $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetSubProductByID($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetSubProductByCode
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetSubProductByCode $parameters
     * @return \StructType\GetSubProductByCodeResponse|bool
     */
    public function GetSubProductByCode(\StructType\GetSubProductByCode $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetSubProductByCode($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetProductsWithSubProducts
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetProductsWithSubProducts $parameters
     * @return \StructType\GetProductsWithSubProductsResponse|bool
     */
    public function GetProductsWithSubProducts(\StructType\GetProductsWithSubProducts $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetProductsWithSubProducts($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetNominalCodes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetNominalCodes $parameters
     * @return \StructType\GetNominalCodesResponse|bool
     */
    public function GetNominalCodes(\StructType\GetNominalCodes $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetNominalCodes($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetNominalCodesExtended
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetNominalCodesExtended $parameters
     * @return \StructType\GetNominalCodesExtendedResponse|bool
     */
    public function GetNominalCodesExtended(\StructType\GetNominalCodesExtended $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetNominalCodesExtended($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetKPIs
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetKPIs $parameters
     * @return \StructType\GetKPIsResponse|bool
     */
    public function GetKPIs(\StructType\GetKPIs $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetKPIs($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetVATRates
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetVATRates $parameters
     * @return \StructType\GetVATRatesResponse|bool
     */
    public function GetVATRates(\StructType\GetVATRates $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetVATRates($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCompanyDetails
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCompanyDetails $parameters
     * @return \StructType\GetCompanyDetailsResponse|bool
     */
    public function GetCompanyDetails(\StructType\GetCompanyDetails $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetCompanyDetails($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetQuoteByID
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetQuoteByID $parameters
     * @return \StructType\GetQuoteByIDResponse|bool
     */
    public function GetQuoteByID(\StructType\GetQuoteByID $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetQuoteByID($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetQuoteByNumber
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetQuoteByNumber $parameters
     * @return \StructType\GetQuoteByNumberResponse|bool
     */
    public function GetQuoteByNumber(\StructType\GetQuoteByNumber $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetQuoteByNumber($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetQuotes_Recent
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetQuotes_Recent $parameters
     * @return \StructType\GetQuotes_RecentResponse|bool
     */
    public function GetQuotes_Recent(\StructType\GetQuotes_Recent $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetQuotes_Recent($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetQuotes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetQuotes $parameters
     * @return \StructType\GetQuotesResponse|bool
     */
    public function GetQuotes(\StructType\GetQuotes $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetQuotes($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetQuotesForCustomer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetQuotesForCustomer $parameters
     * @return \StructType\GetQuotesForCustomerResponse|bool
     */
    public function GetQuotesForCustomer(\StructType\GetQuotesForCustomer $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetQuotesForCustomer($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetInvoiceByID
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetInvoiceByID $parameters
     * @return \StructType\GetInvoiceByIDResponse|bool
     */
    public function GetInvoiceByID(\StructType\GetInvoiceByID $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetInvoiceByID($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetInvoice
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetInvoice $parameters
     * @return \StructType\GetInvoiceResponse|bool
     */
    public function GetInvoice(\StructType\GetInvoice $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetInvoice($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetInvoice_TypeDefined
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetInvoice_TypeDefined $parameters
     * @return \StructType\GetInvoice_TypeDefinedResponse|bool
     */
    public function GetInvoice_TypeDefined(\StructType\GetInvoice_TypeDefined $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetInvoice_TypeDefined($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetInvoicesByDateRange
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetInvoicesByDateRange $parameters
     * @return \StructType\GetInvoicesByDateRangeResponse|bool
     */
    public function GetInvoicesByDateRange(\StructType\GetInvoicesByDateRange $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetInvoicesByDateRange($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetInvoicesForCustomer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetInvoicesForCustomer $parameters
     * @return \StructType\GetInvoicesForCustomerResponse|bool
     */
    public function GetInvoicesForCustomer(\StructType\GetInvoicesForCustomer $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetInvoicesForCustomer($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetInvoices_Unpaid
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetInvoices_Unpaid $parameters
     * @return \StructType\GetInvoices_UnpaidResponse|bool
     */
    public function GetInvoices_Unpaid(\StructType\GetInvoices_Unpaid $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetInvoices_Unpaid($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetInvoices_Unpaid_TypeDefined
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetInvoices_Unpaid_TypeDefined $parameters
     * @return \StructType\GetInvoices_Unpaid_TypeDefinedResponse|bool
     */
    public function GetInvoices_Unpaid_TypeDefined(\StructType\GetInvoices_Unpaid_TypeDefined $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetInvoices_Unpaid_TypeDefined($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetInvoices_Overdue
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetInvoices_Overdue $parameters
     * @return \StructType\GetInvoices_OverdueResponse|bool
     */
    public function GetInvoices_Overdue(\StructType\GetInvoices_Overdue $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetInvoices_Overdue($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetInvoices_Overdue_TypeDefined
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetInvoices_Overdue_TypeDefined $parameters
     * @return \StructType\GetInvoices_Overdue_TypeDefinedResponse|bool
     */
    public function GetInvoices_Overdue_TypeDefined(\StructType\GetInvoices_Overdue_TypeDefined $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetInvoices_Overdue_TypeDefined($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetInvoices_Recent
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetInvoices_Recent $parameters
     * @return \StructType\GetInvoices_RecentResponse|bool
     */
    public function GetInvoices_Recent(\StructType\GetInvoices_Recent $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetInvoices_Recent($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetInvoices_Recent_TypeDefined
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetInvoices_Recent_TypeDefined $parameters
     * @return \StructType\GetInvoices_Recent_TypeDefinedResponse|bool
     */
    public function GetInvoices_Recent_TypeDefined(\StructType\GetInvoices_Recent_TypeDefined $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetInvoices_Recent_TypeDefined($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetInvoicesForCustomer_typeDefined
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetInvoicesForCustomer_typeDefined $parameters
     * @return \StructType\GetInvoicesForCustomer_typeDefinedResponse|bool
     */
    public function GetInvoicesForCustomer_typeDefined(\StructType\GetInvoicesForCustomer_typeDefined $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetInvoicesForCustomer_typeDefined($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetInvoicePayment
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetInvoicePayment $parameters
     * @return \StructType\GetInvoicePaymentResponse|bool
     */
    public function GetInvoicePayment(\StructType\GetInvoicePayment $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetInvoicePayment($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetInvPayMethods
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetInvPayMethods $parameters
     * @return \StructType\GetInvPayMethodsResponse|bool
     */
    public function GetInvPayMethods(\StructType\GetInvPayMethods $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetInvPayMethods($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetPaypalLink
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetPaypalLink $parameters
     * @return \StructType\GetPaypalLinkResponse|bool
     */
    public function GetPaypalLink(\StructType\GetPaypalLink $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetPaypalLink($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetInvoiceNotes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetInvoiceNotes $parameters
     * @return \StructType\GetInvoiceNotesResponse|bool
     */
    public function GetInvoiceNotes(\StructType\GetInvoiceNotes $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetInvoiceNotes($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * GetInvoicePaymentsCountforDateRange
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetInvoicePaymentsCountforDateRange $parameters
     * @return \StructType\GetInvoicePaymentsCountforDateRangeResponse|bool
     */
    public function GetInvoicePaymentsCountforDateRange(\StructType\GetInvoicePaymentsCountforDateRange $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetInvoicePaymentsCountforDateRange($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetInvoicePaymentsByDateRange
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetInvoicePaymentsByDateRange $parameters
     * @return \StructType\GetInvoicePaymentsByDateRangeResponse|bool
     */
    public function GetInvoicePaymentsByDateRange(\StructType\GetInvoicePaymentsByDateRange $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetInvoicePaymentsByDateRange($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetReceipt_TypeDefined
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetReceipt_TypeDefined $parameters
     * @return \StructType\GetReceipt_TypeDefinedResponse|bool
     */
    public function GetReceipt_TypeDefined(\StructType\GetReceipt_TypeDefined $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetReceipt_TypeDefined($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetReceipt
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetReceipt $parameters
     * @return \StructType\GetReceiptResponse|bool
     */
    public function GetReceipt(\StructType\GetReceipt $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetReceipt($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetReceipts_Recent
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetReceipts_Recent $parameters
     * @return \StructType\GetReceipts_RecentResponse|bool
     */
    public function GetReceipts_Recent(\StructType\GetReceipts_Recent $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetReceipts_Recent($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetReceipts
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetReceipts $parameters
     * @return \StructType\GetReceiptsResponse|bool
     */
    public function GetReceipts(\StructType\GetReceipts $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetReceipts($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetReceiptsWithPaging
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetReceiptsWithPaging $parameters
     * @return \StructType\GetReceiptsWithPagingResponse|bool
     */
    public function GetReceiptsWithPaging(\StructType\GetReceiptsWithPaging $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetReceiptsWithPaging($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetReceiptsForSupplier
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetReceiptsForSupplier $parameters
     * @return \StructType\GetReceiptsForSupplierResponse|bool
     */
    public function GetReceiptsForSupplier(\StructType\GetReceiptsForSupplier $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetReceiptsForSupplier($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetReceiptPayment
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetReceiptPayment $parameters
     * @return \StructType\GetReceiptPaymentResponse|bool
     */
    public function GetReceiptPayment(\StructType\GetReceiptPayment $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetReceiptPayment($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetRecPayMethods
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetRecPayMethods $parameters
     * @return \StructType\GetRecPayMethodsResponse|bool
     */
    public function GetRecPayMethods(\StructType\GetRecPayMethods $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetRecPayMethods($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetReceiptNotes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetReceiptNotes $parameters
     * @return \StructType\GetReceiptNotesResponse|bool
     */
    public function GetReceiptNotes(\StructType\GetReceiptNotes $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetReceiptNotes($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCustomerVATNumber
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCustomerVATNumber $parameters
     * @return \StructType\GetCustomerVATNumberResponse|bool
     */
    public function GetCustomerVATNumber(\StructType\GetCustomerVATNumber $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetCustomerVATNumber($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCustomer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCustomer $parameters
     * @return \StructType\GetCustomerResponse|bool
     */
    public function GetCustomer(\StructType\GetCustomer $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetCustomer($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCustomerByID
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCustomerByID $parameters
     * @return \StructType\GetCustomerByIDResponse|bool
     */
    public function GetCustomerByID(\StructType\GetCustomerByID $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetCustomerByID($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCustomerByEmail
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCustomerByEmail $parameters
     * @return \StructType\GetCustomerByEmailResponse|bool
     */
    public function GetCustomerByEmail(\StructType\GetCustomerByEmail $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetCustomerByEmail($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCustomersModifiedSince
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCustomersModifiedSince $parameters
     * @return \StructType\GetCustomersModifiedSinceResponse|bool
     */
    public function GetCustomersModifiedSince(\StructType\GetCustomersModifiedSince $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetCustomersModifiedSince($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCustomers
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCustomers $parameters
     * @return \StructType\GetCustomersResponse|bool
     */
    public function GetCustomers(\StructType\GetCustomers $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetCustomers($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GetAccountOverviewResponse|\StructType\GetAgedCreditorsResponse|\StructType\GetAgedDebtorsResponse|\StructType\GetBalanceSheetResponse|\StructType\GetBankAccountsResponse|\StructType\GetBankBalanceResponse|\StructType\GetBankOverviewResponse|\StructType\GetBankTransactionsResponse|\StructType\GetBankTxTypesResponse|\StructType\GetCompanyDetailsResponse|\StructType\GetCurrenciesResponse|\StructType\GetCustomerAdvancePaymentsResponse|\StructType\GetCustomerBalanceResponse|\StructType\GetCustomerByEmailResponse|\StructType\GetCustomerByIDResponse|\StructType\GetCustomerCurrencyResponse|\StructType\GetCustomerResponse|\StructType\GetCustomersByPostcodeResponse|\StructType\GetCustomersModifiedSinceResponse|\StructType\GetCustomerSourcesResponse|\StructType\GetCustomersResponse|\StructType\GetCustomerVATNumberResponse|\StructType\GetDigitaCSVFileResponse|\StructType\GetIncomeByCustomerResponse|\StructType\GetInvoiceByIDResponse|\StructType\GetInvoiceNotesResponse|\StructType\GetInvoicePaymentResponse|\StructType\GetInvoicePaymentsByDateRangeResponse|\StructType\GetInvoicePaymentsCountforDateRangeResponse|\StructType\GetInvoiceResponse|\StructType\GetInvoicesByDateRangeResponse|\StructType\GetInvoicesForCustomerResponse|\StructType\GetInvoicesForCustomer_typeDefinedResponse|\StructType\GetInvoices_OverdueResponse|\StructType\GetInvoices_Overdue_TypeDefinedResponse|\StructType\GetInvoices_RecentResponse|\StructType\GetInvoices_Recent_TypeDefinedResponse|\StructType\GetInvoices_UnpaidResponse|\StructType\GetInvoices_Unpaid_TypeDefinedResponse|\StructType\GetInvoice_TypeDefinedResponse|\StructType\GetInvPayMethodsResponse|\StructType\GetJournalResponse|\StructType\GetJournalsResponse|\StructType\GetKPIsResponse|\StructType\GetMonthlyProfitAndLossResponse|\StructType\GetNominalCodesExtendedResponse|\StructType\GetNominalCodesResponse|\StructType\GetNominalLedgerResponse|\StructType\GetPaypalLinkResponse|\StructType\GetProductsResponse|\StructType\GetProductsWithSubProductsResponse|\StructType\GetProfitAndLossResponse|\StructType\GetProjectByIdResponse|\StructType\GetProjectByNameResponse|\StructType\GetProjectByRefResponse|\StructType\GetProjectsResponse|\StructType\GetProjects_FullResponse|\StructType\GetQuoteByIDResponse|\StructType\GetQuoteByNumberResponse|\StructType\GetQuotesForCustomerResponse|\StructType\GetQuotesResponse|\StructType\GetQuotes_RecentResponse|\StructType\GetReceiptAttachmentsResponse|\StructType\GetReceiptNotesResponse|\StructType\GetReceiptPaymentResponse|\StructType\GetReceiptResponse|\StructType\GetReceiptsForSupplierResponse|\StructType\GetReceiptsResponse|\StructType\GetReceiptsWithPagingResponse|\StructType\GetReceipts_RecentResponse|\StructType\GetReceipt_TypeDefinedResponse|\StructType\GetRecPayMethodsResponse|\StructType\GetRemoteLoginURLResponse|\StructType\GetSubProductByCodeResponse|\StructType\GetSubProductByIDResponse|\StructType\GetSubProductsResponse|\StructType\GetSupplierByIDResponse|\StructType\GetSupplierCurrencyResponse|\StructType\GetSupplierResponse|\StructType\GetSuppliersResponse|\StructType\GetSupplierVATNumberResponse|\StructType\GetTrialBalanceResponse|\StructType\GetTrialBalanceWithOpeningBalancesResponse|\StructType\GetUserAccountDefaultsResponse|\StructType\GetUserAccountDefaults_TypeDefinedResponse|\StructType\GetVATRatesResponse|\StructType\GetVATReportResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
