<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfSubProduct ArrayType
 * @subpackage Arrays
 */
class ArrayOfSubProduct extends AbstractStructArrayBase
{
    /**
     * The SubProduct
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\SubProduct[]
     */
    public $SubProduct;
    /**
     * Constructor method for ArrayOfSubProduct
     * @uses ArrayOfSubProduct::setSubProduct()
     * @param \StructType\SubProduct[] $subProduct
     */
    public function __construct(array $subProduct = array())
    {
        $this
            ->setSubProduct($subProduct);
    }
    /**
     * Get SubProduct value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\SubProduct[]|null
     */
    public function getSubProduct()
    {
        return isset($this->SubProduct) ? $this->SubProduct : null;
    }
    /**
     * Set SubProduct value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\SubProduct[] $subProduct
     * @return \ArrayType\ArrayOfSubProduct
     */
    public function setSubProduct(array $subProduct = array())
    {
        foreach ($subProduct as $arrayOfSubProductSubProductItem) {
            // validation for constraint: itemType
            if (!$arrayOfSubProductSubProductItem instanceof \StructType\SubProduct) {
                throw new \InvalidArgumentException(sprintf('The SubProduct property can only contain items of \StructType\SubProduct, "%s" given', is_object($arrayOfSubProductSubProductItem) ? get_class($arrayOfSubProductSubProductItem) : gettype($arrayOfSubProductSubProductItem)), __LINE__);
            }
        }
        if (is_null($subProduct) || (is_array($subProduct) && empty($subProduct))) {
            unset($this->SubProduct);
        } else {
            $this->SubProduct = $subProduct;
        }
        return $this;
    }
    /**
     * Add item to SubProduct value
     * @throws \InvalidArgumentException
     * @param \StructType\SubProduct $item
     * @return \ArrayType\ArrayOfSubProduct
     */
    public function addToSubProduct(\StructType\SubProduct $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SubProduct) {
            throw new \InvalidArgumentException(sprintf('The SubProduct property can only contain items of \StructType\SubProduct, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->SubProduct[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\SubProduct|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\SubProduct|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\SubProduct|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\SubProduct|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\SubProduct|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string SubProduct
     */
    public function getAttributeName()
    {
        return 'SubProduct';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfSubProduct
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
