<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfReceiptAttachment ArrayType
 * @subpackage Arrays
 */
class ArrayOfReceiptAttachment extends AbstractStructArrayBase
{
    /**
     * The ReceiptAttachment
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ReceiptAttachment[]
     */
    public $ReceiptAttachment;
    /**
     * Constructor method for ArrayOfReceiptAttachment
     * @uses ArrayOfReceiptAttachment::setReceiptAttachment()
     * @param \StructType\ReceiptAttachment[] $receiptAttachment
     */
    public function __construct(array $receiptAttachment = array())
    {
        $this
            ->setReceiptAttachment($receiptAttachment);
    }
    /**
     * Get ReceiptAttachment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ReceiptAttachment[]|null
     */
    public function getReceiptAttachment()
    {
        return isset($this->ReceiptAttachment) ? $this->ReceiptAttachment : null;
    }
    /**
     * Set ReceiptAttachment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ReceiptAttachment[] $receiptAttachment
     * @return \ArrayType\ArrayOfReceiptAttachment
     */
    public function setReceiptAttachment(array $receiptAttachment = array())
    {
        foreach ($receiptAttachment as $arrayOfReceiptAttachmentReceiptAttachmentItem) {
            // validation for constraint: itemType
            if (!$arrayOfReceiptAttachmentReceiptAttachmentItem instanceof \StructType\ReceiptAttachment) {
                throw new \InvalidArgumentException(sprintf('The ReceiptAttachment property can only contain items of \StructType\ReceiptAttachment, "%s" given', is_object($arrayOfReceiptAttachmentReceiptAttachmentItem) ? get_class($arrayOfReceiptAttachmentReceiptAttachmentItem) : gettype($arrayOfReceiptAttachmentReceiptAttachmentItem)), __LINE__);
            }
        }
        if (is_null($receiptAttachment) || (is_array($receiptAttachment) && empty($receiptAttachment))) {
            unset($this->ReceiptAttachment);
        } else {
            $this->ReceiptAttachment = $receiptAttachment;
        }
        return $this;
    }
    /**
     * Add item to ReceiptAttachment value
     * @throws \InvalidArgumentException
     * @param \StructType\ReceiptAttachment $item
     * @return \ArrayType\ArrayOfReceiptAttachment
     */
    public function addToReceiptAttachment(\StructType\ReceiptAttachment $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ReceiptAttachment) {
            throw new \InvalidArgumentException(sprintf('The ReceiptAttachment property can only contain items of \StructType\ReceiptAttachment, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ReceiptAttachment[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ReceiptAttachment|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ReceiptAttachment|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ReceiptAttachment|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ReceiptAttachment|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ReceiptAttachment|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ReceiptAttachment
     */
    public function getAttributeName()
    {
        return 'ReceiptAttachment';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfReceiptAttachment
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
