<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfNominalCode ArrayType
 * @subpackage Arrays
 */
class ArrayOfNominalCode extends AbstractStructArrayBase
{
    /**
     * The NominalCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\NominalCode[]
     */
    public $NominalCode;
    /**
     * Constructor method for ArrayOfNominalCode
     * @uses ArrayOfNominalCode::setNominalCode()
     * @param \StructType\NominalCode[] $nominalCode
     */
    public function __construct(array $nominalCode = array())
    {
        $this
            ->setNominalCode($nominalCode);
    }
    /**
     * Get NominalCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\NominalCode[]|null
     */
    public function getNominalCode()
    {
        return isset($this->NominalCode) ? $this->NominalCode : null;
    }
    /**
     * Set NominalCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\NominalCode[] $nominalCode
     * @return \ArrayType\ArrayOfNominalCode
     */
    public function setNominalCode(array $nominalCode = array())
    {
        foreach ($nominalCode as $arrayOfNominalCodeNominalCodeItem) {
            // validation for constraint: itemType
            if (!$arrayOfNominalCodeNominalCodeItem instanceof \StructType\NominalCode) {
                throw new \InvalidArgumentException(sprintf('The NominalCode property can only contain items of \StructType\NominalCode, "%s" given', is_object($arrayOfNominalCodeNominalCodeItem) ? get_class($arrayOfNominalCodeNominalCodeItem) : gettype($arrayOfNominalCodeNominalCodeItem)), __LINE__);
            }
        }
        if (is_null($nominalCode) || (is_array($nominalCode) && empty($nominalCode))) {
            unset($this->NominalCode);
        } else {
            $this->NominalCode = $nominalCode;
        }
        return $this;
    }
    /**
     * Add item to NominalCode value
     * @throws \InvalidArgumentException
     * @param \StructType\NominalCode $item
     * @return \ArrayType\ArrayOfNominalCode
     */
    public function addToNominalCode(\StructType\NominalCode $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\NominalCode) {
            throw new \InvalidArgumentException(sprintf('The NominalCode property can only contain items of \StructType\NominalCode, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->NominalCode[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\NominalCode|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\NominalCode|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\NominalCode|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\NominalCode|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\NominalCode|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string NominalCode
     */
    public function getAttributeName()
    {
        return 'NominalCode';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfNominalCode
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
