<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfMonthlyPL ArrayType
 * @subpackage Arrays
 */
class ArrayOfMonthlyPL extends AbstractStructArrayBase
{
    /**
     * The MonthlyPL
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\MonthlyPL[]
     */
    public $MonthlyPL;
    /**
     * Constructor method for ArrayOfMonthlyPL
     * @uses ArrayOfMonthlyPL::setMonthlyPL()
     * @param \StructType\MonthlyPL[] $monthlyPL
     */
    public function __construct(array $monthlyPL = array())
    {
        $this
            ->setMonthlyPL($monthlyPL);
    }
    /**
     * Get MonthlyPL value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\MonthlyPL[]|null
     */
    public function getMonthlyPL()
    {
        return isset($this->MonthlyPL) ? $this->MonthlyPL : null;
    }
    /**
     * Set MonthlyPL value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\MonthlyPL[] $monthlyPL
     * @return \ArrayType\ArrayOfMonthlyPL
     */
    public function setMonthlyPL(array $monthlyPL = array())
    {
        foreach ($monthlyPL as $arrayOfMonthlyPLMonthlyPLItem) {
            // validation for constraint: itemType
            if (!$arrayOfMonthlyPLMonthlyPLItem instanceof \StructType\MonthlyPL) {
                throw new \InvalidArgumentException(sprintf('The MonthlyPL property can only contain items of \StructType\MonthlyPL, "%s" given', is_object($arrayOfMonthlyPLMonthlyPLItem) ? get_class($arrayOfMonthlyPLMonthlyPLItem) : gettype($arrayOfMonthlyPLMonthlyPLItem)), __LINE__);
            }
        }
        if (is_null($monthlyPL) || (is_array($monthlyPL) && empty($monthlyPL))) {
            unset($this->MonthlyPL);
        } else {
            $this->MonthlyPL = $monthlyPL;
        }
        return $this;
    }
    /**
     * Add item to MonthlyPL value
     * @throws \InvalidArgumentException
     * @param \StructType\MonthlyPL $item
     * @return \ArrayType\ArrayOfMonthlyPL
     */
    public function addToMonthlyPL(\StructType\MonthlyPL $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\MonthlyPL) {
            throw new \InvalidArgumentException(sprintf('The MonthlyPL property can only contain items of \StructType\MonthlyPL, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->MonthlyPL[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\MonthlyPL|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\MonthlyPL|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\MonthlyPL|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\MonthlyPL|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\MonthlyPL|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string MonthlyPL
     */
    public function getAttributeName()
    {
        return 'MonthlyPL';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfMonthlyPL
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
