<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfCustomer ArrayType
 * @subpackage Arrays
 */
class ArrayOfCustomer extends AbstractStructArrayBase
{
    /**
     * The Customer
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Customer[]
     */
    public $Customer;
    /**
     * Constructor method for ArrayOfCustomer
     * @uses ArrayOfCustomer::setCustomer()
     * @param \StructType\Customer[] $customer
     */
    public function __construct(array $customer = array())
    {
        $this
            ->setCustomer($customer);
    }
    /**
     * Get Customer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Customer[]|null
     */
    public function getCustomer()
    {
        return isset($this->Customer) ? $this->Customer : null;
    }
    /**
     * Set Customer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Customer[] $customer
     * @return \ArrayType\ArrayOfCustomer
     */
    public function setCustomer(array $customer = array())
    {
        foreach ($customer as $arrayOfCustomerCustomerItem) {
            // validation for constraint: itemType
            if (!$arrayOfCustomerCustomerItem instanceof \StructType\Customer) {
                throw new \InvalidArgumentException(sprintf('The Customer property can only contain items of \StructType\Customer, "%s" given', is_object($arrayOfCustomerCustomerItem) ? get_class($arrayOfCustomerCustomerItem) : gettype($arrayOfCustomerCustomerItem)), __LINE__);
            }
        }
        if (is_null($customer) || (is_array($customer) && empty($customer))) {
            unset($this->Customer);
        } else {
            $this->Customer = $customer;
        }
        return $this;
    }
    /**
     * Add item to Customer value
     * @throws \InvalidArgumentException
     * @param \StructType\Customer $item
     * @return \ArrayType\ArrayOfCustomer
     */
    public function addToCustomer(\StructType\Customer $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Customer) {
            throw new \InvalidArgumentException(sprintf('The Customer property can only contain items of \StructType\Customer, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Customer[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Customer|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Customer|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Customer|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Customer|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Customer|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Customer
     */
    public function getAttributeName()
    {
        return 'Customer';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfCustomer
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
