<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfBasicDataset ArrayType
 * @subpackage Arrays
 */
class ArrayOfBasicDataset extends AbstractStructArrayBase
{
    /**
     * The BasicDataset
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BasicDataset[]
     */
    public $BasicDataset;
    /**
     * Constructor method for ArrayOfBasicDataset
     * @uses ArrayOfBasicDataset::setBasicDataset()
     * @param \StructType\BasicDataset[] $basicDataset
     */
    public function __construct(array $basicDataset = array())
    {
        $this
            ->setBasicDataset($basicDataset);
    }
    /**
     * Get BasicDataset value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BasicDataset[]|null
     */
    public function getBasicDataset()
    {
        return isset($this->BasicDataset) ? $this->BasicDataset : null;
    }
    /**
     * Set BasicDataset value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\BasicDataset[] $basicDataset
     * @return \ArrayType\ArrayOfBasicDataset
     */
    public function setBasicDataset(array $basicDataset = array())
    {
        foreach ($basicDataset as $arrayOfBasicDatasetBasicDatasetItem) {
            // validation for constraint: itemType
            if (!$arrayOfBasicDatasetBasicDatasetItem instanceof \StructType\BasicDataset) {
                throw new \InvalidArgumentException(sprintf('The BasicDataset property can only contain items of \StructType\BasicDataset, "%s" given', is_object($arrayOfBasicDatasetBasicDatasetItem) ? get_class($arrayOfBasicDatasetBasicDatasetItem) : gettype($arrayOfBasicDatasetBasicDatasetItem)), __LINE__);
            }
        }
        if (is_null($basicDataset) || (is_array($basicDataset) && empty($basicDataset))) {
            unset($this->BasicDataset);
        } else {
            $this->BasicDataset = $basicDataset;
        }
        return $this;
    }
    /**
     * Add item to BasicDataset value
     * @throws \InvalidArgumentException
     * @param \StructType\BasicDataset $item
     * @return \ArrayType\ArrayOfBasicDataset
     */
    public function addToBasicDataset(\StructType\BasicDataset $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\BasicDataset) {
            throw new \InvalidArgumentException(sprintf('The BasicDataset property can only contain items of \StructType\BasicDataset, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->BasicDataset[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\BasicDataset|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\BasicDataset|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\BasicDataset|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\BasicDataset|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\BasicDataset|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string BasicDataset
     */
    public function getAttributeName()
    {
        return 'BasicDataset';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfBasicDataset
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
