<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfBankTransaction ArrayType
 * @subpackage Arrays
 */
class ArrayOfBankTransaction extends AbstractStructArrayBase
{
    /**
     * The BankTransaction
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BankTransaction[]
     */
    public $BankTransaction;
    /**
     * Constructor method for ArrayOfBankTransaction
     * @uses ArrayOfBankTransaction::setBankTransaction()
     * @param \StructType\BankTransaction[] $bankTransaction
     */
    public function __construct(array $bankTransaction = array())
    {
        $this
            ->setBankTransaction($bankTransaction);
    }
    /**
     * Get BankTransaction value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BankTransaction[]|null
     */
    public function getBankTransaction()
    {
        return isset($this->BankTransaction) ? $this->BankTransaction : null;
    }
    /**
     * Set BankTransaction value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\BankTransaction[] $bankTransaction
     * @return \ArrayType\ArrayOfBankTransaction
     */
    public function setBankTransaction(array $bankTransaction = array())
    {
        foreach ($bankTransaction as $arrayOfBankTransactionBankTransactionItem) {
            // validation for constraint: itemType
            if (!$arrayOfBankTransactionBankTransactionItem instanceof \StructType\BankTransaction) {
                throw new \InvalidArgumentException(sprintf('The BankTransaction property can only contain items of \StructType\BankTransaction, "%s" given', is_object($arrayOfBankTransactionBankTransactionItem) ? get_class($arrayOfBankTransactionBankTransactionItem) : gettype($arrayOfBankTransactionBankTransactionItem)), __LINE__);
            }
        }
        if (is_null($bankTransaction) || (is_array($bankTransaction) && empty($bankTransaction))) {
            unset($this->BankTransaction);
        } else {
            $this->BankTransaction = $bankTransaction;
        }
        return $this;
    }
    /**
     * Add item to BankTransaction value
     * @throws \InvalidArgumentException
     * @param \StructType\BankTransaction $item
     * @return \ArrayType\ArrayOfBankTransaction
     */
    public function addToBankTransaction(\StructType\BankTransaction $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\BankTransaction) {
            throw new \InvalidArgumentException(sprintf('The BankTransaction property can only contain items of \StructType\BankTransaction, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->BankTransaction[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\BankTransaction|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\BankTransaction|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\BankTransaction|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\BankTransaction|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\BankTransaction|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string BankTransaction
     */
    public function getAttributeName()
    {
        return 'BankTransaction';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfBankTransaction
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
