<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SetSupplierVATNumber StructType
 * @subpackage Structs
 */
class SetSupplierVATNumber extends AbstractStructBase
{
    /**
     * The UserName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UserName;
    /**
     * The Password
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Password;
    /**
     * The SupVATNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SupVATNumber;
    /**
     * The SupplierCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SupplierCode;
    /**
     * Constructor method for SetSupplierVATNumber
     * @uses SetSupplierVATNumber::setUserName()
     * @uses SetSupplierVATNumber::setPassword()
     * @uses SetSupplierVATNumber::setSupVATNumber()
     * @uses SetSupplierVATNumber::setSupplierCode()
     * @param string $userName
     * @param string $password
     * @param string $supVATNumber
     * @param string $supplierCode
     */
    public function __construct($userName = null, $password = null, $supVATNumber = null, $supplierCode = null)
    {
        $this
            ->setUserName($userName)
            ->setPassword($password)
            ->setSupVATNumber($supVATNumber)
            ->setSupplierCode($supplierCode);
    }
    /**
     * Get UserName value
     * @return string|null
     */
    public function getUserName()
    {
        return $this->UserName;
    }
    /**
     * Set UserName value
     * @param string $userName
     * @return \StructType\SetSupplierVATNumber
     */
    public function setUserName($userName = null)
    {
        // validation for constraint: string
        if (!is_null($userName) && !is_string($userName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userName)), __LINE__);
        }
        $this->UserName = $userName;
        return $this;
    }
    /**
     * Get Password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->Password;
    }
    /**
     * Set Password value
     * @param string $password
     * @return \StructType\SetSupplierVATNumber
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->Password = $password;
        return $this;
    }
    /**
     * Get SupVATNumber value
     * @return string|null
     */
    public function getSupVATNumber()
    {
        return $this->SupVATNumber;
    }
    /**
     * Set SupVATNumber value
     * @param string $supVATNumber
     * @return \StructType\SetSupplierVATNumber
     */
    public function setSupVATNumber($supVATNumber = null)
    {
        // validation for constraint: string
        if (!is_null($supVATNumber) && !is_string($supVATNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($supVATNumber)), __LINE__);
        }
        $this->SupVATNumber = $supVATNumber;
        return $this;
    }
    /**
     * Get SupplierCode value
     * @return string|null
     */
    public function getSupplierCode()
    {
        return $this->SupplierCode;
    }
    /**
     * Set SupplierCode value
     * @param string $supplierCode
     * @return \StructType\SetSupplierVATNumber
     */
    public function setSupplierCode($supplierCode = null)
    {
        // validation for constraint: string
        if (!is_null($supplierCode) && !is_string($supplierCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($supplierCode)), __LINE__);
        }
        $this->SupplierCode = $supplierCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SetSupplierVATNumber
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
